/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.sharding.common.util;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.db.DBRoute;
import kd.bos.util.StringUtils;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.sharding.config.MainTableConfig;
import kd.bos.xdb.tablemanager.TableManager;
import kd.bos.xdb.tablemanager.TableName;
import kd.bos.xdb.tablemanager.meta.Column;
import kd.bos.xdb.tablemanager.meta.MetaFactory;

public class TableManagerUtil {
    public static final String delim = "#";

    public static void validate(String table, Map<String, Set<String>> inconsistentTables) throws SQLException {
        MainTableConfig mainConfig;
        Set archiveRoutes;
        TableName tableName = TableName.of((String)table);
        String prototypeTable = tableName.getPrototypeTable();
        List prototypeColumnList = MetaFactory.getMeta().queryColumns(prototypeTable);
        String originalTable = tableName.getOriginalsnapTable();
        List originalColumnList = MetaFactory.getMeta().queryColumns(originalTable);
        if (!TableManagerUtil.isColumnMatch(prototypeColumnList, originalColumnList)) {
            inconsistentTables.computeIfAbsent(prototypeTable, key -> new HashSet()).add(originalTable);
        }
        if ((archiveRoutes = (mainConfig = XDBConfig.getShardingConfigProvider().getMainConfig(tableName.getOriginalName())).getOptions().getIndexRoute().getAllArchiveRoutes()) != null && archiveRoutes.size() > 0) {
            for (String routeStr : archiveRoutes) {
                List routePrototypeColumnList = MetaFactory.getMeta().queryColumns(routeStr, prototypeTable);
                if (TableManagerUtil.isColumnMatch(prototypeColumnList, routePrototypeColumnList)) continue;
                inconsistentTables.computeIfAbsent(prototypeTable, key -> new HashSet()).add(routeStr + delim + prototypeTable);
            }
        }
        TableManager tm = XDBConfig.getTableManager();
        List<String> shardingTables = Arrays.asList(tm.getShardingTable(tableName.getOriginalName()));
        shardingTables.sort((key1, key2) -> {
            long tableName1 = TableName.of((String)key1).getShardingIndex();
            long tableName2 = TableName.of((String)key2).getShardingIndex();
            return (int)(tableName1 - tableName2);
        });
        if (shardingTables.size() > 0) {
            for (String shardingTable : shardingTables) {
                String curRoute;
                String shardRoute = mainConfig.getOptions().getIndexRoute().getRoute(shardingTable);
                String string = curRoute = StringUtils.isEmpty((String)shardRoute) ? mainConfig.getOptions().getDbRouteKey() : shardRoute;
                List shardingColumnList = MetaFactory.getMeta().queryColumns(curRoute, shardingTable);
                if (TableManagerUtil.isColumnMatch(prototypeColumnList, shardingColumnList)) continue;
                inconsistentTables.computeIfAbsent(prototypeTable, key -> new HashSet()).add(shardingTable);
            }
        }
    }

    private static boolean isColumnMatch(List<Column> columnList, List<Column> toCompareColumnList) {
        if (columnList.size() != toCompareColumnList.size()) {
            return false;
        }
        HashMap<String, Column> oriTableColumnMap = new HashMap<String, Column>(3);
        for (Column column : columnList) {
            oriTableColumnMap.put(column.getColumnName(), column);
        }
        HashMap<String, Column> shardTableColumnMap = new HashMap<String, Column>(3);
        for (Column column : toCompareColumnList) {
            shardTableColumnMap.put(column.getColumnName(), column);
        }
        for (Map.Entry entry : oriTableColumnMap.entrySet()) {
            String key = (String)entry.getKey();
            Column column = (Column)entry.getValue();
            Column column2 = (Column)shardTableColumnMap.get(key);
            if (column2 != null && column2.equals((Object)column)) continue;
            return false;
        }
        return true;
    }

    public static void fixDDL(DBRoute dbRoute, String toFixTable) {
        String key;
        String[] toFixTableArray = toFixTable.split(delim);
        String targetRoute = dbRoute.getRouteKey();
        String targetTable = toFixTable;
        if (toFixTableArray.length > 1) {
            targetRoute = toFixTableArray[0];
            targetTable = toFixTableArray[1];
        }
        TableName tableName = TableName.of((String)targetTable);
        MainTableConfig mainConfig = XDBConfig.getShardingConfigProvider().getMainConfig(tableName.getOriginalName());
        if (tableName.isDataTable()) {
            String curRoute = mainConfig.getOptions().getIndexRoute().getRoute(targetTable);
            targetRoute = StringUtils.isEmpty((String)curRoute) ? mainConfig.getOptions().getDbRouteKey() : curRoute;
        }
        String prototypeTable = tableName.getPrototypeTable();
        List prototypeColumns = MetaFactory.getMeta().queryColumns(prototypeTable);
        HashMap<String, Column> prototypeColumnMap = new HashMap<String, Column>(3);
        for (Column column : prototypeColumns) {
            prototypeColumnMap.put(column.getColumnName(), column);
        }
        List targetColumns = MetaFactory.getMeta().queryColumns(targetRoute, targetTable);
        HashMap<String, Column> targetColumnMap = new HashMap<String, Column>(3);
        for (Column toCompareColumn : targetColumns) {
            targetColumnMap.put(toCompareColumn.getColumnName(), toCompareColumn);
        }
        ArrayList prototypeExistsTargetNotInColumns = new ArrayList(3);
        ArrayList targetExistsPrototypeNotInColumns = new ArrayList(3);
        for (Map.Entry entry : prototypeColumnMap.entrySet()) {
            key = (String)entry.getKey();
            if (targetColumnMap.containsKey(key)) continue;
            prototypeExistsTargetNotInColumns.add(entry.getValue());
        }
        for (Map.Entry entry : targetColumnMap.entrySet()) {
            key = (String)entry.getKey();
            if (prototypeColumnMap.containsKey(key)) continue;
            targetExistsPrototypeNotInColumns.add(entry.getValue());
        }
        for (Column column : prototypeExistsTargetNotInColumns) {
            MetaFactory.getMeta().addColumn(targetRoute, targetTable, column);
        }
        for (Column column : targetExistsPrototypeNotInColumns) {
            MetaFactory.getMeta().dropColumn(targetRoute, targetTable, column.getColumnName());
        }
    }
}

