/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.sharding.common.util;

import com.alibaba.druid.util.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.cbs.plugin.sharding.common.validate.GuassDDLValidate;
import kd.bos.cbs.plugin.sharding.common.validate.MysqlDDLValidate;
import kd.bos.cbs.plugin.sharding.common.validate.OracleDDLValidate;
import kd.bos.cbs.plugin.sharding.common.validate.PostGreDDLValidate;
import kd.bos.db.DBRoute;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.datasource.ConnectionProvider;
import kd.bos.xdb.datasource.DBType;
import kd.bos.xdb.sharding.config.MainTableConfig;
import kd.bos.xdb.tablemanager.TableName;

public class ValidateDDLUtil {
    public static void validate(DBRoute dbRoute, String prototypeTable, ArrayList<String> shardingTables, Map<String, Set<String>> inconsistentTables) {
        for (String table : shardingTables) {
            if (!ValidateDDLUtil.isDifferent(dbRoute, prototypeTable, table)) continue;
            inconsistentTables.computeIfAbsent(prototypeTable, key -> new HashSet()).add(table);
        }
    }

    private static boolean isDifferent(DBRoute dbRoute, String prototypeTable, String table) {
        DBRoute shardTableRoute = DBRoute.of((String)ValidateDDLUtil.getRouteOfTable(table));
        DBType dbType = ConnectionProvider.get().getConnectionHolder().getDBType();
        switch (dbType) {
            case dm: 
            case oracle: {
                return new OracleDDLValidate(dbRoute, shardTableRoute, prototypeTable, table).validate();
            }
            case gs: 
            case gs100: {
                return new GuassDDLValidate(dbRoute, shardTableRoute, prototypeTable, table).validate();
            }
            case mysql: {
                return new MysqlDDLValidate(dbRoute, shardTableRoute, prototypeTable, table).validate();
            }
            case postgresql: {
                return new PostGreDDLValidate(dbRoute, shardTableRoute, prototypeTable, table).validate();
            }
        }
        return false;
    }

    public static void fixDDL(DBRoute dbRoute, String prototypeTable, String toFixTable) {
        DBRoute shardTableRoute = DBRoute.of((String)ValidateDDLUtil.getRouteOfTable(toFixTable));
        DBType dbType = ConnectionProvider.get().getConnectionHolder().getDBType();
        switch (dbType) {
            case dm: 
            case oracle: {
                new OracleDDLValidate(dbRoute, shardTableRoute, prototypeTable, toFixTable).fix();
                break;
            }
            case mysql: {
                new MysqlDDLValidate(dbRoute, shardTableRoute, prototypeTable, toFixTable).fix();
                break;
            }
            case postgresql: {
                new PostGreDDLValidate(dbRoute, shardTableRoute, prototypeTable, toFixTable).fix();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported DBType:" + dbType, new Exception().getCause());
            }
        }
    }

    private static String getRouteOfTable(String tableName) {
        String originalName = TableName.of((String)tableName).getOriginalName();
        MainTableConfig mainConfig = XDBConfig.getShardingConfigProvider().getMainConfig(originalName);
        String curRoute = mainConfig.getOptions().getIndexRoute().getRoute(tableName);
        return StringUtils.isEmpty((String)curRoute) ? mainConfig.getOptions().getDbRouteKey() : curRoute;
    }
}

