/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.sharding.common.validate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kd.bos.cbs.plugin.sharding.common.validate.Column;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public abstract class AbstractDDLValidate {
    private static final Log log = LogFactory.getLog(AbstractDDLValidate.class);
    protected DBRoute dbRoute;
    protected DBRoute shardTableRoute;
    protected String compareTable;
    protected String toCompareTable;
    protected List<Column> columns;
    protected List<Column> toCompareColumns;
    protected static final String TMP_SUFFIX = "$tmp";
    protected static final String DROP_COLUMN_KSQL = "EXEC p_AlterColumn ?, ?, 'NULL', 'NULL', '1001', 'NULL'";

    public AbstractDDLValidate(DBRoute dbRoute, String compareTable, String toCompareTable) {
        this.dbRoute = dbRoute;
        this.compareTable = compareTable;
        this.toCompareTable = toCompareTable;
        this.doQueryColumns();
    }

    public AbstractDDLValidate(DBRoute dbRoute, DBRoute shardTableRoute, String compareTable, String toCompareTable) {
        this.dbRoute = dbRoute;
        this.shardTableRoute = shardTableRoute;
        this.compareTable = compareTable;
        this.toCompareTable = toCompareTable;
        this.doQueryColumns();
    }

    abstract List<Column> queryColumns(String var1);

    abstract List<Column> queryColumns(String var1, DBRoute var2);

    final void doQueryColumns() {
        if (this.columns == null) {
            this.columns = this.queryColumns(this.compareTable, this.dbRoute);
        }
        if (this.toCompareColumns == null) {
            this.toCompareColumns = this.queryColumns(this.toCompareTable, this.shardTableRoute);
        }
    }

    abstract void dropAndAddColumn(Set<Column> var1);

    abstract Map<String, List<Column>> queryIndexInColumns(Set<Column> var1);

    public final boolean validate() {
        if (this.columns.size() != this.toCompareColumns.size()) {
            return true;
        }
        HashMap<String, Column> oriTableColumnMap = new HashMap<String, Column>();
        HashMap<String, Column> shardTableColumnMap = new HashMap<String, Column>();
        for (Column column : this.columns) {
            oriTableColumnMap.put(column.getColumnName(), column);
        }
        for (Column column : this.toCompareColumns) {
            shardTableColumnMap.put(column.getColumnName(), column);
        }
        for (Map.Entry entry : oriTableColumnMap.entrySet()) {
            String key = (String)entry.getKey();
            Column column = (Column)entry.getValue();
            Column column2 = (Column)shardTableColumnMap.get(key);
            if (column2 != null && column2.equals(column)) continue;
            return true;
        }
        return false;
    }

    public final void fix() {
        String key;
        this.removeTempColumnFirst();
        HashMap<String, Column> oriTableColumnMap = new HashMap<String, Column>();
        HashMap<String, Column> shardTableColumnMap = new HashMap<String, Column>();
        for (Column column : this.columns) {
            oriTableColumnMap.put(column.getColumnName(), column);
        }
        for (Column toCompareColumn : this.toCompareColumns) {
            shardTableColumnMap.put(toCompareColumn.getColumnName(), toCompareColumn);
        }
        ArrayList oriMapNotInShardMap = new ArrayList(oriTableColumnMap.size());
        ArrayList shardMapNotInOriMap = new ArrayList();
        ArrayList differentColumn = new ArrayList();
        for (Map.Entry entry : oriTableColumnMap.entrySet()) {
            key = (String)entry.getKey();
            if (shardTableColumnMap.containsKey(key)) continue;
            oriMapNotInShardMap.add(entry.getValue());
        }
        for (Map.Entry entry : shardTableColumnMap.entrySet()) {
            key = (String)entry.getKey();
            if (oriTableColumnMap.containsKey(key)) continue;
            shardMapNotInOriMap.add(entry.getValue());
        }
        for (Map.Entry entry : oriTableColumnMap.entrySet()) {
            key = (String)entry.getKey();
            Column column = (Column)entry.getValue();
            Column column2 = (Column)shardTableColumnMap.get(key);
            if (column2 == null || column.equals(column2)) continue;
            differentColumn.add(entry.getValue());
        }
        Set columnNames = this.columns.stream().map(Column::getColumnName).collect(Collectors.toSet());
        Set toCompareColumnNames = this.toCompareColumns.stream().map(Column::getColumnName).collect(Collectors.toSet());
        columnNames.removeAll(toCompareColumnNames);
        TreeSet<Column> lackedColumns = new TreeSet<Column>(Comparator.comparing(Column::getColumnId));
        if (!columnNames.isEmpty()) {
            block5: for (String columnName : columnNames) {
                for (Column column : this.columns) {
                    if (!columnName.equals(column.getColumnName())) continue;
                    lackedColumns.add(column);
                    continue block5;
                }
            }
            if (log.isInfoEnabled()) {
                log.info("AbstractDDLValidate lackColumns:" + Arrays.toString(columnNames.toArray()));
            }
            Map<String, List<Column>> queryIndexInColumns = this.queryIndexInColumns(lackedColumns);
            this.dropAndAddColumn(lackedColumns);
            this.recoverIndexToColumn(queryIndexInColumns);
        }
        for (Column column : shardMapNotInOriMap) {
            this.dropColumn(this.toCompareTable, this.shardTableRoute, column);
        }
        this.dropAndAddColumn(new HashSet<Column>(differentColumn));
    }

    @Deprecated
    public final void __fix() {
        this.removeTempColumnFirst();
        int columnSize = this.columns.size();
        int toCompareSize = this.toCompareColumns.size();
        if (columnSize > toCompareSize) {
            Column toCompareLastColumn = this.toCompareColumns.get(toCompareSize - 1);
            Column atCurrentPosColumn = this.columns.get(toCompareSize - 1);
            HashSet<Column> lackedColumns = new HashSet<Column>();
            if (atCurrentPosColumn.equals(toCompareLastColumn)) {
                for (int i = toCompareSize; i < columnSize; ++i) {
                    Column column2 = this.columns.get(i);
                    lackedColumns.add(column2);
                }
                Map<String, List<Column>> queryIndexInColumns = this.queryIndexInColumns(lackedColumns);
                this.dropAndAddColumn(lackedColumns);
                this.recoverIndexToColumn(queryIndexInColumns);
            } else {
                HashSet<Column> modifyColumns = new HashSet<Column>();
                for (int i = 0; i < columnSize; ++i) {
                    Column column3 = this.columns.get(i);
                    if (toCompareSize <= i) {
                        lackedColumns.add(column3);
                        continue;
                    }
                    if (column3.equals(this.toCompareColumns.get(i))) continue;
                    lackedColumns.add(column3);
                    modifyColumns.add(this.toCompareColumns.get(i));
                }
                lackedColumns.removeIf(column -> {
                    String columnName = column.getColumnName();
                    for (Column c : modifyColumns) {
                        if (!columnName.equals(c.getColumnName())) continue;
                        return true;
                    }
                    return false;
                });
                this.modifyColumn(modifyColumns, lackedColumns);
            }
        } else {
            HashSet<Column> modifyColumn = new HashSet<Column>();
            for (int i = 0; i < columnSize; ++i) {
                Column column4 = this.columns.get(i);
                if (column4.equals(this.toCompareColumns.get(i))) continue;
                modifyColumn.add(column4);
            }
            if (!modifyColumn.isEmpty()) {
                this.modifyColumn(modifyColumn, null);
            }
        }
    }

    private void removeTempColumnFirst() {
        boolean hasTemp = false;
        HashSet<Column> modifyColumns = new HashSet<Column>(2);
        int columnId = -1;
        for (Column column : this.toCompareColumns) {
            String columnName = column.getColumnName().toLowerCase(Locale.ENGLISH);
            if (!columnName.endsWith(TMP_SUFFIX)) continue;
            this.dropColumn(this.toCompareTable, this.shardTableRoute, column);
            if (log.isInfoEnabled()) {
                log.info("AbstractDDLValidate tableName:" + this.toCompareColumns + "@tmpColumn:" + columnName);
            }
            hasTemp = true;
            if (columnId != -1) continue;
            columnId = column.getColumnId();
        }
        if (hasTemp) {
            this.toCompareColumns = this.queryColumns(this.toCompareTable, this.shardTableRoute);
            for (int i = columnId; i <= this.toCompareColumns.size(); ++i) {
                modifyColumns.add(this.toCompareColumns.get(i - 1));
            }
            if (!modifyColumns.isEmpty()) {
                Map<String, List<Column>> queryIndexInColumns = this.queryIndexInColumns(modifyColumns);
                this.recoverIndexToColumn(queryIndexInColumns);
            }
        }
    }

    private void modifyColumn(Set<Column> modifyColumns, Set<Column> lackedColumns) {
        TreeSet<Column> columnSet = new TreeSet<Column>(Comparator.comparing(Column::getColumnId));
        if (null == lackedColumns) {
            columnSet.addAll(modifyColumns);
        } else {
            block0: for (Column m : modifyColumns) {
                String columnName = m.getColumnName();
                for (Column c : this.columns) {
                    if (!columnName.equals(c.getColumnName())) continue;
                    columnSet.add(c);
                    continue block0;
                }
            }
            columnSet.addAll(lackedColumns);
        }
        Map<String, List<Column>> queryIndexInColumns = this.queryIndexInColumns(columnSet);
        HashSet<Column> collectSet = new HashSet<Column>(modifyColumns.size());
        modifyColumns.forEach(column -> {
            Column c = new Column();
            c.setColumnName(column.getColumnName() + TMP_SUFFIX);
            c.setDataType(column.getDataType());
            c.setDataLength(column.getDataLength());
            c.setDataPrecision(column.getDataPrecision());
            c.setDataScale(column.getDataScale());
            c.setNullable(column.isNullable());
            c.setDataDefault(column.getDataDefault());
            c.setColumnId(column.getColumnId());
            collectSet.add(c);
        });
        this.dropAndAddColumn(collectSet);
        this.moveDataToTempColumn(modifyColumns, true);
        this.dropAndAddColumn(columnSet);
        this.moveDataToTempColumn(modifyColumns, false);
        this.recoverIndexToColumn(queryIndexInColumns);
        for (Column c : collectSet) {
            this.dropColumn(this.toCompareTable, c);
        }
    }

    private final void recoverIndexToColumn(Map<String, List<Column>> queryIndexInColumns) {
        if (!queryIndexInColumns.isEmpty()) {
            int indexOf = this.toCompareTable.lastIndexOf("$");
            String shardingIndex = this.toCompareTable.substring(indexOf);
            queryIndexInColumns.forEach((k, v) -> {
                int p = k.lastIndexOf("$");
                String indexName = k;
                if (p != -1) {
                    indexName = k.substring(0, p).toUpperCase();
                }
                indexName = indexName + shardingIndex;
                StringBuilder fields = new StringBuilder(128);
                for (int i = 0; i < v.size(); ++i) {
                    if (i > 0) {
                        fields.append(',');
                    }
                    fields.append(((Column)v.get(i)).getColumnName());
                }
                String fieldsStr = fields.toString();
                String recoverSql = "IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = '" + indexName + "') CREATE INDEX " + indexName + " ON " + this.toCompareTable.toUpperCase() + " ( " + fieldsStr + " )";
                DB.execute((DBRoute)this.shardTableRoute, (String)recoverSql);
            });
        }
    }

    private final void moveDataToTempColumn(Set<Column> modifyColumns, boolean toTemp) {
        StringBuilder updateSql = new StringBuilder(128);
        for (Column column : modifyColumns) {
            updateSql.setLength(0);
            if (toTemp) {
                updateSql.append("UPDATE ").append(this.toCompareTable).append(" SET ").append(column.getColumnName()).append(TMP_SUFFIX).append(" = ").append(column.getColumnName());
            } else {
                updateSql.append("UPDATE ").append(this.toCompareTable).append(" SET ").append(column.getColumnName()).append(" = ").append(column.getColumnName()).append(TMP_SUFFIX);
            }
            DB.execute((DBRoute)this.dbRoute, (String)updateSql.toString());
        }
    }

    protected void dropColumn(String table, Column column) {
        DB.execute((DBRoute)this.dbRoute, (String)DROP_COLUMN_KSQL, (Object[])new Object[]{table.toUpperCase(), column.getColumnName().toUpperCase()});
    }

    protected void dropColumn(String table, DBRoute curDBRoute, Column column) {
        DB.execute((DBRoute)curDBRoute, (String)DROP_COLUMN_KSQL, (Object[])new Object[]{table.toUpperCase(), column.getColumnName().toUpperCase()});
    }

    protected final int parseIntNullAsZero(String string) {
        return string == null ? 0 : Integer.parseInt(string);
    }

    protected final long parseLongNullAsZero(String string) {
        return string == null ? 0L : Long.parseLong(string);
    }
}

