/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.sharding.common.validate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cbs.plugin.sharding.common.validate.AbstractDDLValidate;
import kd.bos.cbs.plugin.sharding.common.validate.Column;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.util.StringUtils;
import kd.bos.xdb.ext.KSQL;
import kd.bos.xdb.hint.NoShardingHint;

public class MysqlDDLValidate
extends AbstractDDLValidate {
    private static final String SQL = KSQL.dialect((String)NoShardingHint.genNoShardingSQL((String)"select column_name,data_type,character_maximum_length,numeric_precision,numeric_scale,is_nullable,column_default,ordinal_position from information_schema.columns where table_schema = schema() and (table_name=?) order by ordinal_position"));

    public MysqlDDLValidate(DBRoute dbRoute, String compareTable, String toCompareTable) {
        super(dbRoute, compareTable, toCompareTable);
    }

    public MysqlDDLValidate(DBRoute dbRoute, DBRoute shardTableRoute, String compareTable, String toCompareTable) {
        super(dbRoute, shardTableRoute, compareTable, toCompareTable);
    }

    @Override
    List<Column> queryColumns(String table) {
        return this.queryColumns(table, this.dbRoute);
    }

    @Override
    List<Column> queryColumns(String table, DBRoute curDBRoute) {
        List mysqlRet = (List)DB.query((DBRoute)curDBRoute, (String)SQL, (Object[])new Object[]{table}, rs -> {
            ArrayList<Column> mysqlQuery = new ArrayList<Column>(8);
            while (rs.next()) {
                Column mysqlColumn = new Column();
                mysqlColumn.setColumnName(rs.getString("column_name"));
                String dataType = rs.getString("data_type");
                mysqlColumn.setDataType(dataType);
                mysqlColumn.setDataLength(this.parseLongNullAsZero(rs.getString("character_maximum_length")));
                mysqlColumn.setDataPrecision(this.parseIntNullAsZero(rs.getString("numeric_precision")));
                mysqlColumn.setDataScale(this.parseIntNullAsZero(rs.getString("numeric_scale")));
                mysqlColumn.setNullable("YES".equals(rs.getString("is_nullable")));
                if ("bigint".equals(dataType) || "smallint".equals(dataType) || "int".equals(dataType) || "decimal".equals(dataType)) {
                    mysqlColumn.setDataDefault(0);
                } else if ("varchar".equals(dataType)) {
                    mysqlColumn.setDataDefault(Character.valueOf(' '));
                } else if ("char".equals(dataType)) {
                    String column_default = rs.getString("column_default");
                    mysqlColumn.setDataDefault(StringUtils.isEmpty((String)column_default) ? Character.valueOf(' ') : ("'0'".equals(column_default.trim()) ? Character.valueOf('0') : column_default.trim()));
                }
                mysqlColumn.setColumnId(Integer.parseInt(rs.getString("ordinal_position")));
                mysqlQuery.add(mysqlColumn);
            }
            return mysqlQuery;
        });
        return mysqlRet;
    }

    @Override
    void dropAndAddColumn(Set<Column> lackedColumn) {
        StringBuilder mysqlAddSql = new StringBuilder(256);
        for (Column column : lackedColumn) {
            mysqlAddSql.setLength(0);
            mysqlAddSql.append("alter table ").append(this.toCompareTable).append(" add ").append(column.getColumnName()).append(' ');
            String dataType = column.getDataType();
            long dataLength = column.getDataLength();
            int dataScale = column.getDataScale();
            int dataPrecision = column.getDataPrecision();
            switch (dataType) {
                case "date": {
                    mysqlAddSql.append("date");
                    break;
                }
                case "datetime": {
                    mysqlAddSql.append("datetime");
                    break;
                }
                case "bigint": 
                case "smallint": 
                case "int": 
                case "decimal": {
                    mysqlAddSql.append(dataType);
                    break;
                }
                default: {
                    mysqlAddSql.append(dataType);
                    if (dataScale != 0) {
                        mysqlAddSql.append("(").append(dataPrecision).append(",").append(dataScale).append(")");
                        break;
                    }
                    if (dataPrecision != 0) {
                        mysqlAddSql.append("(").append(dataPrecision).append(")");
                        break;
                    }
                    if (dataLength == 0L || dataType.equalsIgnoreCase("longtext") || dataType.equalsIgnoreCase("text")) break;
                    mysqlAddSql.append("(").append(dataLength).append(")");
                }
            }
            if (!column.isNullable()) {
                mysqlAddSql.append(" NOT NULL");
            }
            if ("bigint".equals(dataType) || "smallint".equals(dataType) || "int".equals(dataType) || "decimal".equals(dataType)) {
                mysqlAddSql.append(" DEFAULT 0");
            } else if ("varchar".equals(dataType)) {
                mysqlAddSql.append(" DEFAULT ' '");
            } else if ("char".equals(dataType) && dataLength == 1L) {
                mysqlAddSql.append(" DEFAULT ").append(column.getDataDefault());
            }
            this.dropColumn(this.toCompareTable, this.shardTableRoute, column);
            DB.execute((DBRoute)this.shardTableRoute, (String)KSQL.dialect((String)NoShardingHint.genNoShardingSQL((String)mysqlAddSql.toString())), (Object[])new Object[0]);
        }
    }

    @Override
    Map<String, List<Column>> queryIndexInColumns(Set<Column> columnSet) {
        HashMap<String, List<Column>> ret = new HashMap<String, List<Column>>(columnSet.size());
        String queryIndexSql = "select index_name from information_schema.statistics where table_schema = schema() and table_name=? and column_name = ? and index_name != 'PRIMARY'";
        String queryColumnExistIndexSql = "select column_name from information_schema.statistics where table_schema = schema() and index_name = ? order by seq_in_index asc";
        for (Column column : columnSet) {
            List columnList;
            String index = (String)DB.query((DBRoute)this.dbRoute, (String)KSQL.dialect((String)NoShardingHint.genNoShardingSQL((String)queryIndexSql)), (Object[])new Object[]{this.compareTable, column.getColumnName()}, rs -> {
                if (rs.next()) {
                    return rs.getString("index_name");
                }
                return null;
            });
            if (null == index || !(columnList = ret.computeIfAbsent(index, k -> new ArrayList(2))).isEmpty()) continue;
            List queryColumnName = (List)DB.query((DBRoute)this.dbRoute, (String)KSQL.dialect((String)NoShardingHint.genNoShardingSQL((String)queryColumnExistIndexSql)), (Object[])new Object[]{index}, rs -> {
                ArrayList<String> queryColumn = new ArrayList<String>(2);
                while (rs.next()) {
                    queryColumn.add(rs.getString("column_name"));
                }
                return queryColumn;
            });
            ArrayList collectColumn = new ArrayList(2);
            queryColumnName.forEach(name -> {
                for (Column c : this.columns) {
                    if (!name.equals(c.getColumnName())) continue;
                    collectColumn.add(c);
                    break;
                }
            });
            columnList.addAll(collectColumn);
        }
        return ret;
    }
}

