/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.sharding.common.validate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cbs.plugin.sharding.common.validate.AbstractDDLValidate;
import kd.bos.cbs.plugin.sharding.common.validate.Column;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.util.StringUtils;
import kd.bos.xdb.ext.KSQL;
import kd.bos.xdb.hint.NoShardingHint;

public class OracleDDLValidate
extends AbstractDDLValidate {
    private static final String SQL = KSQL.dialect((String)NoShardingHint.genNoShardingSQL((String)"select column_name,data_type,char_length,data_precision,data_scale,nullable,data_default,column_id,table_name from user_tab_columns  where table_name=? order by column_id"));

    public OracleDDLValidate(DBRoute dbRoute, String compareTable, String toCompareTable) {
        super(dbRoute, compareTable, toCompareTable);
    }

    public OracleDDLValidate(DBRoute dbRoute, DBRoute shardTableRoute, String compareTable, String toCompareTable) {
        super(dbRoute, shardTableRoute, compareTable, toCompareTable);
    }

    @Override
    List<Column> queryColumns(String table) {
        return this.queryColumns(table, this.dbRoute);
    }

    @Override
    List<Column> queryColumns(String table, DBRoute curDBRoute) {
        List oracleRet = (List)DB.query((DBRoute)curDBRoute, (String)SQL, (Object[])new Object[]{table.toUpperCase()}, rs -> {
            ArrayList<Column> oracleQuery = new ArrayList<Column>(8);
            while (rs.next()) {
                Column oracleColumn = new Column();
                oracleColumn.setColumnName(rs.getString("column_name"));
                String dataType = rs.getString("data_type");
                oracleColumn.setDataType(dataType);
                oracleColumn.setDataLength(this.parseLongNullAsZero(rs.getString("char_length")));
                oracleColumn.setDataPrecision(this.parseIntNullAsZero(rs.getString("data_precision")));
                oracleColumn.setDataScale(this.parseIntNullAsZero(rs.getString("data_scale")));
                oracleColumn.setNullable("Y".equals(rs.getString("nullable")));
                if ("NUMBER".equals(dataType) || "BINARY_BIGINT".equals(dataType)) {
                    oracleColumn.setDataDefault(0);
                } else if ("VARCHAR".equals(dataType)) {
                    oracleColumn.setDataDefault(Character.valueOf(' '));
                } else if ("CHAR".equals(dataType) || "NCHAR".equals(dataType)) {
                    String column_default = rs.getString("data_default").trim();
                    oracleColumn.setDataDefault(StringUtils.isEmpty((String)column_default) ? Character.valueOf(' ') : ("'0'".equals(column_default) ? Character.valueOf('0') : column_default));
                }
                oracleColumn.setColumnId(Integer.parseInt(rs.getString("column_id")));
                oracleQuery.add(oracleColumn);
            }
            return oracleQuery;
        });
        return oracleRet;
    }

    @Override
    void dropAndAddColumn(Set<Column> lackedColumn) {
        StringBuilder oracleAddSql = new StringBuilder(256);
        for (Column column : lackedColumn) {
            oracleAddSql.setLength(0);
            oracleAddSql.append("alter table ").append(this.toCompareTable.toUpperCase()).append(" add ").append(column.getColumnName()).append(' ');
            String dataType = column.getDataType();
            long dataLength = column.getDataLength();
            int dataScale = column.getDataScale();
            int dataPrecision = column.getDataPrecision();
            switch (dataType) {
                case "DATE": {
                    oracleAddSql.append("DATE");
                    break;
                }
                case "NUMBER": 
                case "DECIMAL": {
                    oracleAddSql.append(dataType);
                    break;
                }
                default: {
                    oracleAddSql.append(dataType);
                    if (dataScale != 0) {
                        oracleAddSql.append("(").append(dataPrecision).append(",").append(dataScale).append(")");
                        break;
                    }
                    if (dataPrecision != 0) {
                        oracleAddSql.append("(").append(dataPrecision).append(")");
                        break;
                    }
                    if (dataLength == 0L) break;
                    oracleAddSql.append("(").append(dataLength).append(")");
                }
            }
            if ("NUMBER".equals(dataType) || "DECIMAL".equals(dataType)) {
                oracleAddSql.append(" DEFAULT 0");
            } else if ("VARCHAR2".equals(dataType) || "NVARCHAR2".equals(dataType)) {
                oracleAddSql.append(" DEFAULT ' '");
            } else if ("CHAR".equals(dataType) && dataLength == 1L || "NCHAR".equals(dataType) && dataLength == 1L) {
                oracleAddSql.append(" DEFAULT '0'");
            }
            if (!column.isNullable()) {
                oracleAddSql.append(" NOT NULL");
            }
            this.dropColumn(this.toCompareTable, this.shardTableRoute, column);
            DB.execute((DBRoute)this.shardTableRoute, (String)KSQL.dialect((String)NoShardingHint.genNoShardingSQL((String)oracleAddSql.toString())), (Object[])new Object[0]);
        }
    }

    @Override
    Map<String, List<Column>> queryIndexInColumns(Set<Column> columnSet) {
        HashMap<String, List<Column>> oracleRet = new HashMap<String, List<Column>>(columnSet.size());
        String oracleQueryIndexSql = "select index_name from user_ind_columns where table_name=? and column_name = ?";
        String oracleQueryColumnExistIndexSql = "select column_name from user_ind_columns where index_name = ? order by column_position asc";
        for (Column column : columnSet) {
            List oracleColumnList;
            String oracleIndex = (String)DB.query((DBRoute)this.dbRoute, (String)KSQL.dialect((String)NoShardingHint.genNoShardingSQL((String)oracleQueryIndexSql)), (Object[])new Object[]{this.compareTable.toUpperCase(), column.getColumnName()}, rs -> {
                if (rs.next()) {
                    return rs.getString("index_name");
                }
                return null;
            });
            if (null == oracleIndex || !(oracleColumnList = oracleRet.computeIfAbsent(oracleIndex, k -> new ArrayList(2))).isEmpty()) continue;
            List oracleQueryColumnName = (List)DB.query((DBRoute)this.dbRoute, (String)KSQL.dialect((String)NoShardingHint.genNoShardingSQL((String)oracleQueryColumnExistIndexSql)), (Object[])new Object[]{oracleIndex}, rs -> {
                ArrayList<String> queryColumn = new ArrayList<String>(2);
                while (rs.next()) {
                    queryColumn.add(rs.getString("column_name"));
                }
                return queryColumn;
            });
            ArrayList oracleCollectColumn = new ArrayList(2);
            oracleQueryColumnName.forEach(name -> {
                for (Column c : this.columns) {
                    if (!name.equals(c.getColumnName())) continue;
                    oracleCollectColumn.add(c);
                    break;
                }
            });
            oracleColumnList.addAll(oracleCollectColumn);
        }
        return oracleRet;
    }
}

