/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.sharding.edit;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cbs.plugin.sharding.common.util.ShardingStrategyFormUtils;
import kd.bos.cbs.plugin.sharding.edit.ShardingAddConfigEditPlugin;
import kd.bos.cbs.plugin.tools.OperateLogUtil;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IEntryType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.xdb.enums.ShardConfigStatusEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShardingAddArchiConfigEditPlugin
extends ShardingAddConfigEditPlugin {
    private static Class<?> linkEntryType;
    private static Class<?> mulBasedataPropType;
    private static Logger log;

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        Map<String, String> map;
        String property = e.getProperty().getName();
        if ("entitynumber".equals(property) && !(map = this.getSelectedEntityNumberAndNameMap()).isEmpty()) {
            IFormView view = this.getView();
            IDataModel model = this.getModel();
            String entityNumber = map.get("number");
            if (formSet.contains(entityNumber)) {
                view.showMessage(ResManager.loadKDString((String)"\u5206\u7247\u76f8\u5173\u8868\u5355\u4e0d\u53ef\u8fdb\u884c\u5206\u5e93\u914d\u7f6e\uff1a%s\u3002", (String)"ShardingAddArchiConfigEditPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[]{entityNumber}));
                model.setValue("entitynumber", null);
                return;
            }
            try {
                if (ORM.create().exists("bos_cbs_archi_billset", new QFilter[]{new QFilter("entitynumber", "=", (Object)entityNumber)})) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u5df2\u914d\u7f6e\u6570\u636e\u5f52\u6863\uff0c\u65e0\u6cd5\u8fdb\u884c\u5206\u5e93\u914d\u7f6e\u3002", (String)"ShardingConfigEditPlugin_40", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                    model.setValue("entitynumber", null);
                    return;
                }
                if (ORM.create().exists("bos_cbs_shard_archi", new QFilter[]{new QFilter("entitynumber", "=", (Object)entityNumber)})) {
                    view.showMessage(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u5206\u5e93\u914d\u7f6e\uff1a%s\u3002", (String)"ShardingAddArchiConfigEditPlugin_1", (String)"bos-cbs-plugin", (Object[])new Object[]{entityNumber}));
                    model.setValue("entitynumber", null);
                    return;
                }
                QFilter qFilter = new QFilter("entitynumber", "=", (Object)entityNumber);
                qFilter.and(new QFilter("configstatus", "=", (Object)ShardConfigStatusEnum.ENABLE.getKey()));
                if (!ORM.create().exists("bos_cbs_shard_config", new QFilter[]{qFilter})) {
                    view.showMessage(ResManager.loadKDString((String)"\u7f16\u53f7\uff1a%s\uff0c\u5f53\u524d\u4e0d\u662f\u5206\u7247\u542f\u7528\u72b6\u6001\uff0c\u8bf7\u5728\u5206\u8868\u914d\u7f6e\u9875\u9762\u67e5\u770b\u914d\u7f6e\u72b6\u6001\u3002", (String)"ShardingAddArchiConfigEditPlugin_6", (String)"bos-cbs-plugin", (Object[])new Object[]{entityNumber}));
                    model.setValue("entitynumber", null);
                    return;
                }
                if (!this.validStrategyAndField(entityNumber)) {
                    model.setValue("entitynumber", null);
                    return;
                }
            }
            catch (Exception exception) {
                log.error("check archi config error: " + exception.getMessage(), (Throwable)exception);
                model.setValue("entitynumber", null);
                view.showMessage(ResManager.loadKDString((String)"\u68c0\u67e5\u5206\u5e93\u914d\u7f6e\u65f6\u53d1\u751f\u9519\u8bef\uff1a%s\u3002", (String)"ShardingAddArchiConfigEditPlugin_2", (String)"bos-cbs-plugin", (Object[])new Object[]{exception.getMessage()}));
            }
        }
    }

    @Override
    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("btn_ensure".equals(key)) {
            Object entityObj = this.getModel().getValue("entitynumber");
            if (entityObj == null) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u5b9e\u4f53\u3002", (String)"ShardingAddConfigEditPlugin_6", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                this.getModel().setValue("entitynumber", null);
                return;
            }
            IFormView view = this.getView();
            Map<String, Object> entityNumberMap = this.getSelectedEntityNumberAndNameILocaleStringMap();
            String entityNumber = (String)entityNumberMap.get("number");
            QFilter filter = new QFilter("entitynumber", "=", (Object)entityNumber);
            String selectFields = "id, shardingfields, strategy, strategyparams";
            DynamicObject shardConfig = BusinessDataServiceHelper.loadSingle((String)"bos_cbs_shard_config", (String)selectFields, (QFilter[])filter.toArray());
            DynamicObject newDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bos_cbs_shard_archi");
            long id = DB.genGlobalLongId();
            newDynamicObject.set("id", (Object)id);
            newDynamicObject.set("configid", shardConfig.get("id"));
            newDynamicObject.set("entitynumber", (Object)entityNumber);
            newDynamicObject.set("status", (Object)"0");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newDynamicObject});
            BillShowParameter fsp = new BillShowParameter();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.putAll(entityNumberMap);
            map.put("shardArchiTask", "true");
            map.put("configid", id);
            map.put("shardingfields", shardConfig.get("shardingfields"));
            map.put("number", entityNumber);
            map.put("strategy", shardConfig.get("strategy"));
            map.put("strategyparams", shardConfig.get("strategyparams"));
            fsp.setCustomParam("shardEntityInfoMap", map);
            fsp.setFormId("bos_cbs_shard_archi");
            fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            fsp.setStatus(OperationStatus.EDIT);
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "CONFIG_FORM_CALL_BACK"));
            fsp.setPkId((Object)id);
            fsp.setCaption(ResManager.loadKDString((String)"\u5206\u5e93\u914d\u7f6e", (String)"ShardingArchiListPlugin_3", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            view.showForm((FormShowParameter)fsp);
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object entityObj = this.getModel().getValue("entitynumber");
        if (entityObj == null) {
            args.setCancel(true);
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey = e.getOperateKey();
        if ("btn_ensure".equals(operateKey)) {
            String entityNumber = ((DynamicObject)this.getView().getModel().getValue("entitynumber")).getString("number");
            String opName = ResManager.loadKDString((String)"\u65b0\u589e", (String)"ShardingAddConfigEditPlugin_4", (String)"bos-cbs-plugin", (Object[])new Object[0]);
            String opDesc = String.format(ResManager.loadKDString((String)"\u7f16\u53f7\uff1a%s\uff0c\u65b0\u589e\u5206\u5e93\u914d\u7f6e\u6210\u529f\u3002", (String)"ShardingAddArchiConfigEditPlugin_5", (String)"bos-cbs-plugin", (Object[])new Object[0]), entityNumber);
            MultiLangEnumBridge langEnumBridge = new MultiLangEnumBridge("\u7f16\u53f7\uff1a%s\uff0c\u65b0\u589e\u5206\u5e93\u914d\u7f6e\u6210\u529f\u3002", "ShardingAddArchiConfigEditPlugin_5", "bos-cbs-plugin");
            OperateLogUtil.insertSimpleOperateLog(this.getView(), this.getModel().getDataEntityType().getName(), operateKey, opDesc, RequestContext.get().getOrgId(), entityNumber, langEnumBridge, entityNumber);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        switch (closedCallBackEvent.getActionId()) {
            case "CONFIG_FORM_CALL_BACK": {
                IFormView view = this.getView();
                if ("bos_list".equals(view.getParentView().getFormShowParameter().getFormId())) {
                    view.getParentView().invokeOperation("refresh");
                }
                view.close();
            }
        }
    }

    private boolean validStrategyAndField(String entityNumber) {
        boolean hasDateProp = false;
        QFilter filter = new QFilter("entitynumber", "=", (Object)entityNumber);
        String selectFields = "id, shardingfields, strategy, strategyparams";
        DynamicObject shardConfig = BusinessDataServiceHelper.loadSingle((String)"bos_cbs_shard_config", (String)selectFields, (QFilter[])filter.toArray());
        String shardingFields = shardConfig.getString("shardingfields");
        String[] fields = shardingFields.split(",");
        Set fieldsSet = Arrays.stream(fields).collect(Collectors.toSet());
        List<IDataEntityProperty> dps = ShardingStrategyFormUtils.getEntityPropertiesForSharding(entityNumber, false);
        for (IDataEntityProperty dp : dps) {
            if (!fieldsSet.contains(dp.getName()) || !(dp instanceof DateTimeProp)) continue;
            hasDateProp = true;
            break;
        }
        if (!hasDateProp) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u7f3a\u5c11\u65e5\u671f\u7c7b\u578b\u7684\u5206\u7247\u5c5e\u6027,\u65e0\u6cd5\u8fdb\u884c\u5206\u5e93\u914d\u7f6e\u3002", (String)"ShardingConfigEditPlugin_39", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            return false;
        }
        String value = shardConfig.getString("strategy");
        if ("custom_strategy".equals(value)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6240\u9009\u5206\u7247\u7b56\u7565\u4e0d\u652f\u6301\u5206\u5e93\u914d\u7f6e\uff1a\u81ea\u5b9a\u4e49\u7b56\u7565\u3002", (String)"ShardingConfigEditPlugin_44", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            return false;
        }
        if ("DateModStrategy".equals(value)) {
            String tip = ResManager.loadKDString((String)"\u6240\u9009\u5206\u7247\u7b56\u7565\u4e0d\u652f\u6301\u5206\u5e93\u5f52\u6863\uff1a\u65e5\u671f\u6c42\u6a21\u5206\u7247\u3002", (String)"ShardingConfigEditPlugin_43", (String)"bos-cbs-plugin", (Object[])new Object[0]);
            this.getView().showMessage(tip);
            return false;
        }
        IDataEntityType dt = ORM.create().getDataEntityType(entityNumber);
        if (!this.checkBasedataProp(dt, dt.getDBRouteKey())) {
            String tip = ResManager.loadKDString((String)"\u65e0\u6cd5\u8fdb\u884c\u5206\u5e93\u914d\u7f6e\uff0c\u56e0\u4e3a\u5b58\u5728\u540c\u5e93\u57fa\u7840\u8d44\u6599\u5b57\u6bb5\u6216\u591a\u9009\u57fa\u7840\u8d44\u6599\u5b57\u6bb5\u3002", (String)"ShardingConfigEditPlugin_48", (String)"bos-cbs-plugin", (Object[])new Object[0]);
            this.getView().showMessage(tip);
            return false;
        }
        return true;
    }

    private boolean checkBasedataProp(IDataEntityType dt, String mainEntityRouteKey) {
        DataEntityPropertyCollection dataEntityProperties = dt.getProperties();
        int n = dataEntityProperties.size();
        for (int i = 0; i < n; ++i) {
            boolean checkEntryBasedata;
            Class<?> cls;
            IDataEntityProperty dp = (IDataEntityProperty)dataEntityProperties.get(i);
            if (dp instanceof BasedataProp && !(dp instanceof FlexProp)) {
                String dbRouteKey = ((BasedataProp)dp).getComplexType().getDBRouteKey();
                if (!dbRouteKey.equals(mainEntityRouteKey)) continue;
                return false;
            }
            if (!(dp instanceof ICollectionProperty)) continue;
            IDataEntityType itemDT = ((ICollectionProperty)dp).getItemType();
            if (IEntryType.class.isAssignableFrom(itemDT.getClass()) && itemDT.getAlias() != null && itemDT.getAlias().trim().length() > 0 && !linkEntryType.isAssignableFrom(cls = itemDT.getClass()) && !(checkEntryBasedata = this.checkBasedataProp(itemDT, mainEntityRouteKey))) {
                return false;
            }
            if (!mulBasedataPropType.isAssignableFrom(dp.getClass()) || itemDT.getAlias() == null || itemDT.getAlias().trim().length() <= 0) continue;
            return false;
        }
        return true;
    }

    static {
        log = LoggerFactory.getLogger(ShardingAddArchiConfigEditPlugin.class);
        try {
            linkEntryType = Class.forName("kd.bos.entity.LinkEntryType");
            mulBasedataPropType = Class.forName("kd.bos.entity.property.MulBasedataProp");
        }
        catch (ClassNotFoundException e) {
            log.error("class forname error: " + e.getMessage(), (Throwable)e);
        }
    }
}

