/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.sharding.edit;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cbs.plugin.sharding.edit.ShardingCommonPlugin;
import kd.bos.cbs.plugin.statistics.common.util.XDBStatisticsHelper;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.entity.ShardArchiKanbanDetailEntity;
import kd.bos.xdb.entity.ShardArchiKanbanEntity;
import kd.bos.xdb.entity.ShardConfigEntity;
import kd.bos.xdb.repository.ShardArchiKanbanRepository;
import kd.bos.xdb.repository.ShardConfigRepository;
import kd.bos.xdb.sharding.config.MainTableConfig;
import kd.bos.xdb.sharding.config.ShardingConfig;
import kd.bos.xdb.sharding.config.ShardingIndexRoute;

public class ShardingArchiKanbanEditPlugin
extends ShardingCommonPlugin
implements SetFilterListener {
    private static final Log log = LogFactory.getLog(ShardingArchiKanbanEditPlugin.class);

    public void beforeBindData(EventObject e) {
        BillList taskList = (BillList)this.getView().getControl("config_billlistap");
        IDataModel model = this.getModel();
        QFilter qFilter = new QFilter("entitynumber", "=", model.getValue("entitynumber")).and(new QFilter("config", "=", this.getModel().getValue("archiconfig_id")));
        taskList.setFilter(qFilter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate op = (FormOperate)args.getSource();
        String operateKey = op.getOperateKey();
        IDataModel model = this.getModel();
        long id = (Long)model.getDataEntity().getPkValue();
        if (!QueryServiceHelper.exists((String)"bos_cbs_shard_archikanban", (Object)id)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6570\u636e\u53ef\u80fd\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"ShardingArchiEditPlugin_1", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if ("refresh".equals(operateKey)) {
            this.reinitShardArchiRoute((String)model.getValue("entitynumber"), id);
        }
        super.beforeDoOperation(args);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("showdetail".equals(operateKey)) {
            BillList billList = (BillList)this.getView().getControl("config_billlistap");
            Object primaryKeyValue = billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
            BillShowParameter bsp = new BillShowParameter();
            bsp.setStatus(OperationStatus.EDIT);
            bsp.setFormId("bos_cbs_shard_task");
            bsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            bsp.setCaption(ResManager.loadKDString((String)"\u5206\u8868\u5f52\u6863\u4efb\u52a1", (String)"ShardingConfigShowTaskEditPlugin_1", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            bsp.setPkId(primaryKeyValue);
            bsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "TASK_FORM_CALL_BACK"));
            this.getView().showForm((FormShowParameter)bsp);
        }
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        IDataModel model = this.getModel();
        QFilter qFilter = new QFilter("entitynumber", "=", model.getValue("entitynumber")).and(new QFilter("config", "=", this.getModel().getValue("archiconfig_id")));
        setFilterEvent.getCustomQFilters().add(qFilter);
    }

    private void reinitShardArchiRoute(String entityNumber, long fid) {
        IDataEntityType dt = ORM.create().getDataEntityType(entityNumber);
        String dbRouteKey = dt.getDBRouteKey();
        ShardConfigEntity configEntity = ShardConfigRepository.get().loadConfig(entityNumber);
        List shardingConfigs = configEntity.toShardingConfigs(false);
        MainTableConfig mainConfig = XDBConfig.getShardingConfigProvider().getConfigByEntity(entityNumber);
        ShardingIndexRoute indexRoute = mainConfig.getOptions().getIndexRoute();
        ArrayList detailEntities = new ArrayList();
        for (ShardingConfig config : shardingConfigs) {
            String tableName = config.getTable();
            String typeFromConfig = XDBStatisticsHelper.getTypeFromConfig(config);
            try {
                DB.__setupExtContextForUsingXdbTableManager((DBRoute)DBRoute.of((String)dbRouteKey), (boolean)false, () -> {
                    String[] shardingTable;
                    for (String shardTable : shardingTable = XDBConfig.getTableManager().getShardingTable(tableName)) {
                        ShardArchiKanbanDetailEntity entity = new ShardArchiKanbanDetailEntity();
                        String shardRoute = indexRoute.getRoute(shardTable);
                        entity.setShardtable(shardTable);
                        entity.setRoute(shardRoute);
                        entity.setTabletype(typeFromConfig);
                        detailEntities.add(entity);
                    }
                    return null;
                });
            }
            catch (Exception exception) {
                log.error(exception.getMessage(), (Throwable)exception);
            }
        }
        ShardArchiKanbanRepository kanbanRepository = ShardArchiKanbanRepository.get();
        ShardArchiKanbanEntity kanbanEntity = kanbanRepository.loadShardArchiKanban(entityNumber);
        kanbanRepository.clearShardArchiKanbanRouteDetail(kanbanEntity.getId());
        kanbanRepository.insertShardArchiKanbanRouteDetail(detailEntities, fid);
    }
}

