/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.sharding.edit;

import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.cbs.plugin.sharding.common.constant.Const;
import kd.bos.cbs.plugin.sharding.common.util.ShardingStrategyFormUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.util.StringUtils;
import kd.bos.xdb.service.ActionUtil;
import kd.bos.xdb.service.ShardTaskConfig;
import kd.bos.xdb.sharding.config.FieldType;

public class ShardingChooseFieldsEditPlugin
extends AbstractFormPlugin
implements Const,
RowClickEventListener {
    private static final String btn_OK = "btnok";
    private static final String ENTRY_COUNT = "entry_count";
    private static final String SELECT_INDICES = "selectIndices";
    private static final String FIELDS = "fields";
    private static final String INDICES = "indices";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{btn_OK});
        EntryGrid eg = (EntryGrid)this.getControl("entryentity");
        eg.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        IFormView view = this.getView();
        JSONObject shardEntityInfoMap = (JSONObject)view.getFormShowParameter().getCustomParam("shardEntityInfoMap");
        IPageCache pageCache = this.getPageCache();
        pageCache.put(SELECT_INDICES, shardEntityInfoMap.getString(SELECT_INDICES));
        this.listShardingFields(shardEntityInfoMap);
        this.showSelectedShardingFields(shardEntityInfoMap);
    }

    private void showSelectedShardingFields(JSONObject shardEntityInfoMap) {
        if (shardEntityInfoMap != null) {
            String selectedFields;
            boolean selectIndices = Boolean.parseBoolean(shardEntityInfoMap.getString(SELECT_INDICES));
            if (selectIndices) {
                selectedFields = (String)shardEntityInfoMap.get((Object)INDICES);
                this.getPageCache().put(INDICES, selectedFields);
            } else {
                selectedFields = (String)shardEntityInfoMap.get((Object)"shardingfields");
                this.getPageCache().put(FIELDS, selectedFields);
            }
            if (StringUtils.isNotEmpty((String)selectedFields)) {
                String[] fields = selectedFields.split(",");
                IDataModel model = this.getModel();
                DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
                for (int i = 0; i < entryEntity.size(); ++i) {
                    for (String field : fields) {
                        if (!field.equals(((DynamicObject)entryEntity.get(i)).getString("fieldnumber"))) continue;
                        model.setValue("fieldchoose", (Object)true, i);
                    }
                }
            }
        }
    }

    private void listShardingFields(JSONObject shardEntityInfoMap) {
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        if (shardEntityInfoMap != null) {
            String formId = shardEntityInfoMap.getString("number");
            boolean selectIndices = Boolean.parseBoolean(shardEntityInfoMap.getString(SELECT_INDICES));
            List<IDataEntityProperty> dps = ShardingStrategyFormUtils.getEntityPropertiesForSharding(formId, selectIndices);
            if (selectIndices) {
                String shardingFields = shardEntityInfoMap.getString("shardingfields");
                String[] fields = shardingFields.split(",");
                if (Objects.nonNull(shardingFields)) {
                    ListIterator<IDataEntityProperty> it = dps.listIterator();
                    block0: while (it.hasNext()) {
                        IDataEntityProperty dp = it.next();
                        if (dp instanceof PKFieldProp) {
                            it.remove();
                            continue;
                        }
                        for (String field : fields) {
                            if (!field.equals(dp.getName())) continue;
                            it.remove();
                            continue block0;
                        }
                    }
                }
            }
            for (IDataEntityProperty dp : dps) {
                Class propertyType;
                if (selectIndices && this.findFieldType(propertyType = dp instanceof IComplexProperty ? ((IComplexProperty)dp).getComplexType().getPrimaryKey().getPropertyType() : dp.getPropertyType()) == null) continue;
                int rowIndex = model.createNewEntryRow("entryentity");
                model.setValue("fieldnumber", (Object)dp.getName(), rowIndex);
                model.setValue("fieldname", (Object)Optional.ofNullable(dp.getDisplayName()).orElseGet(() -> new LocaleString(dp.getName().toUpperCase())), rowIndex);
                model.setValue("fieldchoose", (Object)false, rowIndex);
            }
            this.getPageCache().put(ENTRY_COUNT, String.valueOf(dps.size()));
        }
    }

    private FieldType findFieldType(Class<?> propertyType) {
        if (propertyType == Integer.class) {
            return FieldType.INTEGER;
        }
        if (propertyType == String.class) {
            return FieldType.STRING;
        }
        if (propertyType == Date.class) {
            return FieldType.DATE;
        }
        if (propertyType == Long.class || propertyType == Long.TYPE) {
            return FieldType.LONG;
        }
        return null;
    }

    public void entryRowClick(RowClickEvent evt) {
        IDataModel model = this.getModel();
        int row = evt.getRow();
        DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
        String selectFieldName = ((DynamicObject)entryEntity.get(row)).getString("fieldnumber");
        boolean selected = (Boolean)model.getValue("fieldchoose");
        if (selected) {
            model.setValue("fieldchoose", (Object)false, row);
            this.buildFields(selectFieldName, false);
        } else {
            model.setValue("fieldchoose", (Object)true, row);
            this.buildFields(selectFieldName, true);
        }
    }

    private void buildFields(String selectFieldName, boolean toSelected) {
        IPageCache pageCache = this.getPageCache();
        boolean selectIndices = Boolean.parseBoolean(pageCache.get(SELECT_INDICES));
        String cacheFields = selectIndices ? pageCache.get(INDICES) : pageCache.get(FIELDS);
        StringBuilder fields = new StringBuilder(cacheFields);
        if (toSelected) {
            if (fields.length() > 0) {
                fields.append(",");
            }
            fields.append(selectFieldName);
        } else {
            List<String> fieldsList = Arrays.stream(cacheFields.split(",")).filter(field -> !selectFieldName.equals(field)).collect(Collectors.toList());
            String[] afterFieldArray = fieldsList.toArray(new String[fieldsList.size()]);
            fields.setLength(0);
            fields.append(ActionUtil.joinArray((String[])afterFieldArray, (String)","));
        }
        if (selectIndices) {
            pageCache.put(INDICES, fields.toString());
        } else {
            pageCache.put(FIELDS, fields.toString());
        }
    }

    private void clearOtherRowSelect(IDataModel model) {
        String entryCountString = this.getPageCache().get(ENTRY_COUNT);
        int size = Integer.parseInt(entryCountString);
        for (int i = 0; i < size; ++i) {
            model.setValue("fieldchoose", (Object)false, i);
        }
    }

    public void click(EventObject evt) {
        DynamicObjectCollection entryEntity;
        Button btn = (Button)evt.getSource();
        String key = btn.getKey();
        String retData = null;
        if (btn_OK.equals(key) && (entryEntity = this.getModel().getEntryEntity("entryentity")).size() > 0) {
            IPageCache pageCache = this.getPageCache();
            boolean selectIndices = Boolean.parseBoolean(pageCache.get(SELECT_INDICES));
            List dynamicObjectList = entryEntity.stream().filter(dy -> dy.getBoolean("fieldchoose")).collect(Collectors.toList());
            if (dynamicObjectList.size() == 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u4e00\u4e2a\u5c5e\u6027\u3002", (String)"ShardingChooseFieldsEditPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                return;
            }
            if (!selectIndices && dynamicObjectList.size() > 3) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6700\u591a\u9009\u62e9\u4e09\u4e2a\u5c5e\u6027\u3002", (String)"ShardingChooseFieldsEditPlugin_1", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                return;
            }
            if (selectIndices && dynamicObjectList.size() > ShardTaskConfig.getFastIndexCount()) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6700\u591a\u9009\u62e9{0}\u4e2a\u5c5e\u6027\u3002", (String)"ShardingChooseFieldsEditPlugin_2", (String)"bos-cbs-plugin", (Object[])new Object[]{ShardTaskConfig.getFastIndexCount()}));
                return;
            }
            retData = selectIndices ? pageCache.get(INDICES) : pageCache.get(FIELDS);
        }
        this.getView().returnDataToParent(retData);
        this.getView().close();
    }

    private String getReturnData(List<DynamicObject> dynamicObjectList) {
        StringBuilder sbd = new StringBuilder(dynamicObjectList.size() * 50);
        for (int i = 0; i < dynamicObjectList.size(); ++i) {
            if (i > 0) {
                sbd.append(",");
            }
            sbd.append(dynamicObjectList.get(i).getString("fieldnumber"));
        }
        return sbd.toString();
    }
}

