/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.sharding.edit;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.cbs.plugin.sharding.common.constant.Const;
import kd.bos.cbs.plugin.sharding.common.util.ShardingStrategyFormUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.util.StringUtils;

public class ShardingChooseStrategyEditPlugin
extends AbstractFormPlugin
implements Const,
RowClickEventListener {
    private static final String btn_OK = "btnok";
    private static String ENTRY_COUNT = "entryCount";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{btn_OK});
        CardEntry eg = (CardEntry)this.getControl("entryentity");
        eg.addRowClickListener((RowClickEventListener)this);
    }

    public void entryRowClick(RowClickEvent evt) {
        IDataModel model = this.getModel();
        int row = evt.getRow();
        this.clearOtherRowSelect(model);
        model.setValue("strategybox", (Object)true, row);
    }

    private void clearOtherRowSelect(IDataModel model) {
        String entryCountString = this.getPageCache().get(ENTRY_COUNT);
        int size = Integer.parseInt(entryCountString);
        for (int i = 0; i < size; ++i) {
            model.setValue("strategybox", (Object)false, i);
        }
    }

    public void click(EventObject evt) {
        DynamicObjectCollection entryEntity;
        Button btn = (Button)evt.getSource();
        String key = btn.getKey();
        HashMap<String, String> retData = new HashMap<String, String>();
        if (btn_OK.equals(key) && (entryEntity = this.getModel().getEntryEntity("entryentity")).size() > 0) {
            List dynamicObjectList = entryEntity.stream().filter(dy -> dy.getBoolean("strategybox")).collect(Collectors.toList());
            if (dynamicObjectList.size() == 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u4e00\u79cd\u7b56\u7565\u3002", (String)"ShardingChooseStrategyEditPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                return;
            }
            if (dynamicObjectList.size() > 1) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u79cd\u7b56\u7565\u3002", (String)"ShardingChooseStrategyEditPlugin_1", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                return;
            }
            retData.putIfAbsent("strategy", ((DynamicObject)dynamicObjectList.get(0)).getString("strategy"));
            retData.putIfAbsent("strategyzh_cn", ((DynamicObject)dynamicObjectList.get(0)).getString("strategyval"));
        }
        this.getView().returnDataToParent(retData);
        this.getView().close();
    }

    public void afterCreateNewData(EventObject e) {
        IFormView view = this.getView();
        JSONObject shardEntityInfoMap = (JSONObject)view.getFormShowParameter().getCustomParam("shardEntityInfoMap");
        this.listStrategyFromFields(shardEntityInfoMap);
        this.setSelectedStrategy(shardEntityInfoMap);
    }

    private void setSelectedStrategy(JSONObject shardEntityInfoMap) {
        if (shardEntityInfoMap != null) {
            String strategy = shardEntityInfoMap.getString("strategy");
            if (StringUtils.isEmpty((String)strategy)) {
                return;
            }
            IDataModel model = this.getModel();
            DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
            for (int i = 0; i < entryEntity.size(); ++i) {
                if (!((DynamicObject)entryEntity.get(i)).getString("strategy").equals(strategy)) continue;
                model.setValue("strategybox", (Object)true, i);
                break;
            }
        }
    }

    private void listStrategyFromFields(JSONObject shardEntityInfoMap) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        if (shardEntityInfoMap != null) {
            String shardFields = (String)shardEntityInfoMap.get((Object)"shardingfields");
            String formId = shardEntityInfoMap.getString("number");
            List<IDataEntityProperty> dps = ShardingStrategyFormUtils.getEntityPropertiesForSharding(formId, false);
            if (shardFields.contains(",")) {
                this.showSelectableStrategy(model, view, StrategyType.multi_type.getType());
            } else {
                List dpList = dps.stream().filter(dp -> shardFields.equals(dp.getName())).collect(Collectors.toList());
                IDataEntityProperty dp2 = (IDataEntityProperty)Optional.ofNullable(dpList).get().get(0);
                if (dp2 instanceof DateTimeProp) {
                    this.showSelectableStrategy(model, view, StrategyType.date_type.getType());
                } else if (dp2 instanceof PKFieldProp || dp2 instanceof LongProp || dp2 instanceof BasedataProp || dp2 instanceof DecimalProp) {
                    if (dp2 instanceof BasedataProp) {
                        BasedataProp bp = (BasedataProp)dp2;
                        if ("long".equals(bp.getRefIdProp().getPropertyType().getName())) {
                            this.showSelectableStrategy(model, view, StrategyType.pk_type.getType());
                        }
                    } else {
                        this.showSelectableStrategy(model, view, StrategyType.pk_type.getType());
                    }
                } else {
                    this.showSelectableStrategy(model, view, StrategyType.mod_type.getType());
                }
            }
        }
    }

    private void showSelectableStrategy(IDataModel model, IFormView view, String type) {
        model.deleteEntryData("entryentity");
        CardEntry eg = (CardEntry)view.getControl("entryentity");
        switch (type) {
            case "dateType": {
                int num = 6;
                this.getPageCache().put(ENTRY_COUNT, num + "");
                model.batchCreateNewEntryRow("entryentity", num);
                this.showDateDayStrategy(model, 0);
                this.showDateMonthStrategy(model, 1);
                this.showDateYearStrategy(model, 2);
                this.showDateModStrategy(model, 3);
                eg.setChildVisible(true, 3, new String[]{"strategydetail3"});
                this.showMapStrategy(model, 4);
                this.showBaseCustomStrategy(model, 5);
                break;
            }
            case "pkType": {
                this.getPageCache().put(ENTRY_COUNT, "4");
                model.batchCreateNewEntryRow("entryentity", 4);
                this.showIDSequenceStrategy(model, 0);
                this.showHashModStrategy(model, 1);
                this.showMapStrategy(model, 2);
                this.showBaseCustomStrategy(model, 3);
                break;
            }
            case "modType": {
                this.getPageCache().put(ENTRY_COUNT, "3");
                model.batchCreateNewEntryRow("entryentity", 3);
                this.showHashModStrategy(model, 0);
                this.showMapStrategy(model, 1);
                this.showBaseCustomStrategy(model, 2);
                break;
            }
            case "multiType": {
                this.getPageCache().put(ENTRY_COUNT, "2");
                model.batchCreateNewEntryRow("entryentity", 2);
                this.showMapStrategy(model, 0);
                this.showBaseCustomStrategy(model, 1);
            }
        }
    }

    private void showDateDayStrategy(IDataModel model, int inline) {
        model.setValue("strategyval", (Object)ResManager.loadKDString((String)"\u6309\u65e5\u5206\u7247", (String)"ShardingChooseStrategyEditPlugin_3", (String)"bos-cbs-plugin", (Object[])new Object[0]), inline);
        model.setValue("strategy", (Object)"DateDayStrategy", inline);
        model.setValue("strategydetail1", (Object)ResManager.loadKDString((String)"\u5206\u7247\u89c4\u5219\uff1a\u5206\u7247\u5c5e\u6027\u503c\u6309yyMMdd\u683c\u5f0f\u5316\u3002", (String)"ShardingChooseStrategyEditPlugin_4", (String)"bos-cbs-plugin", (Object[])new Object[0]), inline);
        model.setValue("strategydetail2", (Object)ResManager.loadKDString((String)"\u793a\u4f8b\u6e90\u8868\uff1at_gl_voucher", (String)"ShardingChooseStrategyEditPlugin_5", (String)"bos-cbs-plugin", (Object[])new Object[0]), inline);
        model.setValue("strategydetail3", (Object)ResManager.loadKDString((String)"\u5206\u8868\u540e\uff1at_gl_voucher$200317\u3001t_gl_voucher$200318\u3001t_gl_voucher$200319\u3002", (String)"ShardingChooseStrategyEditPlugin_6", (String)"bos-cbs-plugin", (Object[])new Object[0]), inline);
    }

    private void showDateMonthStrategy(IDataModel model, int inline) {
        model.setValue("strategyval", (Object)ResManager.loadKDString((String)"\u6309\u6708\u5206\u7247", (String)"ShardingChooseStrategyEditPlugin_7", (String)"bos-cbs-plugin", (Object[])new Object[0]), inline);
        model.setValue("strategy", (Object)"DateMonthStrategy", inline);
        model.setValue("strategydetail1", (Object)ResManager.loadKDString((String)"\u5206\u7247\u89c4\u5219\uff1a\u5206\u7247\u5c5e\u6027\u503c\u6309yyyyMM\u683c\u5f0f\u5316\u3002", (String)"ShardingChooseStrategyEditPlugin_8", (String)"bos-cbs-plugin", (Object[])new Object[0]), inline);
        model.setValue("strategydetail2", (Object)ResManager.loadKDString((String)"\u793a\u4f8b\u6e90\u8868\uff1at_gl_voucher", (String)"ShardingChooseStrategyEditPlugin_5", (String)"bos-cbs-plugin", (Object[])new Object[0]), inline);
        model.setValue("strategydetail3", (Object)ResManager.loadKDString((String)"\u5206\u8868\u540d\uff1at_gl_voucher$202003\u3001t_gl_voucher$202004\u3001t_gl_voucher$202005\u3002", (String)"ShardingChooseStrategyEditPlugin_9", (String)"bos-cbs-plugin", (Object[])new Object[0]), inline);
    }

    private void showDateYearStrategy(IDataModel model, int inline) {
        model.setValue("strategyval", (Object)ResManager.loadKDString((String)"\u6309\u5e74\u5206\u7247", (String)"ShardingChooseStrategyEditPlugin_10", (String)"bos-cbs-plugin", (Object[])new Object[0]), inline);
        model.setValue("strategy", (Object)"DateYearStrategy", inline);
        model.setValue("strategydetail1", (Object)ResManager.loadKDString((String)"\u5206\u7247\u89c4\u5219\uff1a\u5206\u7247\u5c5e\u6027\u503c\u6309yyyy\u683c\u5f0f\u5316\u3002", (String)"ShardingChooseStrategyEditPlugin_11", (String)"bos-cbs-plugin", (Object[])new Object[0]), inline);
        model.setValue("strategydetail2", (Object)ResManager.loadKDString((String)"\u793a\u4f8b\u6e90\u8868\uff1at_gl_voucher", (String)"ShardingChooseStrategyEditPlugin_5", (String)"bos-cbs-plugin", (Object[])new Object[0]), inline);
        model.setValue("strategydetail3", (Object)ResManager.loadKDString((String)"\u5206\u8868\u540d\uff1at_gl_voucher$2020\u3001t_gl_voucher$2021\u3001t_gl_voucher$2022\u3002", (String)"ShardingChooseStrategyEditPlugin_12", (String)"bos-cbs-plugin", (Object[])new Object[0]), inline);
    }

    private void showDateModStrategy(IDataModel model, int inline) {
        model.setValue("strategyval", (Object)ResManager.loadKDString((String)"\u65e5\u671f\u6c42\u6a21\u5206\u7247", (String)"ShardingChooseStrategyEditPlugin_13", (String)"bos-cbs-plugin", (Object[])new Object[0]), inline);
        model.setValue("strategy", (Object)"DateModStrategy", inline);
        model.setValue("strategydetail1", (Object)ResManager.loadKDString((String)"\u5206\u7247\u89c4\u5219\uff1a\u5206\u7247\u5c5e\u6027\u503c\u683c\u5f0f\u5316\u540e\u53d6\u6a21\u3002", (String)"ShardingChooseStrategyEditPlugin_14", (String)"bos-cbs-plugin", (Object[])new Object[0]), inline);
        model.setValue("strategydetail2", (Object)ResManager.loadKDString((String)"\u793a\u4f8b\u6e90\u8868\uff1at_gl_voucher", (String)"ShardingChooseStrategyEditPlugin_5", (String)"bos-cbs-plugin", (Object[])new Object[0]), inline);
        model.setValue("strategydetail3", (Object)ResManager.loadKDString((String)"\u5206\u8868\u540d\uff1at_gl_voucher$0\u3001t_gl_voucher$1\u3001t_gl_voucher$2\u3002", (String)"ShardingChooseStrategyEditPlugin_15", (String)"bos-cbs-plugin", (Object[])new Object[0]), inline);
    }

    private void showMapStrategy(IDataModel model, int inline) {
        model.setValue("strategyval", (Object)ResManager.loadKDString((String)"\u6620\u5c04\u7b56\u7565", (String)"ShardingChooseStrategyEditPlugin_26", (String)"bos-cbs-plugin", (Object[])new Object[0]), inline);
        model.setValue("strategy", (Object)"MapStrategy", inline);
        model.setValue("strategydetail1", (Object)ResManager.loadKDString((String)"\u5206\u7247\u89c4\u5219\uff1a\u503c\u6620\u5c04\uff0c\u628a\u5c5e\u6027\u503c(\u591a\u5c5e\u6027\u5219\u4e3a\u7ec4\u5408\u503c)\u7684\u6570\u636e\uff0c\u6620\u5c04\u5230\u4e00\u4e2a\u8868\u4e2d\u3002", (String)"ShardingChooseStrategyEditPlugin_27", (String)"bos-cbs-plugin", (Object[])new Object[0]), inline);
        model.setValue("strategydetail2", (Object)ResManager.loadKDString((String)"\u793a\u4f8b\u6e90\u8868\uff1at_gl_voucher", (String)"ShardingChooseStrategyEditPlugin_5", (String)"bos-cbs-plugin", (Object[])new Object[0]), inline);
        model.setValue("strategydetail3", (Object)ResManager.loadKDString((String)"\u5206\u8868\u540d\uff1at_gl_voucher$0\u3001t_gl_voucher$1\u3001t_gl_voucher$2\u3002", (String)"ShardingChooseStrategyEditPlugin_15", (String)"bos-cbs-plugin", (Object[])new Object[0]), inline);
    }

    private void showBaseCustomStrategy(IDataModel model, int inline) {
        model.setValue("strategyval", (Object)ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u7b56\u7565", (String)"ShardingChooseStrategyEditPlugin_23", (String)"bos-cbs-plugin", (Object[])new Object[0]), inline);
        model.setValue("strategy", (Object)"custom_strategy", inline);
        model.setValue("strategydetail1", (Object)ResManager.loadKDString((String)"\u5206\u7247\u89c4\u5219\uff1a\u81ea\u5b9a\u4e49", (String)"ShardingChooseStrategyEditPlugin_24", (String)"bos-cbs-plugin", (Object[])new Object[0]), inline);
        model.setValue("strategydetail2", (Object)ResManager.loadKDString((String)"\u793a\u4f8b\u6e90\u8868\uff1at_gl_voucher", (String)"ShardingChooseStrategyEditPlugin_5", (String)"bos-cbs-plugin", (Object[])new Object[0]), inline);
        model.setValue("strategydetail3", (Object)ResManager.loadKDString((String)"\u5206\u8868\u540d\uff1at_gl_voucher$XXXX1\u3001t_gl_voucher$XXXX2\u3001t_gl_voucher$XXXX3...(XXXX\u8868\u793a\u81ea\u5b9a\u4e49\u5206\u7247\u7b56\u7565\u5206\u7247\u8868\u540e\u7f00)\u3002", (String)"ShardingChooseStrategyEditPlugin_25", (String)"bos-cbs-plugin", (Object[])new Object[0]), inline);
    }

    private void showHashModStrategy(IDataModel model, int inline) {
        model.setValue("strategyval", (Object)ResManager.loadKDString((String)"\u54c8\u5e0c\u53d6\u6a21", (String)"ShardingChooseStrategyEditPlugin_21", (String)"bos-cbs-plugin", (Object[])new Object[0]), inline);
        model.setValue("strategy", (Object)"HashModStrategy", inline);
        model.setValue("strategydetail1", (Object)ResManager.loadKDString((String)"\u5206\u7247\u89c4\u5219\uff1a\u4e3b\u952e\u503c\u54c8\u5e0c\u53d6\u6a21\u3002", (String)"ShardingChooseStrategyEditPlugin_22", (String)"bos-cbs-plugin", (Object[])new Object[0]), inline);
        model.setValue("strategydetail2", (Object)ResManager.loadKDString((String)"\u793a\u4f8b\u6e90\u8868\uff1at_gl_voucher", (String)"ShardingChooseStrategyEditPlugin_5", (String)"bos-cbs-plugin", (Object[])new Object[0]), inline);
        model.setValue("strategydetail3", (Object)ResManager.loadKDString((String)"\u5206\u8868\u540d\uff1at_gl_voucher$0\u3001t_gl_voucher$1\u3001t_gl_voucher$2\u3002", (String)"ShardingChooseStrategyEditPlugin_15", (String)"bos-cbs-plugin", (Object[])new Object[0]), inline);
    }

    private void showIDSequenceStrategy(IDataModel model, int inline) {
        model.setValue("strategyval", (Object)ResManager.loadKDString((String)"ID\u65f6\u5e8f\u7b56\u7565", (String)"ShardingChooseStrategyEditPlugin_19", (String)"bos-cbs-plugin", (Object[])new Object[0]), inline);
        model.setValue("strategy", (Object)"IDSequenceStrategy", inline);
        model.setValue("strategydetail1", (Object)ResManager.loadKDString((String)"\u5206\u7247\u89c4\u5219\uff1a\u4f7f\u7528\u5206\u5e03\u5f0fID\u751f\u6210\u7684\u4e3b\u952e\uff0c\u503c\u8f6c\u5316\u4e3a\u65f6\u95f4\u3002", (String)"ShardingChooseStrategyEditPlugin_20", (String)"bos-cbs-plugin", (Object[])new Object[0]), inline);
        model.setValue("strategydetail2", (Object)ResManager.loadKDString((String)"\u793a\u4f8b\u6e90\u8868\uff1at_gl_voucher", (String)"ShardingChooseStrategyEditPlugin_5", (String)"bos-cbs-plugin", (Object[])new Object[0]), inline);
        model.setValue("strategydetail3", (Object)ResManager.loadKDString((String)"\u5206\u8868\u540d\uff1at_gl_voucher$yyyy[MM][dd]\u3001t_gl_voucher$yyyy[MM][dd]\u3001t_gl_voucher$yyyy[MM][dd]\u3002", (String)"ShardingChooseStrategyEditPlugin_28", (String)"bos-cbs-plugin", (Object[])new Object[0]), inline);
    }

    public static enum StrategyType {
        pk_type("pkType"),
        mod_type("modType"),
        date_type("dateType"),
        multi_type("multiType");

        private String type;

        private StrategyType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }
}

