/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.sharding.edit;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import kd.bos.cbs.plugin.sharding.common.util.ShardingStrategyFormUtils;
import kd.bos.cbs.plugin.sharding.edit.ShardingCommonPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.util.StringUtils;

public class ShardingConfigBasePlugin
extends ShardingCommonPlugin {
    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"shardingfields", "strategyzh_cn", "strategyparams"});
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        DynamicObject entityNumber = (DynamicObject)model.getValue("entitynumber");
        Map<String, String> shardEntityInfoMap = this.getSelectedEntityNumberAndNameMap();
        if ("shardingfields".equals(key)) {
            if (Objects.isNull(entityNumber)) {
                view.showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u7247\u8868\u5355\u3002", (String)"ShardingConfigEditPlugin_3", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            } else {
                shardEntityInfoMap.put("shardingfields", (String)model.getValue("shardingfields"));
                String shardParams = (String)model.getValue("strategyparams");
                Properties properties = ShardingStrategyFormUtils.convertString2Properties(shardParams);
                shardEntityInfoMap.put("selectIndices", "false");
                shardEntityInfoMap.put("indices", properties.getProperty("indices"));
                this.showShardFormAction(shardEntityInfoMap, "shardingfields");
            }
        } else if ("strategyzh_cn".equals(key)) {
            String shardFields = (String)model.getValue("shardingfields");
            String strategy = (String)model.getValue("strategy");
            String strategy_zh = (String)model.getValue("strategyzh_cn");
            if (StringUtils.isEmpty((String)shardFields)) {
                view.showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u7247\u5c5e\u6027\u3002", (String)"ShardingConfigEditPlugin_4", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                return;
            }
            shardEntityInfoMap.put("shardingfields", shardFields);
            if (StringUtils.isEmpty((String)strategy_zh)) {
                shardEntityInfoMap.put("strategy", strategy_zh);
            } else {
                shardEntityInfoMap.put("strategy", strategy);
            }
            this.showShardFormAction(shardEntityInfoMap, "strategy");
        } else if ("strategyparams".equals(key)) {
            String strategy = (String)model.getValue("strategy");
            String shardFields = (String)model.getValue("shardingfields");
            String shardParams = (String)model.getValue("strategyparams");
            if (StringUtils.isEmpty((String)strategy)) {
                view.showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7b56\u7565\u3002", (String)"ShardingConfigEditPlugin_5", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                return;
            }
            shardEntityInfoMap.put("strategy", strategy);
            shardEntityInfoMap.put("shardingfields", shardFields);
            shardEntityInfoMap.put("strategyparams", shardParams);
            this.showShardFormAction(shardEntityInfoMap, "strategyparams");
        }
    }

    private void showShardFormAction(Map<String, String> map, String fieldAction) {
        switch (fieldAction) {
            case "shardingfields": {
                FormShowParameter fsp_fields_form = new FormShowParameter();
                fsp_fields_form.setFormId("bos_cbs_shard_fields");
                fsp_fields_form.getOpenStyle().setShowType(ShowType.Modal);
                fsp_fields_form.getCustomParams().put("shardEntityInfoMap", map);
                fsp_fields_form.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "FIELDS_FORM_CALL_BACK"));
                this.getView().showForm(fsp_fields_form);
                break;
            }
            case "strategy": {
                FormShowParameter fsp_strategy_form = new FormShowParameter();
                fsp_strategy_form.setFormId("bos_cbs_shard_strategy");
                fsp_strategy_form.getOpenStyle().setShowType(ShowType.Modal);
                fsp_strategy_form.getCustomParams().put("shardEntityInfoMap", map);
                fsp_strategy_form.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "STRATEGY_FORM_CALL_BACK"));
                this.getView().showForm(fsp_strategy_form);
                break;
            }
            case "strategyparams": {
                FormShowParameter fsp_params_form = new FormShowParameter();
                fsp_params_form.setFormId("bos_cbs_shard_params");
                fsp_params_form.getOpenStyle().setShowType(ShowType.Modal);
                fsp_params_form.getCustomParams().put("shardEntityInfoMap", map);
                fsp_params_form.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "PARAMS_FORM_CALL_BACK"));
                this.getView().showForm(fsp_params_form);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        IDataModel model = this.getModel();
        String actionId = closedCallBackEvent.getActionId();
        Object retData = closedCallBackEvent.getReturnData();
        if ("TASK_FORM_CALL_BACK".equals(actionId)) {
            this.getView().invokeOperation("refresh");
            return;
        }
        if (retData == null) {
            return;
        }
        switch (actionId) {
            case "FIELDS_FORM_CALL_BACK": {
                model.setValue("shardingfields", retData);
                model.setValue("strategy", null);
                model.setValue("strategyzh_cn", null);
                model.setValue("strategyparams", null);
                break;
            }
            case "STRATEGY_FORM_CALL_BACK": {
                Map retMap = (Map)retData;
                model.setValue("strategy", retMap.get("strategy"));
                model.setValue("strategyzh_cn", retMap.get("strategyzh_cn"));
                model.setValue("strategyparams", null);
                break;
            }
            case "PARAMS_FORM_CALL_BACK": {
                Map paramsMap = (Map)retData;
                boolean configTemp = Boolean.parseBoolean((String)this.getView().getFormShowParameter().getCustomParam("configTemp"));
                if (configTemp) {
                    String params = (String)paramsMap.get("strategyparams");
                    HashMap<String, String> map = new HashMap<String, String>(1);
                    map.put("strategyparams", params);
                    model.setValue("strategyparams", (Object)new JSONObject(map).toJSONString());
                    break;
                }
                model.setValue("strategyparams", paramsMap.get("strategyparams"));
                break;
            }
            case "FINISH_FORM_CALL_BACK": {
                break;
            }
            default: {
                return;
            }
        }
    }

    public void beforeBindData(EventObject e) {
        String shardingParams = (String)this.getModel().getValue("strategyparams");
        FieldEdit control = (FieldEdit)this.getControl("strategyparams");
        if (StringUtils.isEmpty((String)shardingParams)) {
            control.setMustInput(false);
        } else {
            control.setMustInput(true);
        }
        String strategy = (String)this.getModel().getValue("strategy");
        if (!StringUtils.isEmpty((String)strategy)) {
            String strategy_multilang;
            switch (strategy) {
                case "IDSequenceStrategy": {
                    strategy_multilang = ResManager.loadKDString((String)"ID\u65f6\u5e8f\u7b56\u7565", (String)"ShardingChooseStrategyEditPlugin_19", (String)"bos-cbs-plugin", (Object[])new Object[0]);
                    break;
                }
                case "HashModStrategy": {
                    strategy_multilang = ResManager.loadKDString((String)"\u54c8\u5e0c\u53d6\u6a21", (String)"ShardingChooseStrategyEditPlugin_21", (String)"bos-cbs-plugin", (Object[])new Object[0]);
                    break;
                }
                case "DateDayStrategy": {
                    strategy_multilang = ResManager.loadKDString((String)"\u6309\u65e5\u5206\u7247", (String)"ShardingChooseStrategyEditPlugin_3", (String)"bos-cbs-plugin", (Object[])new Object[0]);
                    break;
                }
                case "DateMonthStrategy": {
                    strategy_multilang = ResManager.loadKDString((String)"\u6309\u6708\u5206\u7247", (String)"ShardingChooseStrategyEditPlugin_7", (String)"bos-cbs-plugin", (Object[])new Object[0]);
                    break;
                }
                case "DateYearStrategy": {
                    strategy_multilang = ResManager.loadKDString((String)"\u6309\u5e74\u5206\u7247", (String)"ShardingChooseStrategyEditPlugin_10", (String)"bos-cbs-plugin", (Object[])new Object[0]);
                    break;
                }
                case "DateModStrategy": {
                    strategy_multilang = ResManager.loadKDString((String)"\u65e5\u671f\u6c42\u6a21\u5206\u7247", (String)"ShardingChooseStrategyEditPlugin_13", (String)"bos-cbs-plugin", (Object[])new Object[0]);
                    break;
                }
                case "MapStrategy": {
                    strategy_multilang = ResManager.loadKDString((String)"\u6620\u5c04\u7b56\u7565", (String)"ShardingChooseStrategyEditPlugin_26", (String)"bos-cbs-plugin", (Object[])new Object[0]);
                    break;
                }
                case "custom_strategy": {
                    strategy_multilang = ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u7b56\u7565", (String)"ShardingChooseStrategyEditPlugin_23", (String)"bos-cbs-plugin", (Object[])new Object[0]);
                    break;
                }
                default: {
                    strategy_multilang = "";
                }
            }
            this.getModel().setValue("strategyzh_cn", (Object)strategy_multilang);
        }
    }
}

