/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.sharding.edit;

import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cbs.plugin.sharding.common.entity.ShardingConfigEntity;
import kd.bos.cbs.plugin.sharding.common.util.ShardingStrategyFormUtils;
import kd.bos.cbs.plugin.sharding.edit.ShardingConfigBasePlugin;
import kd.bos.cbs.plugin.sharding.service.ShardingConfigService;
import kd.bos.cbs.plugin.tools.OperateLogUtil;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.db.DB;
import kd.bos.db.sharding.ShardingManager;
import kd.bos.dlock.DLock;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.instance.Instance;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.impl.ORMConfiguration;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.NetAddressUtils;
import kd.bos.util.StringUtils;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.entity.ShardConfigEntity;
import kd.bos.xdb.entity.ShardDetailUpgradUtil;
import kd.bos.xdb.entity.ShardFastIndexConfigEntity;
import kd.bos.xdb.enums.ShardConfigStatusEnum;
import kd.bos.xdb.enums.ShardFastIndexStatusEnum;
import kd.bos.xdb.enums.ShardTaskNodeEnum;
import kd.bos.xdb.enums.ShardTaskStatusEnum;
import kd.bos.xdb.enums.ShardTaskTypeEnum;
import kd.bos.xdb.enums.ShardTaskWarningStatusEnum;
import kd.bos.xdb.repository.ShardDetailRepository;
import kd.bos.xdb.repository.ShardFastIndexConfigRepository;
import kd.bos.xdb.service.ShardTaskService;
import kd.bos.xdb.sharding.config.ShardingConfig;
import kd.bos.xdb.sharding.strategy.cache.ShardingStrategyCacheCleaner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ShardingConfigEditPlugin
extends ShardingConfigBasePlugin {
    private static Class<?> linkEntryType;
    private static Class<?> mulBasedataPropType;
    private static Logger log;

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        if ("bar_close".equals(itemKey)) {
            model.setDataChanged(false);
            view.invokeOperation("close");
        } else if ("bar_view".equals(itemKey)) {
            String entityNumber = (String)model.getValue("number");
            ListShowParameter lsp = new ListShowParameter();
            lsp.setBillFormId(entityNumber);
            lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            view.showForm((FormShowParameter)lsp);
        } else if ("bar_alias".equals(itemKey)) {
            if (!DB.isXDBEnable()) {
                view.showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u5f00\u542f\u6c34\u5e73\u5206\u8868\u914d\u7f6e\u3002", (String)"ShardingConfigEditPlugin_2", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                return;
            }
            String entityNumber = (String)model.getValue("number");
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("bos_cbs_shard_show_alias");
            fsp.setCustomParam("number", (Object)entityNumber);
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            view.showForm(fsp);
        } else if ("bar_calc".equals(itemKey)) {
            if (!DB.isXDBEnable()) {
                view.showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u5f00\u542f\u6c34\u5e73\u5206\u8868\u914d\u7f6e\u3002", (String)"ShardingConfigEditPlugin_2", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                return;
            }
            String entityNumber = (String)model.getValue("number");
            String shardFields = (String)model.getValue("shardingfields");
            String shardStrategy = (String)model.getValue("strategy");
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("bos_cbs_shard_calc_index");
            fsp.setCustomParam("number", (Object)entityNumber);
            fsp.setCustomParam("shardingfields", (Object)shardFields);
            fsp.setCustomParam("strategy", (Object)shardStrategy);
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            view.showForm(fsp);
        } else if ("bar_runtime_info".equals(itemKey)) {
            if (!DB.isXDBEnable()) {
                view.showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u5f00\u542f\u6c34\u5e73\u5206\u8868\u914d\u7f6e\u3002", (String)"ShardingConfigEditPlugin_2", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                return;
            }
            String entityNumber = (String)model.getValue("number");
            ListShowParameter listShowParameter = new ListShowParameter();
            listShowParameter.setFormId("bos_cbs_shard_runtime");
            listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            listShowParameter.setCustomParam("number", (Object)entityNumber);
            listShowParameter.setCustomParam("strategy", model.getValue("strategy"));
            listShowParameter.setCustomParam("strategyzh_cn", model.getValue("strategyzh_cn"));
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    private void dispatchFastIndexConfig() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        BillShowParameter fsp = new BillShowParameter();
        fsp.setFormId("bos_cbs_shard_fast_index");
        HashMap<String, Object> map = new HashMap<String, Object>();
        Properties properties = ShardingStrategyFormUtils.convertString2Properties((String)model.getValue("strategyparams"));
        String indices = properties.getProperty("indices");
        DynamicObject newDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bos_cbs_shard_fast_index");
        if (indices != null) {
            map.put("indices", indices);
            newDynamicObject.set("fastindex", (Object)indices);
            newDynamicObject.set("lastfastindex", (Object)indices);
        }
        Object configPK = model.getDataEntity().getPkValue();
        String shardFields = (String)model.getValue("shardingfields");
        String entityNumber = (String)model.getValue("number");
        map.put("config", configPK);
        map.put("shardingfields", shardFields);
        map.put("number", entityNumber);
        map.put("indexMoveTask", "true");
        fsp.setCustomParam("shardEntityInfoMap", map);
        QFilter qFilter = new QFilter("config", "=", configPK).and("entitynumber", "=", (Object)entityNumber);
        String selectFields = "id,createtime,modifytime,fastindex,lastfastindex,rwmark,operationlog";
        DynamicObject fastIndexConfig = BusinessDataServiceHelper.loadSingle((String)"bos_cbs_shard_fast_index", (String)selectFields, (QFilter[])qFilter.toArray());
        if (fastIndexConfig != null) {
            if (this.hasReactivateShard(fastIndexConfig, (Long)configPK)) {
                fastIndexConfig.set("fastindex", (Object)indices);
                fastIndexConfig.set("lastfastindex", (Object)indices);
                fastIndexConfig.set("rwmark", (Object)"");
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{fastIndexConfig});
            }
            fsp.setPkId(fastIndexConfig.get("id"));
        } else {
            long id = DB.genGlobalLongId();
            newDynamicObject.set("id", (Object)id);
            newDynamicObject.set("config", configPK);
            newDynamicObject.set("entitynumber", (Object)entityNumber);
            newDynamicObject.set("status", (Object)"0");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newDynamicObject});
            fsp.setPkId((Object)id);
        }
        fsp.setStatus(OperationStatus.EDIT);
        fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        view.showForm((FormShowParameter)fsp);
    }

    private boolean hasReactivateShard(DynamicObject fastOrArchiConfig, Long configPK) {
        Date modifytime = (Date)fastOrArchiConfig.get("modifytime");
        QFilter filter = new QFilter("tasktype", "=", (Object)"shardenable").and("config", "=", (Object)configPK).and("taskstatus", "=", (Object)ShardTaskStatusEnum.SUCCESS.getKey());
        DynamicObjectCollection taskCollection = QueryServiceHelper.query((String)"bos_cbs_shard_task", (String)"id, createtime", (QFilter[])filter.toArray(), (String)"createtime desc");
        DynamicObject task = (DynamicObject)taskCollection.get(0);
        Date taskCreatetime = (Date)task.get("createtime");
        return taskCreatetime.after(modifytime);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            if (messageBoxClosedEvent.getCallBackId().equals("enableSharding")) {
                if (this.validateShardingConfig()) {
                    this.getView().invokeOperation("enable");
                }
            } else if (messageBoxClosedEvent.getCallBackId().equals("resetSharding")) {
                this.getView().invokeOperation("reset");
            } else if (messageBoxClosedEvent.getCallBackId().equals("clearCache")) {
                this.clearAllNodeCache();
            }
        }
    }

    private boolean validateShardingConfig() {
        try {
            String entityNumber = this.getSelectedEntityNumberAndNameMap().get("number");
            if (ShardDetailUpgradUtil.isUpgraded()) {
                ShardDetailRepository.get().deleteDetail(entityNumber);
            }
            IDataModel model = this.getModel();
            ShardConfigEntity se = new ShardConfigEntity();
            se.setEntitynumber(entityNumber);
            se.setShardingfields((String)model.getValue("shardingfields"));
            se.setStrategy((String)model.getValue("strategy"));
            se.setStrategyparams((String)model.getValue("strategyparams"));
            se.setShardingProperties(se.getShardingfields().split(","));
            se.toShardingConfigs();
        }
        catch (Exception e) {
            this.getView().showMessage("Incorrect config: " + e.getMessage());
            return false;
        }
        return true;
    }

    private void clearAllNodeCache() {
        String number = (String)this.getModel().getValue("number");
        IDataEntityType dt = ORM.create().getDataEntityType(number);
        boolean ret = ShardingStrategyCacheCleaner.clearStrategyCache((String)dt.getAlias());
        if (ret) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6e05\u7406\u6210\u529f\u3002", (String)"ShardingConfigEditPlugin_15", (String)"bos-cbs-plugin", (Object[])new Object[0]));
        } else {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6e05\u7406\u5931\u8d25\u3002", (String)"ShardingConfigEditPlugin_16", (String)"bos-cbs-plugin", (Object[])new Object[0]));
        }
        String opName = ResManager.loadKDString((String)"\u6e05\u9664\u7f13\u5b58", (String)"ShardingConfigEditPlugin_22", (String)"bos-cbs-plugin", (Object[])new Object[0]);
        String resultStr = ret ? ResManager.loadKDString((String)"\u6210\u529f", (String)"ShardingConfigEditPlugin_24", (String)"bos-cbs-plugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5931\u8d25", (String)"ShardingConfigEditPlugin_25", (String)"bos-cbs-plugin", (Object[])new Object[0]);
        String entityNumber = this.getSelectedEntityNumberAndNameMap().getOrDefault("number", "");
        String opDesc = String.format(ResManager.loadKDString((String)"\u7f16\u53f7%1$s\uff0c\u6e05\u9664\u7f13\u5b58%2$s\u3002", (String)"ShardingConfigEditPlugin_23", (String)"bos-cbs-plugin", (Object[])new Object[0]), entityNumber, resultStr);
        MultiLangEnumBridge langEnumBridge = new MultiLangEnumBridge("\u7f16\u53f7%1$s\uff0c\u6e05\u9664\u7f13\u5b58%2$s\u3002", "ShardingConfigEditPlugin_23", "bos-cbs-plugin");
        OperateLogUtil.insertSimpleOperateLog(this.getView(), this.getModel().getDataEntityType().getName(), "bar_clear_cache", opDesc, RequestContext.get().getOrgId(), entityNumber, langEnumBridge, entityNumber, resultStr);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        FormOperate op = (FormOperate)e.getSource();
        String operateKey = op.getOperateKey();
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        if ("enable".equals(operateKey) || "reset".equals(operateKey)) {
            ShardFastIndexStatusEnum shardFastIndexStatus;
            ShardFastIndexConfigEntity fastIndexConfigEntity;
            boolean toEnable = false;
            Map<String, String> map = this.getSelectedEntityNumberAndNameMap();
            String entityNumber = map.get("number");
            if ("enable".equals(operateKey)) {
                String shardingFields = (String)model.getValue("shardingfields");
                if (shardingFields == null || " ".equals(shardingFields) || shardingFields.length() == 0) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u7247\u5b57\u6bb5\u3002", (String)"ShardingConfigEditPlugin_6", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                toEnable = true;
            }
            if ("reset".equals(operateKey) && (fastIndexConfigEntity = ShardFastIndexConfigRepository.get().loadFastIndexConfig(entityNumber)) != null && ShardFastIndexStatusEnum.ENABLING == (shardFastIndexStatus = fastIndexConfigEntity.getShardFastIndexStatus())) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u5feb\u901f\u7d22\u5f15\u914d\u7f6e\u4e2d\uff0c\u4e0d\u80fd\u8fd8\u539f\u5206\u7247\u3002", (String)"ShardingConfigEditPlugin_17", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            Boolean lockValid = ShardingStrategyFormUtils.shardingLock("config", entityNumber);
            if (lockValid != null && !lockValid.booleanValue()) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u914d\u7f6e\u5df2\u88ab\u64cd\u4f5c\uff0c\u8bf7\u5148\u68c0\u67e5\u914d\u7f6e\u7684\u6b63\u786e\u6027\u3002", (String)"ShardingConfigEditPlugin_7", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            ShardingConfigEntity shardingConfigEntity = ShardingConfigService.get().queryShardingConfigByEntityName(entityNumber);
            String configStatus = shardingConfigEntity.getConfigStatus();
            if (configStatus != null && !configStatus.equals(ShardConfigStatusEnum.ENABLE.getKey()) && !configStatus.equals(ShardConfigStatusEnum.DISABLE.getKey())) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6570\u636e\u5c1a\u672a\u8fc1\u79fb\u5b8c\u6210\uff0c\u4e0d\u5141\u8bb8\u66f4\u6539\uff1a%s\u3002", (String)"ShardingConfigEditPlugin_8", (String)"bos-cbs-plugin", (Object[])new Object[]{ShardConfigStatusEnum.from((String)configStatus).getValue()}));
                e.setCancel(true);
                return;
            }
            String ip = NetAddressUtils.getLocalIpAddress();
            RequestContext rc = RequestContext.get();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String operationLog = String.format(ResManager.loadKDString((String)"%1$s -> set shard status : %2$s, instance=%3$s@%4$s\uff0centity=%5$s\uff0caccount=%6$s\uff0ctenant=%7$s.", (String)"ShardingConfigEditPlugin_9", (String)"bos-cbs-plugin", (Object[])new Object[0]), sdf.format(new Date()), toEnable ? ShardConfigStatusEnum.ENABLE.getValue() : ShardConfigStatusEnum.DISABLE.getValue(), Instance.getInstanceId(), ip, entityNumber, rc.getAccountId(), rc.getTenantId());
            operationLog = ShardingStrategyFormUtils.getSpliceOperationLog(shardingConfigEntity.getOperationLog(), operationLog);
            model.setValue("operationlog", (Object)operationLog);
            if (toEnable) {
                model.setValue("configstatus", (Object)ShardConfigStatusEnum.ENABLING.getKey());
            } else {
                model.setValue("configstatus", (Object)ShardConfigStatusEnum.DISANLING.getKey());
            }
            String tableRW = ShardingManager.get().notifyLimitTableRW(ORMConfiguration.innerGetDataEntityType((String)shardingConfigEntity.getEntityNumber(), null).getAlias(), false);
            model.setValue("rwmark", (Object)tableRW);
            ShardingStrategyFormUtils.releaseShardingConfigLock();
        } else if ("bar_enable".equals(operateKey) || "bar_reset".equals(operateKey)) {
            if (DB.isXDBEnable()) {
                String entityNumber = (String)model.getValue("number");
                ShardTaskService.get().submitChangeTask(entityNumber);
                IDataEntityType dt = ORM.create().getDataEntityType(entityNumber);
                ShardingConfig config = XDBConfig.getShardingConfigProvider().getConfig(dt.getAlias().toLowerCase());
                if (null != config && !config.getName().equalsIgnoreCase(entityNumber)) {
                    view.showMessage(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u540c\u8868\u5206\u7247\u914d\u7f6e\uff1a%s", (String)"ShardingAddConfigEditPlugin_3", (String)"bos-cbs-plugin", (Object[])new Object[]{dt.getAlias().toLowerCase()}));
                    return;
                }
                if ("bar_enable".equals(operateKey)) {
                    String confirmTip = ResManager.loadKDString((String)"\u542f\u7528\u8fc7\u7a0b\u4e2d\u8868\u5355\u8bfb\u5199\u64cd\u4f5c\u4f1a\u88ab\u9501\u5b9a\uff0c\u4e1a\u52a1\u5c06\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\uff0c\u662f\u5426\u786e\u8ba4\uff1f", (String)"ShardingConfigEditPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[0]);
                    ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("enableSharding");
                    view.showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBackListener);
                } else if ("bar_reset".equals(operateKey)) {
                    String confirmTip = ResManager.loadKDString((String)"\u8fd8\u539f\u8fc7\u7a0b\u4e2d\u8868\u5355\u8bfb\u5199\u64cd\u4f5c\u4f1a\u88ab\u9501\u5b9a\uff0c\u4e1a\u52a1\u5c06\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\uff0c\u662f\u5426\u786e\u8ba4\uff1f", (String)"ShardingConfigEditPlugin_1", (String)"bos-cbs-plugin", (Object[])new Object[0]);
                    ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("resetSharding");
                    view.showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBackListener);
                }
            } else {
                view.showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u5f00\u542f\u6c34\u5e73\u5206\u8868\u914d\u7f6e\u3002", (String)"ShardingConfigEditPlugin_2", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            }
        } else if ("bar_clear_cache".equals(operateKey)) {
            if (!DB.isXDBEnable()) {
                view.showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u5f00\u542f\u6c34\u5e73\u5206\u8868\u914d\u7f6e\u3002", (String)"ShardingConfigEditPlugin_2", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                return;
            }
            String confirmTip = ResManager.loadKDString((String)"\u6e05\u9664\u8be5\u914d\u7f6e\u6240\u6709\u8282\u70b9\u672c\u5730\u7f13\u5b58\uff0c\u662f\u5426\u786e\u8ba4\uff1f", (String)"ShardingConfigEditPlugin_14", (String)"bos-cbs-plugin", (Object[])new Object[0]);
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("clearCache");
            view.showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBackListener);
        } else if ("bar_fast_index".equals(operateKey)) {
            if (!DB.isXDBEnable()) {
                view.showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u5f00\u542f\u6c34\u5e73\u5206\u8868\u914d\u7f6e\u3002", (String)"ShardingConfigEditPlugin_2", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                return;
            }
            String entityNumber = (String)model.getValue("number");
            try (DLock dLock = DLock.create((String)("/xdbsharding/fastIndexConfig_dispatch/" + entityNumber));){
                if (dLock.tryLock()) {
                    this.dispatchFastIndexConfig();
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey = e.getOperateKey();
        if ("enable".equals(operateKey) || "reset".equals(operateKey)) {
            IDataModel model = this.getModel();
            IFormView view = this.getView();
            String configStatus = (String)model.getValue("configstatus");
            if (configStatus.equals(ShardConfigStatusEnum.DISABLE.getKey()) || configStatus.equals(ShardConfigStatusEnum.ENABLE.getKey())) {
                return;
            }
            Object pkValue = model.getDataEntity().getPkValue();
            DynamicObject configLoaded = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"bos_cbs_shard_config");
            String configStatusLoaded = configLoaded.getString("configstatus");
            if (configStatusLoaded.equals(ShardConfigStatusEnum.DISABLE.getKey()) || configStatusLoaded.equals(ShardConfigStatusEnum.ENABLE.getKey())) {
                return;
            }
            boolean toEnable = false;
            if ("enable".equals(operateKey)) {
                toEnable = true;
            }
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bos_cbs_shard_task");
            dynamicObject.set("config", model.getDataEntity().getPkValue());
            dynamicObject.set("tasktype", (Object)(toEnable ? ShardTaskTypeEnum.SHARDENABLE.getKey() : ShardTaskTypeEnum.SHARDDISABLE.getKey()));
            dynamicObject.set("tasknode", (Object)ShardTaskNodeEnum.CLUSTERTBLOCK.getKey());
            dynamicObject.set("taskstatus", (Object)ShardTaskStatusEnum.UNEXECUTED.getKey());
            dynamicObject.set("warningstatus", (Object)ShardTaskWarningStatusEnum.NORMAL.getKey());
            dynamicObject.set("entitynumber", (Object)this.getSelectedEntityNumberAndNameMap().get("number"));
            dynamicObject.set("shardingfields", model.getValue("shardingfields"));
            dynamicObject.set("strategyparams", model.getValue("strategyparams"));
            dynamicObject.set("strategyzh_cn", model.getValue("strategy"));
            dynamicObject.set("createtime", (Object)new Date());
            dynamicObject.set("version", (Object)2);
            if (XDBConfig.get().isDevMode()) {
                String ip = NetAddressUtils.getLocalIpAddress();
                dynamicObject.set("host", (Object)ip);
            }
            Object[] save = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            view.invokeOperation("refresh");
            if (save.length > 0) {
                Object taskPkValue = ((DynamicObject)save[0]).getPkValue();
                BillShowParameter bsp = new BillShowParameter();
                bsp.setStatus(OperationStatus.EDIT);
                bsp.setFormId("bos_cbs_shard_task");
                bsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                bsp.setPkId(taskPkValue);
                bsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "TASK_FORM_CALL_BACK"));
                view.showForm((FormShowParameter)bsp);
            }
            String opName = "";
            String opDesc = "";
            String entityNumber = this.getSelectedEntityNumberAndNameMap().getOrDefault("number", "");
            MultiLangEnumBridge langEnumBridge = new MultiLangEnumBridge("\u7f16\u53f7%s\uff0c\u542f\u7528\u5206\u7247\u6210\u529f\u3002", "ShardingConfigEditPlugin_19", "bos-cbs-plugin");
            if ("enable".equals(operateKey)) {
                opName = "bar_enable";
                opDesc = String.format(ResManager.loadKDString((String)"\u7f16\u53f7%s\uff0c\u542f\u7528\u5206\u7247\u6210\u529f\u3002", (String)"ShardingConfigEditPlugin_19", (String)"bos-cbs-plugin", (Object[])new Object[0]), entityNumber);
            }
            if ("reset".equals(operateKey)) {
                opName = "bar_reset";
                opDesc = String.format(ResManager.loadKDString((String)"\u7f16\u53f7%s\uff0c\u8fd8\u539f\u5206\u7247\u6210\u529f\u3002", (String)"ShardingConfigEditPlugin_21", (String)"bos-cbs-plugin", (Object[])new Object[0]), entityNumber);
                langEnumBridge = new MultiLangEnumBridge("\u7f16\u53f7%s\uff0c\u8fd8\u539f\u5206\u7247\u6210\u529f\u3002", "ShardingConfigEditPlugin_21", "bos-cbs-plugin");
            }
            OperateLogUtil.insertSimpleOperateLog(this.getView(), this.getModel().getDataEntityType().getName(), opName, opDesc, RequestContext.get().getOrgId(), entityNumber, langEnumBridge, entityNumber);
        } else if ("bar_fast_index".equals(operateKey)) {
            String entityNumber = this.getSelectedEntityNumberAndNameMap().getOrDefault("number", "");
            String opName = "bar_fast_index";
            String opDesc = String.format(ResManager.loadKDString((String)"\u7f16\u53f7%s\uff0c\u5feb\u901f\u7d22\u5f15\u914d\u7f6e\u6210\u529f\u3002", (String)"ShardingConfigEditPlugin_27", (String)"bos-cbs-plugin", (Object[])new Object[0]), entityNumber);
            MultiLangEnumBridge langEnumBridge = new MultiLangEnumBridge("\u7f16\u53f7%s\uff0c\u5feb\u901f\u7d22\u5f15\u914d\u7f6e\u6210\u529f\u3002", "ShardingConfigEditPlugin_27", "bos-cbs-plugin");
            OperateLogUtil.insertSimpleOperateLog(this.getView(), this.getModel().getDataEntityType().getName(), opName, opDesc, RequestContext.get().getOrgId(), entityNumber, langEnumBridge, entityNumber);
        }
    }

    public void afterCreateNewData(EventObject e) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        JSONObject shardEntityInfoMap = (JSONObject)view.getFormShowParameter().getCustomParam("shardEntityInfoMap");
        if (Objects.nonNull(shardEntityInfoMap)) {
            String entityNumber = shardEntityInfoMap.getString("number");
            if (StringUtils.isNotEmpty((String)entityNumber)) {
                model.setValue("entitynumber", (Object)entityNumber);
            }
        } else {
            view.showMessage(ResManager.loadKDString((String)"\u5148\u65b0\u589e\u914d\u7f6e\u3002", (String)"ShardingConfigEditPlugin_13", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            view.close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        String property = e.getProperty().getName();
        if ("strategyzh_cn".equals(property)) {
            String strategy = (String)model.getValue("strategy");
            FieldEdit control = (FieldEdit)this.getControl("strategyparams");
            switch (strategy) {
                case "DateDayStrategy": 
                case "DateMonthStrategy": 
                case "DateYearStrategy": {
                    control.setMustInput(false);
                    break;
                }
                default: {
                    control.setMustInput(true);
                }
            }
        }
    }

    static {
        log = LoggerFactory.getLogger(ShardingConfigEditPlugin.class);
        try {
            linkEntryType = Class.forName("kd.bos.entity.LinkEntryType");
            mulBasedataPropType = Class.forName("kd.bos.entity.property.MulBasedataProp");
        }
        catch (ClassNotFoundException e) {
            log.error("class forname error: " + e.getMessage(), (Throwable)e);
        }
    }
}

