/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.sharding.edit;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.cbs.plugin.sharding.common.constant.Const;
import kd.bos.cbs.plugin.sharding.common.entity.ShardingConfigEntity;
import kd.bos.cbs.plugin.sharding.service.ShardingConfigService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.RefEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.bos.xdb.enums.ShardConfigStatusEnum;

public class ShardingDispersionCalcEditPlugin
extends AbstractFormPlugin
implements Const {
    private final ORM orm = ORM.create();

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"shardingfields"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataModel model;
        DynamicObject baseEntity;
        String property = e.getProperty().getName();
        if ("entitynumber".equals(property) && (baseEntity = (DynamicObject)(model = this.getModel()).getValue("entitynumber")) != null) {
            RefEntityType rdType = (RefEntityType)baseEntity.getDataEntityType();
            String number = baseEntity.getString(rdType.getNumberProperty());
            try {
                boolean sharding;
                if (this.orm.exists("bos_cbs_shard_dispersion", new QFilter[]{new QFilter("entitynumber", "=", (Object)number)})) {
                    model.setValue("entitynumber", null);
                    this.getView().showMessage(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u8be5\u8868\u5355\u914d\u7f6e\u3002", (String)"ShardingDispersionCalcEditPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                    return;
                }
                ShardingConfigEntity shardingConfigEntity = ShardingConfigService.get().queryShardingConfigByEntityName(number);
                boolean bl = sharding = StringUtils.isNotEmpty((String)shardingConfigEntity.getConfigStatus()) && !ShardConfigStatusEnum.DISABLE.getKey().equals(shardingConfigEntity.getConfigStatus());
                if (sharding) {
                    model.setValue("entitynumber", null);
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8be5\u8868\u5355\u914d\u7f6e\u5df2\u5206\u7247\uff0c\u4e0d\u5141\u8bb8\u8ba1\u7b97\u79bb\u6563\u5ea6\u3002", (String)"ShardingDispersionCalcEditPlugin_1", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                    return;
                }
            }
            catch (Exception exception) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8868\u5355\u5143\u6570\u636e\u4e0e\u4ee3\u7801\u7248\u672c\u4e0d\u5339\u914d\u3002", (String)"ShardingDispersionCalcEditPlugin_2", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        IDataModel model = this.getModel();
        String itemKey = evt.getItemKey();
        if ("bar_calc".equals(itemKey)) {
            DynamicObject baseEntity = (DynamicObject)model.getValue("entitynumber");
            if (baseEntity != null) {
                RefEntityType rdType = (RefEntityType)baseEntity.getDataEntityType();
                String number = baseEntity.getString(rdType.getNumberProperty());
                if (!this.orm.exists("bos_cbs_shard_dispersion", new QFilter[]{new QFilter("entitynumber", "=", (Object)number)})) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u3002", (String)"ShardingDispersionCalcEditPlugin_3", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObjectCollection entryEntityCol = model.getEntryEntity("entryentity");
                DynamicObject entryEntity = this.orm.newDynamicObject("bos_cbs_shard_dispersion.entryentity");
                String shardingFields = (String)model.getValue("shardingfields");
                entryEntity.set("fields", (Object)shardingFields);
                entryEntity.set("dispersion", (Object)this.calcDispersion(shardingFields, number));
                entryEntity.set("calctime", (Object)new Date());
                entryEntityCol.add((Object)entryEntity);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{model.getDataEntity()});
            }
            this.getView().invokeOperation("refresh");
        }
    }

    private BigDecimal calcDispersion(String fields, String entityNumber) {
        String[] split = fields.split(",");
        IDataEntityType dt = ORM.create().getDataEntityType(entityNumber);
        String tableName = dt.getAlias();
        if (StringUtils.isEmpty((String)tableName)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8be5\u8868\u5355\u6ca1\u6709\u7269\u7406\u8868\uff0c\u8bf7\u68c0\u67e5\u8868\u5355\u662f\u5426\u5efa\u8868\u6210\u529f\u3002", (String)"ShardingDispersionCalcEditPlugin_4", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            return BigDecimal.ZERO;
        }
        List collect = Arrays.stream(split).map(property -> ((IDataEntityProperty)dt.getProperties().get(property)).getAlias()).collect(Collectors.toList());
        if (!collect.isEmpty()) {
            BigDecimal dispersion;
            int size = collect.size();
            StringBuilder sFields = new StringBuilder(size * 50);
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    sFields.append(",");
                }
                sFields.append((String)collect.get(i));
            }
            String sql = "select count(*) from (select distinct " + sFields.toString() + " from " + tableName + ") as T";
            String countSql = "select count(*) from " + tableName;
            Long distinctCount = (Long)DB.query((DBRoute)DBRoute.of((String)dt.getDBRouteKey()), (String)sql, rs -> {
                rs.next();
                return rs.getLong(1);
            });
            Long totalCount = (Long)DB.query((DBRoute)DBRoute.of((String)dt.getDBRouteKey()), (String)countSql, rs -> {
                rs.next();
                return rs.getLong(1);
            });
            double d = 0.0;
            if (totalCount != 0L) {
                d = (double)distinctCount.longValue() * 100.0 / (double)totalCount.longValue();
            }
            return (dispersion = BigDecimal.valueOf(d)).compareTo(BigDecimal.valueOf(100L)) == 0 ? dispersion.setScale(0) : dispersion.setScale(2, 4);
        }
        return BigDecimal.ZERO;
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        DynamicObject entityNumber = (DynamicObject)model.getValue("entitynumber");
        if ("shardingfields".equals(key)) {
            if (Objects.isNull(entityNumber)) {
                view.showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8868\u5355\u3002", (String)"ShardingDispersionCalcEditPlugin_5", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            } else {
                HashMap<String, String> shardEntityInfoMap = new HashMap<String, String>(1);
                RefEntityType rdType = (RefEntityType)entityNumber.getDataEntityType();
                String number = entityNumber.getString(rdType.getNumberProperty());
                shardEntityInfoMap.put("shardingfields", (String)model.getValue("shardingfields"));
                shardEntityInfoMap.put("number", number);
                FormShowParameter fsp_fields_form = new FormShowParameter();
                fsp_fields_form.setFormId("bos_cbs_shard_fields");
                fsp_fields_form.getOpenStyle().setShowType(ShowType.Modal);
                fsp_fields_form.getCustomParams().put("shardEntityInfoMap", shardEntityInfoMap);
                fsp_fields_form.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "FIELDS_FORM_CALL_BACK"));
                this.getView().showForm(fsp_fields_form);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        IDataModel model = this.getModel();
        String actionId = closedCallBackEvent.getActionId();
        Object retData = closedCallBackEvent.getReturnData();
        if (retData == null) {
            return;
        }
        if ("FIELDS_FORM_CALL_BACK".equals(actionId)) {
            model.setValue("shardingfields", retData);
        }
    }
}

