/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.sharding.edit;

import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.Objects;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cbs.plugin.sharding.common.constant.Const;
import kd.bos.cbs.plugin.sharding.common.util.ShardingStrategyFormUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.sharding.ShardingManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.instance.Instance;
import kd.bos.orm.impl.ORMConfiguration;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.NetAddressUtils;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.XDBManagerUtil;
import kd.bos.xdb.entity.ShardConfigEntity;
import kd.bos.xdb.enums.ShardConfigStatusEnum;
import kd.bos.xdb.enums.ShardFastIndexStatusEnum;
import kd.bos.xdb.enums.ShardTaskNodeEnum;
import kd.bos.xdb.enums.ShardTaskStatusEnum;
import kd.bos.xdb.enums.ShardTaskTypeEnum;
import kd.bos.xdb.enums.ShardTaskWarningStatusEnum;
import kd.bos.xdb.repository.ShardConfigRepository;
import kd.bos.xdb.service.ShardTaskService;

public class ShardingFastIndexEditPlugin
extends AbstractFormPlugin
implements Const {
    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"fastindex"});
    }

    public void afterCreateNewData(EventObject e) {
        IFormView view = this.getView();
        JSONObject map = (JSONObject)view.getFormShowParameter().getCustomParam("shardEntityInfoMap");
        Object configPK = map.get((Object)"config");
        if (Objects.isNull(configPK)) {
            view.showMessage(ResManager.loadKDString((String)"\u53ea\u6709\u5206\u8868\u5355\u636e\u624d\u53ef\u65b0\u589e\uff0c\u8bf7\u4ece\u5206\u7247\u914d\u7f6e\u8fdb\u5165\u3002", (String)"ShardingFastIndexEditPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            view.close();
        }
    }

    public void click(EventObject evt) {
        Control evtSource = (Control)evt.getSource();
        String key = evtSource.getKey();
        if ("fastindex".equals(key)) {
            JSONObject shardEntityInfoMap = (JSONObject)this.getView().getFormShowParameter().getCustomParam("shardEntityInfoMap");
            shardEntityInfoMap.put("indices", this.getModel().getValue("fastindex"));
            shardEntityInfoMap.put("selectIndices", (Object)"true");
            FormShowParameter fsp = new FormShowParameter();
            fsp.setCaption(ResManager.loadKDString((String)"\u8bbe\u7f6e\u5feb\u901f\u7d22\u5f15\u5b57\u6bb5", (String)"ShardingParamsEditPlugin_1", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            fsp.setFormId("bos_cbs_shard_fields");
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            fsp.getCustomParams().put("shardEntityInfoMap", shardEntityInfoMap);
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "FIELDS_FORM_CALL_BACK"));
            this.getView().showForm(fsp);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("bar_enable".equals(itemKey)) {
            if (DB.isXDBEnable()) {
                String entityNumber = (String)this.getModel().getValue("entitynumber");
                ShardTaskService.get().submitChangeTask(entityNumber);
                String confirmTip = ResManager.loadKDString((String)"\u542f\u7528\u8fc7\u7a0b\u4e2d\u8868\u5355\u8bfb\u5199\u64cd\u4f5c\u4f1a\u88ab\u9501\u5b9a\uff0c\u4e1a\u52a1\u5c06\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\uff0c\u662f\u5426\u786e\u8ba4\uff1f", (String)"ShardingConfigEditPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[0]);
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("enableIndexMoving");
                this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBackListener);
            } else {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u5f00\u542f\u6c34\u5e73\u5206\u8868\u914d\u7f6e\u3002", (String)"ShardingConfigEditPlugin_2", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes && messageBoxClosedEvent.getCallBackId().equals("enableIndexMoving")) {
            this.getView().invokeOperation("enable");
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        IDataModel model = this.getModel();
        String actionId = closedCallBackEvent.getActionId();
        Object retData = closedCallBackEvent.getReturnData();
        if (retData == null) {
            return;
        }
        switch (actionId) {
            case "FIELDS_FORM_CALL_BACK": {
                model.setValue("fastindex", retData);
                break;
            }
            case "TASK_FORM_CALL_BACK": {
                this.getView().invokeOperation("refresh");
                break;
            }
            default: {
                return;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs be) {
        FormOperate op = (FormOperate)be.getSource();
        String operateKey = op.getOperateKey();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        if ("enable".equals(operateKey)) {
            ShardConfigStatusEnum configStatus;
            String entityNumber = (String)model.getValue("entitynumber");
            ShardConfigEntity shardConfigEntity = ShardConfigRepository.get().loadConfig(entityNumber);
            if (shardConfigEntity != null && ShardConfigStatusEnum.MOVEINDEX == (configStatus = shardConfigEntity.getConfigstatus())) {
                view.showMessage(ResManager.loadKDString((String)"\u7d22\u5f15\u8fc1\u79fb\u4e2d\uff0c\u8bf7\u68c0\u67e5\u5206\u7247\u914d\u7f6e\u6216\u7d22\u5f15\u8fc1\u79fb\u8bb0\u5f55\u3002", (String)"ShardingFastIndexEditPlugin_4", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                be.setCancel(true);
                return;
            }
            Object pkValue = ((DynamicObject)model.getValue("config")).getPkValue();
            DynamicObject fastIndexConfig = BusinessDataServiceHelper.loadSingle((String)"bos_cbs_shard_fast_index", (String)"fastindex,lastfastindex,operationlog,status", (QFilter[])new QFilter("config", "=", pkValue).and("entitynumber", "=", (Object)entityNumber).toArray());
            String lastFastIndex = fastIndexConfig.getString("fastindex");
            String fastIndex = (String)model.getValue("fastindex");
            if (!XDBManagerUtil.validateFastIndexConfigurable((String)fastIndex, (String)lastFastIndex)) {
                view.showMessage(ResManager.loadKDString((String)"\u5feb\u901f\u7d22\u5f15\u5df2\u8bbe\u7f6e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ShardingFastIndexEditPlugin_3", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                be.setCancel(true);
                return;
            }
            Boolean lockValid = ShardingStrategyFormUtils.shardingLock("config", entityNumber);
            if (lockValid == null || !lockValid.booleanValue()) {
                view.showMessage(ResManager.loadKDString((String)"\u914d\u7f6e\u5df2\u88ab\u64cd\u4f5c\uff0c\u8bf7\u5148\u68c0\u67e5\u914d\u7f6e\u7684\u6b63\u786e\u6027\u3002", (String)"ShardingConfigEditPlugin_7", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                be.setCancel(true);
                return;
            }
            if (fastIndexConfig != null) {
                String fastIndexStatus = (String)fastIndexConfig.get("status");
                if (Objects.nonNull(fastIndexStatus) && ShardFastIndexStatusEnum.ENABLING.getKey().equals(fastIndexStatus)) {
                    view.showMessage(ResManager.loadKDString((String)"\u5feb\u901f\u7d22\u5f15\u914d\u7f6e\u542f\u7528\u4e2d\uff0c\u8bf7\u7b49\u5f85\u8fc1\u79fb\u5b8c\u6210\u3002", (String)"ShardingFastIndexEditPlugin_2", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                    be.setCancel(true);
                    return;
                }
                String selectFields = "status,operationlog";
                QFilter qFilter = new QFilter("configid", "=", pkValue).and("entitynumber", "=", (Object)entityNumber).and("status", "=", (Object)ShardFastIndexStatusEnum.ENABLING.getKey());
                DynamicObject archiConfig = BusinessDataServiceHelper.loadSingle((String)"bos_cbs_shard_archi", (String)selectFields, (QFilter[])qFilter.toArray());
                if (archiConfig != null) {
                    view.showMessage(ResManager.loadKDString((String)"\u5206\u8868\u5f52\u6863\u542f\u7528\u4e2d\uff0c\u8bf7\u7b49\u5f85\u8fc1\u79fb\u5b8c\u6210\u3002", (String)"ShardingConfigEditPlugin_46", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                    be.setCancel(true);
                    return;
                }
                String ip = NetAddressUtils.getLocalIpAddress();
                RequestContext rc = RequestContext.get();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String operationLog = String.format(ResManager.loadKDString((String)"%1$s -> fast index field from \u3010%2$s\u3011 to \u3010%3$s\u3011 , instance=%4$s@%5$s\uff0centity=%6$s\uff0caccount=%7$s\uff0ctenant=%8$s.", (String)"ShardingFastIndexEditPlugin_1", (String)"bos-cbs-plugin", (Object[])new Object[0]), sdf.format(new Date()), lastFastIndex == null ? "" : lastFastIndex, fastIndex, Instance.getInstanceId(), ip, entityNumber, rc.getAccountId(), rc.getTenantId());
                model.setValue("status", (Object)ShardFastIndexStatusEnum.ENABLING.getKey());
                String opLogLoad = fastIndexConfig.getString("operationlog");
                operationLog = ShardingStrategyFormUtils.getSpliceOperationLog(opLogLoad, operationLog);
                model.setValue("operationlog", (Object)operationLog);
                model.setValue("lastfastindex", (Object)lastFastIndex);
                String rwMark = ShardingManager.get().notifyLimitTableRW(ORMConfiguration.innerGetDataEntityType((String)entityNumber, null).getAlias(), false);
                model.setValue("rwmark", (Object)rwMark);
            }
            ShardingStrategyFormUtils.releaseShardingConfigLock();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs ae) {
        FormOperate op = (FormOperate)ae.getSource();
        String operateKey = op.getOperateKey();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        if ("enable".equals(operateKey) && ae.getOperationResult() != null && ae.getOperationResult().isSuccess()) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"bos_cbs_shard_task");
            dynamicObject.set("config", model.getDataEntity().getPkValue());
            dynamicObject.set("tasktype", (Object)ShardTaskTypeEnum.MOVEINDEX.getKey());
            dynamicObject.set("tasknode", (Object)ShardTaskNodeEnum.CLUSTERTBLOCK.getKey());
            dynamicObject.set("taskstatus", (Object)ShardTaskStatusEnum.UNEXECUTED.getKey());
            dynamicObject.set("warningstatus", (Object)ShardTaskWarningStatusEnum.NORMAL.getKey());
            dynamicObject.set("entitynumber", model.getValue("entitynumber"));
            dynamicObject.set("createtime", (Object)new Date());
            dynamicObject.set("version", (Object)2);
            if (XDBConfig.get().isDevMode()) {
                String ip = NetAddressUtils.getLocalIpAddress();
                dynamicObject.set("host", (Object)ip);
            }
            dynamicObject.set("fastindex", model.getValue("fastindex"));
            dynamicObject.set("lastfastindex", model.getValue("lastfastindex"));
            Object[] save = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            String rwMark = (String)model.getValue("rwmark");
            DynamicObject config = (DynamicObject)model.getValue("config");
            long configId = (Long)config.getPkValue();
            ShardConfigRepository.get().setConfigRWmark(configId, rwMark, ShardConfigStatusEnum.ENABLE);
            ShardConfigRepository.get().setConfigstatus(configId, ShardConfigStatusEnum.ENABLE, ShardConfigStatusEnum.MOVEINDEX);
            view.invokeOperation("refresh");
            if (save.length > 0) {
                Object taskPkValue = ((DynamicObject)save[0]).getPkValue();
                BillShowParameter bsp = new BillShowParameter();
                bsp.setStatus(OperationStatus.EDIT);
                bsp.setFormId("bos_cbs_shard_task");
                bsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                bsp.setPkId(taskPkValue);
                bsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "TASK_FORM_CALL_BACK"));
                bsp.setCaption(ResManager.loadKDString((String)"\u7d22\u5f15\u8fc1\u79fb\u4efb\u52a1", (String)"ShardingConfigShowTaskEditPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                view.showForm((FormShowParameter)bsp);
            }
        }
    }
}

