/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.sharding.edit;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import kd.bos.cbs.plugin.sharding.common.constant.Const;
import kd.bos.cbs.plugin.sharding.common.util.ShardingStrategyFormUtils;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.util.StringUtils;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.sharding.config.DataRowsRange;

public class ShardingParamsEditPlugin
extends AbstractFormPlugin
implements Const {
    private static final String btn_OK = "btnok";
    private static final String[] paramsKeys = new String[]{"range", "indices", "cust_class", "mod", "delim", "pattern"};

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{btn_OK, "indices"});
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        IDataModel model = this.getModel();
        if (btn_OK.equals(key)) {
            Properties ps;
            int modMax;
            HashMap<String, String> retData = new HashMap<String, String>();
            String dataRowRange = (String)model.getValue("range");
            String customClass = (String)model.getValue("customclass");
            String customParams = (String)model.getValue("customparams");
            BigDecimal mod = (BigDecimal)model.getValue("mod");
            if (mod.compareTo(new BigDecimal(modMax = XDBConfig.get().getModMax())) > 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u5206\u7247\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7%s\u3002", (String)"ShardingParamsEditPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[]{modMax}));
                return;
            }
            String pattern = (String)model.getValue("pattern");
            String indices = (String)model.getValue("indices");
            String delim = (String)model.getValue("delim");
            String keyMapper = (String)model.getValue("keymapper");
            if (StringUtils.isNotEmpty((String)keyMapper)) {
                ps = ShardingStrategyFormUtils.convertString2Properties(keyMapper);
                for (String paramsKey : paramsKeys) {
                    if (!ps.containsKey(paramsKey)) continue;
                    this.getView().showMessage(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u53c2\u6570\u4e0d\u80fd\u5305\u542b\u5173\u952e\u5b57\uff1a%s\u3002", (String)"ShardingParamsEditPlugin_2", (String)"bos-cbs-plugin", (Object[])new Object[]{paramsKey}));
                    return;
                }
            }
            if (StringUtils.isNotEmpty((String)customParams) && (ps = ShardingStrategyFormUtils.convertString2Properties(customParams)).containsKey("cust_class")) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u53c2\u6570\u4e0d\u80fd\u5305\u542b\u5173\u952e\u5b57\uff1a%s\u3002", (String)"ShardingParamsEditPlugin_2", (String)"bos-cbs-plugin", (Object[])new Object[]{"cust_class"}));
                return;
            }
            String shardingParams = (StringUtils.isNotEmpty((String)dataRowRange) ? "range=" + dataRowRange + '\n' : "") + (StringUtils.isNotEmpty((String)indices) ? "indices=" + indices + '\n' : "") + (StringUtils.isNotEmpty((String)customClass) ? "cust_class=" + customClass + '\n' : "") + (StringUtils.isNotEmpty((String)customParams) ? customParams + '\n' : "") + (mod.compareTo(BigDecimal.ZERO) > 0 ? "mod=" + mod.toString() + '\n' : "") + (StringUtils.isNotEmpty((String)delim) ? "delim=" + delim + '\n' : "") + (StringUtils.isNotEmpty((String)pattern) ? "pattern=" + pattern + '\n' : "") + (StringUtils.isNotEmpty((String)keyMapper) ? keyMapper + '\n' : "");
            retData.put("strategyparams", shardingParams);
            this.getView().returnDataToParent(retData);
            this.getView().close();
        } else if ("indices".equals(key)) {
            JSONObject shardEntityInfoMap = (JSONObject)this.getView().getFormShowParameter().getCustomParam("shardEntityInfoMap");
            shardEntityInfoMap.put("indices", model.getValue("indices"));
            shardEntityInfoMap.put("selectIndices", (Object)"true");
            FormShowParameter fsp = new FormShowParameter();
            fsp.setCaption(ResManager.loadKDString((String)"\u8bbe\u7f6e\u5feb\u901f\u7d22\u5f15\u5b57\u6bb5", (String)"ShardingParamsEditPlugin_1", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            fsp.setFormId("bos_cbs_shard_fields");
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            fsp.getCustomParams().put("shardEntityInfoMap", shardEntityInfoMap);
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "FIELDS_FORM_CALL_BACK"));
            this.getView().showForm(fsp);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        IDataModel model = this.getModel();
        String actionId = closedCallBackEvent.getActionId();
        Object retData = closedCallBackEvent.getReturnData();
        if (retData == null) {
            return;
        }
        switch (actionId) {
            case "FIELDS_FORM_CALL_BACK": {
                model.setValue("indices", retData);
                break;
            }
            default: {
                return;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        IFormView view = this.getView();
        view.setVisible(Boolean.valueOf(false), new String[]{"delim", "keymapper", "mod", "pattern", "customclass", "customparams"});
        JSONObject shardEntityInfoMap = (JSONObject)view.getFormShowParameter().getCustomParam("shardEntityInfoMap");
        this.showParamsVisible(shardEntityInfoMap);
    }

    private void showParamsVisible(JSONObject shardEntityInfoMap) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        if (Objects.nonNull(shardEntityInfoMap)) {
            String number = (String)shardEntityInfoMap.get((Object)"number");
            String shardingFields = (String)shardEntityInfoMap.get((Object)"shardingfields");
            String shardingStrategy = (String)shardEntityInfoMap.get((Object)"strategy");
            String shardingParams = (String)shardEntityInfoMap.get((Object)"strategyparams");
            Properties ps = ShardingStrategyFormUtils.convertString2Properties(shardingParams);
            model.setValue("indices", (Object)ps.getProperty("indices"));
            model.setValue("range", (Object)ps.getProperty("range", DataRowsRange.less10.name()));
            switch (shardingStrategy) {
                case "IDSequenceStrategy": {
                    view.setVisible(Boolean.valueOf(true), new String[]{"pattern", "keymapper"});
                    model.setValue("pattern", (Object)ps.getProperty("pattern"));
                    model.setValue("mod", null);
                    break;
                }
                case "HashModStrategy": {
                    if (this.isFieldsIncludeDateProp(number, shardingFields)) {
                        view.setVisible(Boolean.valueOf(true), new String[]{"mod", "pattern", "keymapper"});
                        model.setValue("pattern", (Object)ps.getProperty("pattern"));
                        model.setValue("mod", null);
                        break;
                    }
                    view.setVisible(Boolean.valueOf(true), new String[]{"mod", "keymapper"});
                    model.setValue("mod", (Object)ps.getProperty("mod", "3"));
                    model.setValue("pattern", null);
                    break;
                }
                case "DateModStrategy": {
                    view.setVisible(Boolean.valueOf(true), new String[]{"mod", "pattern", "keymapper"});
                    model.setValue("mod", (Object)ps.getProperty("mod", "3"));
                    model.setValue("pattern", (Object)ps.getProperty("pattern"));
                    break;
                }
                case "MapStrategy": {
                    if (this.isFieldsIncludeDateProp(number, shardingFields)) {
                        view.setVisible(Boolean.valueOf(true), new String[]{"delim", "keymapper", "pattern"});
                        model.setValue("pattern", (Object)ps.getProperty("pattern"));
                    } else {
                        view.setVisible(Boolean.valueOf(true), new String[]{"delim", "keymapper"});
                        model.setValue("pattern", null);
                    }
                    model.setValue("mod", null);
                    model.setValue("delim", (Object)ps.getProperty("delim", "#"));
                    break;
                }
                case "custom_strategy": {
                    view.setVisible(Boolean.valueOf(true), new String[]{"customclass", "customparams"});
                    if (StringUtils.isNotEmpty((String)shardingParams)) {
                        String customClass = ps.getProperty("cust_class");
                        int lastIndexLine = shardingParams.lastIndexOf("\n");
                        int length = shardingParams.length();
                        String customParams = shardingParams.substring(shardingParams.indexOf(customClass) + customClass.length() + 1, lastIndexLine + 1 == length ? lastIndexLine : length);
                        model.setValue("customclass", (Object)customClass);
                        model.setValue("customparams", (Object)customParams);
                    }
                    model.setValue("mod", null);
                    model.setValue("pattern", null);
                    break;
                }
                default: {
                    view.setVisible(Boolean.valueOf(true), new String[]{"keymapper"});
                    model.setValue("mod", null);
                    model.setValue("pattern", null);
                }
            }
            this.setShardingParams(shardingParams, ps);
        }
    }

    private void setShardingParams(String shardingParams, Properties ps) {
        if (StringUtils.isNotEmpty((String)shardingParams)) {
            int beginIndex = -1;
            if (ps.getProperty("pattern") != null) {
                beginIndex = shardingParams.indexOf(ps.getProperty("pattern")) + ps.getProperty("pattern").length() + 1;
            } else if (ps.getProperty("delim") != null) {
                beginIndex = shardingParams.indexOf(ps.getProperty("delim")) + ps.getProperty("delim").length() + 1;
            } else if (ps.getProperty("mod") != null) {
                beginIndex = shardingParams.indexOf(ps.getProperty("mod")) + ps.getProperty("mod").length() + 1;
            } else if (ps.getProperty("indices") != null) {
                beginIndex = shardingParams.indexOf(ps.getProperty("indices")) + ps.getProperty("indices").length() + 1;
            } else if (ps.getProperty("range") != null) {
                beginIndex = shardingParams.indexOf(ps.getProperty("range")) + ps.getProperty("range").length() + 1;
            }
            int length = shardingParams.length();
            if (beginIndex != -1 && beginIndex < length) {
                int lastIndexLine = shardingParams.lastIndexOf("\n");
                String mapper = shardingParams.substring(beginIndex, lastIndexLine + 1 == length ? lastIndexLine : length);
                if (mapper.indexOf("\n") == 0) {
                    mapper = mapper.substring(1);
                }
                this.getModel().setValue("keymapper", (Object)mapper);
            }
        }
    }

    private boolean isFieldsIncludeDateProp(String number, String shardingFields) {
        String[] fields = shardingFields.split(",");
        List<IDataEntityProperty> dps = ShardingStrategyFormUtils.getEntityPropertiesForSharding(number, false);
        List dateDp = dps.stream().filter(dp -> dp instanceof DateTimeProp).collect(Collectors.toList());
        for (IDataEntityProperty dp2 : dateDp) {
            String dpName = dp2.getName();
            if (!shardingFields.contains(dpName)) continue;
            for (String field : fields) {
                if (!field.equals(dpName)) continue;
                return true;
            }
        }
        return false;
    }
}

