/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.sharding.edit;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import kd.bos.bill.OperationStatus;
import kd.bos.cbs.plugin.sharding.common.constant.Const;
import kd.bos.cbs.plugin.sharding.common.util.ShardingStrategyFormUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.sharding.ShardingManager;
import kd.bos.db.sharding.tablerw.DBTableRWNotifier;
import kd.bos.db.sharding.tablerw.ZKWatichConfirmNotifier;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Wizard;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.StepsOption;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.control.events.StepEvent;
import kd.bos.form.control.events.WizardStepsListener;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.ORM;
import kd.bos.orm.impl.ORMConfiguration;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.bos.xdb.entity.ShardArchiEntity;
import kd.bos.xdb.entity.ShardFastIndexConfigEntity;
import kd.bos.xdb.entity.ShardTaskEntity;
import kd.bos.xdb.enums.ShardArchiStatusEnum;
import kd.bos.xdb.enums.ShardConfigStatusEnum;
import kd.bos.xdb.enums.ShardFastIndexStatusEnum;
import kd.bos.xdb.enums.ShardTaskNodeEnum;
import kd.bos.xdb.enums.ShardTaskStatusEnum;
import kd.bos.xdb.enums.ShardTaskTypeEnum;
import kd.bos.xdb.enums.ShardTaskWarningStatusEnum;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.repository.ShardArchiRepository;
import kd.bos.xdb.repository.ShardConfigRepository;
import kd.bos.xdb.repository.ShardFastIndexConfigRepository;
import kd.bos.xdb.repository.ShardLogRepository;
import kd.bos.xdb.repository.ShardProgressRepository;
import kd.bos.xdb.repository.ShardSplitTaskRepository;
import kd.bos.xdb.repository.ShardTaskRepository;
import kd.bos.xdb.service.ShardTaskService;
import kd.bos.xdb.service.ShardingTerminateServiceHelper;
import kd.bos.xdb.task.progress.MainProgress;

public class ShardingTaskEditPlugin
extends AbstractFormPlugin
implements Const,
ProgresssListener,
SetFilterListener,
CreateListDataProviderListener,
WizardStepsListener {
    private static final BigDecimal HUNDRED = new BigDecimal(100);
    private static final String PERCENT = "%";

    public void registerListener(EventObject e) {
        BillList taskList = (BillList)this.getControl("task_billlistap");
        taskList.addSetFilterListener((SetFilterListener)this);
        taskList.addCreateListDataProviderListener((CreateListDataProviderListener)this);
        ProgressBar progressbar = (ProgressBar)this.getControl("progressbarap");
        progressbar.addProgressListener((ProgresssListener)this);
        this.addItemClickListeners(new String[]{"tbmain"});
        Wizard wizard = (Wizard)this.getControl("wizardap");
        wizard.addWizardStepsListener((WizardStepsListener)this);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void itemClick(ItemClickEvent evt) {
        ConfirmCallBackListener confirmCallBackListener;
        String confirmTip;
        String itemKey = evt.getItemKey();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        if ("bar_close".equals(itemKey)) {
            model.setDataChanged(false);
            view.invokeOperation("close");
            return;
        }
        if ("bar_refresh".equals(itemKey)) {
            ShardTaskService.get().submitChangeTask(itemKey);
            return;
        }
        if ("bar_retry".equals(itemKey)) {
            String entityNumber;
            Boolean lockValid;
            ShardTaskService.get().submitChangeTask(itemKey);
            String taskStatus = (String)model.getValue("taskstatus");
            if (!taskStatus.equals(ShardTaskStatusEnum.EXECUTING.getKey())) {
                if (!taskStatus.equals(ShardTaskStatusEnum.PAUSE.getKey())) return;
            }
            if ((lockValid = ShardingStrategyFormUtils.shardingLock(null, entityNumber = (String)model.getValue("entitynumber"))) == null) {
                view.showErrorNotification(ResManager.loadKDString((String)"ZK\u66fe\u4e2d\u65ad\uff0c\u672a\u6b63\u786e\u91ca\u653e\u9501\uff0c\u8bf7\u7b49\u5f85\u91ca\u653e\u6216\u8bf7\u8fdbmonitor\u89e3\u9501\u3002", (String)"ShardingTaskEditPlugin_9", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                return;
            }
            if (!lockValid.booleanValue()) {
                view.showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u6b63\u5e38\u6267\u884c\u4e2d\uff0c\u64cd\u4f5c\u65e0\u6548\u3002", (String)"ShardingTaskEditPlugin_4", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject dataEntity = model.getDataEntity();
            long pkValue = (Long)dataEntity.getPkValue();
            ShardProgressRepository.get().setProgressUnexecuted(pkValue);
            ShardSplitTaskRepository.get().setSplitTaskUnexecuted(pkValue);
            int ret = ShardTaskRepository.get().setTaskUnexecuted(pkValue);
            if (ret > 0) {
                IDataEntityType dt = ORM.create().getDataEntityType((String)model.getValue("entitynumber"));
                if (taskStatus.equals(ShardTaskStatusEnum.EXECUTING.getKey())) {
                    ShardingManager.get().notifyLimitTaskPaused(false, dt.getAlias());
                } else {
                    ShardingManager.get().notifyLimitTaskPaused(true, dt.getAlias());
                }
                view.showTipNotification(ResManager.loadKDString((String)"\u5df2\u6267\u884c\u91cd\u8bd5\u64cd\u4f5c\uff0c\u6b63\u5728\u901a\u77e5\u4efb\u52a1\u91cd\u542f\u3002", (String)"ShardingTaskEditPlugin_3", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            }
            ShardingStrategyFormUtils.releaseShardingConfigLock();
            view.invokeOperation("refresh");
            return;
        }
        DynamicObject dataEntity = model.getDataEntity();
        long pkValue = (Long)dataEntity.getPkValue();
        ProgressBar progressbar = (ProgressBar)this.getControl("progressbarap");
        ORM orm = ORM.create();
        if ("bar_pause".equals(itemKey)) {
            ShardTaskService.get().submitChangeTask(itemKey);
            Boolean lockValid = ShardingStrategyFormUtils.shardingLock(null, (String)model.getValue("entitynumber"));
            if (lockValid == null) {
                view.showErrorNotification(ResManager.loadKDString((String)"ZK\u66fe\u4e2d\u65ad\uff0c\u672a\u6b63\u786e\u91ca\u653e\u9501\uff0c\u8bf7\u7b49\u5f85\u91ca\u653e\u6216\u8bf7\u8fdbmonitor\u89e3\u9501\u3002", (String)"ShardingTaskEditPlugin_9", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                return;
            }
            if (lockValid.booleanValue()) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u8282\u70b9\u5df2\u88ab\u91cd\u542f\uff0c\u8bf7\u70b9\u51fb\u91cd\u8bd5\u6309\u94ae\u5efa\u7acb\u5206\u7247\u8fde\u63a5\u3002", (String)"ShardingTaskEditPlugin_6", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                ShardingStrategyFormUtils.releaseShardingConfigLock();
                return;
            }
            ShardSplitTaskRepository.get().setSplitTaskPause(pkValue);
            ShardProgressRepository.get().setProgressPause(pkValue);
            int success = ShardTaskRepository.get().setTaskPause(pkValue);
            if (success > 0) {
                model.setValue("taskstatus", (Object)ShardTaskStatusEnum.PAUSE.getKey());
                IDataEntityType dt = orm.getDataEntityType((String)model.getValue("entitynumber"));
                ShardingManager.get().notifyLimitTaskPaused(true, dt.getAlias());
                return;
            }
            view.showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u65e0\u6548\uff0c\u4efb\u52a1\u72b6\u6001\u5df2\u53d8\u66f4\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"ShardingTaskEditPlugin_7", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            return;
        }
        if ("bar_continue".equals(itemKey)) {
            ShardSplitTaskRepository.get().setSplitTaskContinue(pkValue);
            ShardProgressRepository.get().setProgressContinue(pkValue);
            int success = ShardTaskRepository.get().setTaskContinue(pkValue);
            if (success > 0) {
                model.setValue("warningstatus", (Object)ShardTaskWarningStatusEnum.NORMAL.getKey());
                model.setValue("taskstatus", (Object)ShardTaskStatusEnum.UNEXECUTED.getKey());
                IDataEntityType dt = orm.getDataEntityType((String)model.getValue("entitynumber"));
                ShardingManager.get().notifyLimitTaskPaused(false, dt.getAlias());
                progressbar.start();
            } else {
                view.showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u65e0\u6548\uff0c\u4efb\u52a1\u72b6\u6001\u5df2\u53d8\u66f4\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"ShardingTaskEditPlugin_7", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            }
            ShardTaskService.get().submitChangeTask(itemKey);
            return;
        }
        if (!"bar_terminate".equals(itemKey)) return;
        String taskType = (String)model.getValue("tasktype");
        if (ShardTaskTypeEnum.MOVEINDEX == ShardTaskTypeEnum.from((String)taskType)) {
            confirmTip = ResManager.loadKDString((String)"\u7ec8\u6b62\u64cd\u4f5c\u540e\uff0c\u7d22\u5f15\u8fc1\u79fb\u8fc7\u7a0b\u6240\u6709\u4e2d\u95f4\u8868\u90fd\u4f1a\u88ab\u5220\u9664\uff0c\u662f\u5426\u786e\u8ba4\uff1f", (String)"ShardingTaskEditPlugin_11", (String)"bos-cbs-plugin", (Object[])new Object[0]);
            confirmCallBackListener = new ConfirmCallBackListener("terminateMoveIndex");
        } else if (ShardTaskTypeEnum.SHARDARCHIVE == ShardTaskTypeEnum.from((String)taskType)) {
            ShardTaskEntity taskEntity = ShardTaskRepository.get().loadTask(pkValue);
            MainProgress mainProgress = MainProgress.of((long)taskEntity.getId(), (String)taskEntity.getEntitynumber(), (String)taskEntity.getProgresssign());
            if (!mainProgress.isTerminable()) {
                String tip = ResManager.loadKDString((String)"\u5206\u8868\u5f52\u6863\u4efb\u52a1\u5f53\u524d\u8fdb\u5ea6\u5df2\u65e0\u6cd5\u7ec8\u6b62\u3002", (String)"ShardingTaskEditPlugin_18", (String)"bos-cbs-plugin", (Object[])new Object[0]);
                this.getView().showMessage(tip);
                return;
            }
            confirmTip = ResManager.loadKDString((String)"\u7ec8\u6b62\u64cd\u4f5c\u540e\uff0c\u5206\u8868\u5f52\u6863\u8fc7\u7a0b\u6240\u6709\u4e2d\u95f4\u8868\u90fd\u4f1a\u88ab\u5220\u9664\uff0c\u662f\u5426\u786e\u8ba4\uff1f", (String)"ShardingTaskEditPlugin_17", (String)"bos-cbs-plugin", (Object[])new Object[0]);
            confirmCallBackListener = new ConfirmCallBackListener("terminateShardArchi");
        } else {
            confirmTip = ResManager.loadKDString((String)"\u7ec8\u6b62\u64cd\u4f5c\u540e\u5206\u7247\u8fc7\u7a0b\u6240\u6709\u4e2d\u95f4\u8868\u90fd\u4f1a\u88ab\u5220\u9664\uff0c\u662f\u5426\u786e\u8ba4\uff1f", (String)"ShardingTaskEditPlugin_5", (String)"bos-cbs-plugin", (Object[])new Object[0]);
            confirmCallBackListener = new ConfirmCallBackListener("terminateSharding");
        }
        view.showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBackListener);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            if (messageBoxClosedEvent.getCallBackId().equals("terminateSharding")) {
                IDataModel model = this.getModel();
                long pkValue = (Long)model.getDataEntity().getPkValue();
                ShardProgressRepository.get().setProgressTerminated(pkValue);
                ShardSplitTaskRepository.get().setSplitTaskTerminated(pkValue);
                int success = ShardTaskRepository.get().setTaskTerminated(pkValue);
                if (success > 0) {
                    ShardTaskEntity taskEntity = ShardTaskRepository.get().loadTask(pkValue);
                    String entityNumber = taskEntity.getEntitynumber();
                    String tableName = ORMConfiguration.innerGetDataEntityType((String)entityNumber, null).getAlias();
                    ShardingTerminateServiceHelper.dropShardingProcessTable((ShardTaskEntity)taskEntity);
                    ShardConfigRepository.get().setConfigstatus(taskEntity.getConfigid(), ShardConfigStatusEnum.ENABLING, ShardConfigStatusEnum.DISABLE);
                    String rwMark = ShardingManager.get().notifyLimitTableRW(tableName, true);
                    ShardConfigRepository.get().setConfigRWmark(taskEntity.getConfigid(), rwMark, ShardConfigStatusEnum.DISABLE);
                    ShardingManager.get().notifyReloadShardingConfig(entityNumber);
                    ShardingManager.get().notifyLimitTaskPaused(false, tableName);
                    ShardLogRepository.get().insertOperationLog(taskEntity.getId(), entityNumber, ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u6210\u529f\u7ec8\u6b62\uff0c\u914d\u7f6e\u72b6\u6001\u5df2\u66f4\u6539\u4e3a\u672a\u542f\u7528\u3002", (String)"ShardingTaskEditPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[0]), "ShardingTerminal");
                    this.confirmNotifierCluster(entityNumber, tableName, rwMark);
                    model.setValue("taskstatus", (Object)ShardTaskStatusEnum.TERMINATED.getKey());
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u7ec8\u6b62\u6210\u529f\u3002", (String)"ShardingTaskEditPlugin_8", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u65e0\u6548\uff0c\u4efb\u52a1\u72b6\u6001\u5df2\u53d8\u66f4\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"ShardingTaskEditPlugin_7", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                }
            } else if (messageBoxClosedEvent.getCallBackId().equals("terminateMoveIndex")) {
                IDataModel model = this.getModel();
                long pkValue = (Long)model.getDataEntity().getPkValue();
                ShardProgressRepository.get().setProgressTerminated(pkValue);
                ShardSplitTaskRepository.get().setSplitTaskTerminated(pkValue);
                int success = ShardTaskRepository.get().setTaskTerminated(pkValue);
                if (success > 0) {
                    ShardTaskEntity taskEntity = ShardTaskRepository.get().loadTask(pkValue);
                    String entityNumber = taskEntity.getEntitynumber();
                    String tableName = ORMConfiguration.innerGetDataEntityType((String)entityNumber, null).getAlias();
                    ShardingTerminateServiceHelper.dropMoveIndexProcessTable((ShardTaskEntity)taskEntity);
                    String rwMark = ShardingManager.get().notifyLimitTableRW(tableName, true);
                    ShardFastIndexConfigEntity fastIndexConfigEntity = ShardFastIndexConfigRepository.get().loadFastIndexConfig(taskEntity.getConfigid());
                    ShardConfigRepository.get().setConfigRWmark(fastIndexConfigEntity.getConfigId(), rwMark, ShardConfigStatusEnum.MOVEINDEX);
                    ShardConfigRepository.get().setConfigstatus(fastIndexConfigEntity.getConfigId(), ShardConfigStatusEnum.MOVEINDEX, ShardConfigStatusEnum.ENABLE);
                    ShardFastIndexConfigRepository.get().setFastIndexConfigRWMark(taskEntity.getConfigid(), rwMark, ShardFastIndexStatusEnum.ENABLING);
                    ShardFastIndexConfigRepository.get().setFastIndexConfigStatus(taskEntity.getConfigid(), ShardFastIndexStatusEnum.ENABLING, ShardFastIndexStatusEnum.CONFIGURABLE);
                    ShardFastIndexConfigRepository.get().resetFastIndex(taskEntity.getConfigid(), fastIndexConfigEntity.getLastFastIndex(), fastIndexConfigEntity.getFastIndex());
                    ShardingManager.get().notifyReloadShardingConfig(entityNumber);
                    ShardingManager.get().notifyLimitTaskPaused(false, tableName);
                    ShardLogRepository.get().insertOperationLog(taskEntity.getId(), entityNumber, ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u6210\u529f\u7ec8\u6b62\uff0c\u914d\u7f6e\u72b6\u6001\u5df2\u66f4\u6539\u4e3a\u53ef\u914d\u7f6e\u3002", (String)"ShardingTaskEditPlugin_12", (String)"bos-cbs-plugin", (Object[])new Object[0]), "MoveIndexTerminal");
                    this.confirmNotifierCluster(entityNumber, tableName, rwMark);
                    model.setValue("taskstatus", (Object)ShardTaskStatusEnum.TERMINATED.getKey());
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u7ec8\u6b62\u6210\u529f\u3002", (String)"ShardingTaskEditPlugin_8", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u65e0\u6548\uff0c\u4efb\u52a1\u72b6\u6001\u5df2\u53d8\u66f4\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"ShardingTaskEditPlugin_7", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                }
            } else if (messageBoxClosedEvent.getCallBackId().equals("terminateShardArchi")) {
                IDataModel model = this.getModel();
                long pkValue = (Long)model.getDataEntity().getPkValue();
                ShardProgressRepository.get().setProgressTerminated(pkValue);
                ShardSplitTaskRepository.get().setSplitTaskTerminated(pkValue);
                int success = ShardTaskRepository.get().setTaskTerminated(pkValue);
                if (success > 0) {
                    ShardTaskEntity taskEntity = ShardTaskRepository.get().loadTask(pkValue);
                    String entityNumber = taskEntity.getEntitynumber();
                    String tableName = ORMConfiguration.innerGetDataEntityType((String)entityNumber, null).getAlias();
                    ShardingTerminateServiceHelper.dropArchiveMoveProcessTable((ShardTaskEntity)taskEntity);
                    String rwMark = ShardingManager.get().notifyLimitTableRW(tableName, true);
                    ShardArchiEntity shardArchiEntity = ShardArchiRepository.get().loadShardArchi(taskEntity.getConfigid());
                    ShardConfigRepository.get().setConfigRWmark(shardArchiEntity.getConfigId(), rwMark, ShardConfigStatusEnum.ARCHIVEMOVE);
                    ShardConfigRepository.get().setConfigstatus(shardArchiEntity.getConfigId(), ShardConfigStatusEnum.ARCHIVEMOVE, ShardConfigStatusEnum.ENABLE);
                    ShardArchiRepository.get().setShardArchiRWMark(taskEntity.getConfigid(), rwMark, ShardArchiStatusEnum.ENABLING);
                    ShardArchiRepository.get().setShardArchiStatus(taskEntity.getConfigid(), ShardArchiStatusEnum.ENABLING, ShardArchiStatusEnum.CONFIGURABLE);
                    ShardingManager.get().notifyReloadShardingConfig(entityNumber);
                    ShardingManager.get().notifyLimitTaskPaused(false, tableName);
                    ShardLogRepository.get().insertOperationLog(taskEntity.getId(), entityNumber, ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u6210\u529f\u7ec8\u6b62\uff0c\u914d\u7f6e\u72b6\u6001\u5df2\u66f4\u6539\u4e3a\u53ef\u914d\u7f6e\u3002", (String)"ShardingTaskEditPlugin_12", (String)"bos-cbs-plugin", (Object[])new Object[0]), "MoveIndexTerminal");
                    this.confirmNotifierCluster(entityNumber, tableName, rwMark);
                    model.setValue("taskstatus", (Object)ShardTaskStatusEnum.TERMINATED.getKey());
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u7ec8\u6b62\u6210\u529f\u3002", (String)"ShardingTaskEditPlugin_8", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u65e0\u6548\uff0c\u4efb\u52a1\u72b6\u6001\u5df2\u53d8\u66f4\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"ShardingTaskEditPlugin_7", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                }
            }
        }
    }

    private void secondSleep(long second) {
        try {
            TimeUnit.SECONDS.sleep(second);
        }
        catch (InterruptedException e) {
            throw ExceptionUtil.wrap((Throwable)e);
        }
    }

    private void confirmNotifierCluster(String entityNumber, String tableName, String rwMark) {
        ZKWatichConfirmNotifier confirmNotifier;
        boolean confirmAll;
        int n = 3;
        while (n-- > 0 && !(confirmAll = (confirmNotifier = DBTableRWNotifier.confirmNotifierTableRW((String)entityNumber, (String)tableName, (String)rwMark)).isConfirmAll())) {
            ShardingManager.get().notifyReloadShardingConfig(entityNumber);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw ExceptionUtil.asRuntimeException((Throwable)e);
            }
        }
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Object taskID = dataEntity.getPkValue();
        String entityNumber = dataEntity.getString("entitynumber");
        setFilterEvent.getCustomQFilters().add(new QFilter("entitynumber", "=", (Object)entityNumber).and(new QFilter("task", "=", taskID)));
    }

    public void beforeBindData(EventObject e) {
        IFormView view = this.getView();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        BillList taskList = (BillList)view.getControl("task_billlistap");
        Object taskID = dataEntity.getPkValue();
        String entityNumber = dataEntity.getString("entitynumber");
        taskList.setFilter(new QFilter("entitynumber", "=", (Object)entityNumber).and(new QFilter("task", "=", taskID)));
        taskList.addCreateListDataProviderListener((CreateListDataProviderListener)this);
    }

    public void afterBindData(EventObject e) {
        ProgressBar progressbar = (ProgressBar)this.getControl("progressbarap");
        this.guideStepDisplay();
        progressbar.start();
    }

    public void createNewData(BizDataEventArgs e) {
        IFormView view = this.getView();
        OperationStatus status = view.getFormShowParameter().getStatus();
        if (status == OperationStatus.ADDNEW) {
            view.showMessage(ResManager.loadKDString((String)"\u4e0d\u80fd\u51ed\u7a7a\u521b\u5efa\u4efb\u52a1\uff0c\u8bf7\u4ece\u914d\u7f6e\u4e2d\u542f\u7528\u3002", (String)"ShardingTaskEditPlugin_1", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            view.close();
        }
    }

    public void onProgress(ProgressEvent progressEvent) {
        this.guideStepDisplay();
        IDataModel model = this.getModel();
        String taskType = (String)model.getValue("tasktype");
        boolean isToEnable = ShardTaskTypeEnum.SHARDENABLE.getKey().equals(taskType);
        ProgressBar progressbar = (ProgressBar)this.getControl("progressbarap");
        String taskStatus = (String)model.getValue("taskstatus");
        boolean progressStart = ShardTaskStatusEnum.EXECUTING.getKey().equals(taskStatus) || ShardTaskStatusEnum.UNEXECUTED.getKey().equals(taskStatus) || ShardTaskStatusEnum.PAUSE.getKey().equals(taskStatus) || StringUtils.isEmpty((String)taskStatus);
        boolean isSuccess = ShardTaskStatusEnum.SUCCESS.getKey().equals(taskStatus);
        Map<String, Long> currentMovingProgress = this.getCurrentMovingProgress();
        if (isSuccess) {
            progressEvent.setProgress(100);
        } else {
            int progress = currentMovingProgress.get("progress").intValue();
            if (progress == 100) {
                progressEvent.setProgress(progress - 1);
            } else {
                progressEvent.setProgress(progress);
            }
        }
        Label label = (Label)this.getControl("label_desc");
        label.setText((isToEnable ? ResManager.loadKDString((String)"\u5df2\u8fc1\u79fb\u6570\u636e\u91cf/\u8868\u5934\u603b\u6570\u636e\u91cf\uff1a", (String)"ShardingTaskEditPlugin_2", (String)"bos-cbs-plugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5df2\u8fc1\u79fb\u6570\u636e\u91cf/\u603b\u6570\u636e\u91cf\uff1a", (String)"ShardingTaskEditPlugin_10", (String)"bos-cbs-plugin", (Object[])new Object[0])) + currentMovingProgress.get("moving_record") + "/" + currentMovingProgress.get("total_record"));
        if (!progressStart) {
            progressbar.stop();
        }
        this.refreshTaskModel();
        BillList taskList = (BillList)this.getView().getControl("task_billlistap");
        taskList.refresh();
    }

    private Map<String, Long> getCurrentMovingProgress() {
        HashMap<String, Long> ret = new HashMap<String, Long>(3);
        IDataModel model = this.getModel();
        Object pkValue = model.getDataEntity().getPkValue();
        Object entityNumber = model.getDataEntity().get("entitynumber");
        QFilter qf = new QFilter("entitynumber", "=", entityNumber);
        qf.and("id", "=", pkValue);
        DynamicObject dyObj = BusinessDataServiceHelper.loadSingle((String)"bos_cbs_shard_task", (String)"moving_record,total_record", (QFilter[])qf.toArray());
        long movingRecord = 0L;
        long totalRecord = 0L;
        if (Objects.nonNull(dyObj)) {
            movingRecord = dyObj.getLong("moving_record");
            totalRecord = dyObj.getLong("total_record");
        }
        ret.put("moving_record", movingRecord);
        ret.put("total_record", totalRecord);
        if (totalRecord == 0L) {
            ret.put("progress", 0L);
            return ret;
        }
        ret.put("progress", (long)((double)movingRecord * 100.0 / (double)totalRecord));
        return ret;
    }

    private void refreshTaskModel() {
        IDataModel model = this.getModel();
        Object pkValue = model.getDataEntity().getPkValue();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"bos_cbs_shard_task");
        model.setValue("warningstatus", (Object)dynamicObject.getString("warningstatus"));
        model.setValue("taskstatus", (Object)dynamicObject.getString("taskstatus"));
        model.setValue("tasknode", (Object)dynamicObject.getString("tasknode"));
        model.setValue("COUNT", (Object)dynamicObject.getString("COUNT"));
    }

    private void guideStepDisplay() {
        StepsOption stepsOption;
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        Wizard wizard = (Wizard)this.getControl("wizardap");
        String taskType = (String)this.getModel().getValue("tasktype");
        if (ShardTaskTypeEnum.MOVEINDEX == ShardTaskTypeEnum.from((String)taskType)) {
            stepsOption = (StepsOption)wizard.getStepsOptions().get(1);
            stepsOption.setTitle(new LocaleString(ResManager.loadKDString((String)"\u7d22\u5f15\u8fc1\u79fb", (String)"ShardingTaskEditPlugin_13", (String)"bos-cbs-plugin", (Object[])new Object[0])));
        } else if (ShardTaskTypeEnum.SHARDARCHIVE == ShardTaskTypeEnum.from((String)taskType)) {
            stepsOption = (StepsOption)wizard.getStepsOptions().get(1);
            stepsOption.setTitle(new LocaleString(ResManager.loadKDString((String)"\u5206\u8868\u5f52\u6863", (String)"ShardingConfigEditPlugin_28", (String)"bos-cbs-plugin", (Object[])new Object[0])));
        }
        String warningStatus = (String)model.getValue("warningstatus");
        String taskStatus = (String)model.getValue("taskstatus");
        String taskNode = (String)model.getValue("tasknode");
        if (ShardTaskNodeEnum.CLUSTERTBLOCK.getKey().equals(taskNode)) {
            view.setVisible(Boolean.valueOf(false), new String[]{"label_desc"});
            HashMap<String, Object> currentStepMap = new HashMap<String, Object>(2);
            StepsOption stepsOption2 = (StepsOption)wizard.getStepsOptions().get(0);
            currentStepMap.put("currentStep", 0);
            if (ShardTaskWarningStatusEnum.TIMEOUT.getKey().equals(warningStatus)) {
                stepsOption2.setDescription(new LocaleString(ResManager.loadKDString((String)"\u96c6\u7fa4\u4e2d\u8282\u70b9\u540c\u6b65\u5f02\u5e38\uff0c\u70b9\u51fb\u6b64\u5904\u67e5\u770b\u8be6\u60c5\u3002", (String)"ShardingTaskEditPlugin_14", (String)"bos-cbs-plugin", (Object[])new Object[0])));
                currentStepMap.put("currentStatus", "error");
            } else {
                currentStepMap.put("currentStatus", "process");
            }
            wizard.setWizardStepsOptions(wizard.getStepsOptions());
            wizard.setWizardCurrentStep(currentStepMap);
        } else if (ShardTaskNodeEnum.CLUSTERTBUNLOCK.getKey().equals(taskNode)) {
            view.setVisible(Boolean.valueOf(true), new String[]{"label_desc"});
            HashMap<String, Object> currentStepMap = new HashMap<String, Object>(2);
            StepsOption stepsOption3 = (StepsOption)wizard.getStepsOptions().get(2);
            currentStepMap.put("currentStep", 2);
            if (ShardTaskWarningStatusEnum.TIMEOUT.getKey().equals(warningStatus)) {
                stepsOption3.setDescription(new LocaleString(ResManager.loadKDString((String)"\u96c6\u7fa4\u4e2d\u8282\u70b9\u540c\u6b65\u5f02\u5e38\uff0c\u70b9\u51fb\u6b64\u5904\u67e5\u770b\u8be6\u60c5\u3002", (String)"ShardingTaskEditPlugin_14", (String)"bos-cbs-plugin", (Object[])new Object[0])));
                currentStepMap.put("currentStatus", "error");
            } else if (ShardTaskStatusEnum.SUCCESS.getKey().equals(taskStatus)) {
                currentStepMap.put("currentStatus", "finish");
            } else {
                currentStepMap.put("currentStatus", "process");
            }
            wizard.setWizardStepsOptions(wizard.getStepsOptions());
            wizard.setWizardCurrentStep(currentStepMap);
        } else {
            view.setVisible(Boolean.valueOf(true), new String[]{"label_desc"});
            HashMap<String, Object> currentStepMap = new HashMap<String, Object>(2);
            currentStepMap.put("currentStep", 1);
            if (ShardTaskStatusEnum.FAILED.getKey().equals(taskStatus)) {
                ((StepsOption)wizard.getStepsOptions().get(1)).setDescription(new LocaleString(ResManager.loadKDString((String)"\u4efb\u52a1\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"ShardingTaskEditPlugin_15", (String)"bos-cbs-plugin", (Object[])new Object[0])));
                currentStepMap.put("currentStatus", "error");
            } else {
                ((StepsOption)wizard.getStepsOptions().get(1)).setDescription(new LocaleString(ResManager.loadKDString((String)"\u6570\u636e\u5206\u6790\u8fc1\u79fb\u4e2d\u3002", (String)"ShardingTaskEditPlugin_16", (String)"bos-cbs-plugin", (Object[])new Object[0])));
                currentStepMap.put("currentStatus", "process");
            }
            wizard.setWizardStepsOptions(wizard.getStepsOptions());
            wizard.setWizardCurrentStep(currentStepMap);
        }
    }

    public void createListDataProvider(BeforeCreateListDataProviderArgs beforeCreateListDataProviderArgs) {
        beforeCreateListDataProviderArgs.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows = super.getData(start, limit);
                if (rows.isEmpty()) {
                    return rows;
                }
                if (!((DynamicObject)rows.get(0)).getDataEntityType().getProperties().containsKey((Object)"shard_progress")) {
                    return rows;
                }
                for (DynamicObject row : rows) {
                    BigDecimal shardTotalRecord = row.getBigDecimal("shard_total_record");
                    BigDecimal shardMovingRecord = row.getBigDecimal("shard_moving_record");
                    if (shardTotalRecord.compareTo(BigDecimal.ZERO) == 0) {
                        if (!"2".equals(row.getString("taskstatus"))) continue;
                        row.set("shard_progress", (Object)"100%");
                        continue;
                    }
                    if (shardMovingRecord.compareTo(BigDecimal.ZERO) == 0) {
                        row.set("shard_progress", (Object)"0%");
                        continue;
                    }
                    BigDecimal progress = shardMovingRecord.multiply(HUNDRED).divide(shardTotalRecord, 1, 4);
                    if (progress.compareTo(HUNDRED) == 0) {
                        row.set("shard_progress", (Object)(progress.setScale(0) + ShardingTaskEditPlugin.PERCENT));
                        continue;
                    }
                    row.set("shard_progress", (Object)(progress + ShardingTaskEditPlugin.PERCENT));
                }
                return rows;
            }
        });
    }

    public void update(StepEvent stepEvent) {
        int value = stepEvent.getValue();
        IDataModel model = this.getModel();
        String warningStatus = (String)model.getValue("warningstatus");
        if ((value == 0 || value == 2) && warningStatus.equals(ShardTaskWarningStatusEnum.TIMEOUT.getKey())) {
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("bos_cbs_shard_cluster");
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            String entityNumber = (String)model.getValue("entitynumber");
            ORM orm = ORM.create();
            String tableName = orm.getDataEntityType(entityNumber).getAlias();
            fsp.getCustomParams().put("tableName", tableName);
            fsp.getCustomParams().put("entityNumber", entityNumber);
            if (ShardTaskTypeEnum.SHARDARCHIVE.getKey().equals(model.getValue("tasktype"))) {
                DynamicObject configLoad = BusinessDataServiceHelper.loadSingle((Object)model.getValue("config"), (String)"bos_cbs_shard_archi");
                Long configid = ((DynamicObject)configLoad.get("configid")).getLong("id");
                fsp.getCustomParams().put("config", configid);
            } else if (ShardTaskTypeEnum.MOVEINDEX.getKey().equals(model.getValue("tasktype"))) {
                DynamicObject configLoad = BusinessDataServiceHelper.loadSingle((Object)model.getValue("config"), (String)"bos_cbs_shard_fast_index");
                Long configid = ((DynamicObject)configLoad.get("config")).getLong("id");
                fsp.getCustomParams().put("config", configid);
            } else {
                fsp.getCustomParams().put("config", model.getValue("config"));
            }
            this.getView().showForm(fsp);
        }
    }
}

