/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.sharding.list;

import java.util.ArrayList;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cbs.plugin.statistics.common.util.XDBStatisticsHelper;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.entity.ShardArchiKanbanDetailEntity;
import kd.bos.xdb.entity.ShardArchiKanbanEntity;
import kd.bos.xdb.entity.ShardConfigEntity;
import kd.bos.xdb.repository.ShardArchiKanbanRepository;
import kd.bos.xdb.repository.ShardConfigRepository;
import kd.bos.xdb.sharding.config.MainTableConfig;
import kd.bos.xdb.sharding.config.ShardingConfig;
import kd.bos.xdb.sharding.config.ShardingIndexRoute;

public class ShardingArchiKanbanListPlugin
extends AbstractListPlugin {
    private static final Log log = LogFactory.getLog(ShardingArchiKanbanListPlugin.class);

    public void billListHyperLinkClick(HyperLinkClickArgs hyperEvt) {
        String fieldName = hyperEvt.getFieldName();
        BillListHyperLinkClickEvent linkClickEvent = (BillListHyperLinkClickEvent)hyperEvt.getHyperLinkClickEvent();
        String entityNumber = linkClickEvent.getCurrentRow().getNumber();
        long fid = (Long)linkClickEvent.getCurrentRow().getPrimaryKeyValue();
        if (!QueryServiceHelper.exists((String)"bos_cbs_shard_archikanban", (Object)fid)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"ShardingArchiListPlugin_4", (String)"bos-cbs-plugin", (Object[])new Object[0]));
            hyperEvt.setCancel(true);
            return;
        }
        if ("configid_name".equals(fieldName)) {
            try {
                this.reinitShardArchiRoute(entityNumber, fid);
            }
            catch (Exception e) {
                log.error("reinitShardArchiRoute occur an error: " + e.getMessage(), (Throwable)e);
            }
        }
        ListSelectedRow row = ((BillList)hyperEvt.getHyperLinkClickEvent().getSource()).getCurrentSelectedRowInfo();
        BillShowParameter fsp = new BillShowParameter();
        fsp.setFormId("bos_cbs_shard_archikanban");
        fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        fsp.setStatus(OperationStatus.EDIT);
        fsp.setPkId(row.getPrimaryKeyValue());
        fsp.setCaption(ResManager.loadKDString((String)"\u5206\u5e93\u770b\u677f", (String)"ShardingArchiKanbanListPlugin_1", (String)"bos-cbs-plugin", (Object[])new Object[0]));
        this.getView().showForm((FormShowParameter)fsp);
        hyperEvt.setCancel(true);
    }

    private void reinitShardArchiRoute(String entityNumber, long fid) {
        IDataEntityType dt = ORM.create().getDataEntityType(entityNumber);
        String dbRouteKey = dt.getDBRouteKey();
        ShardConfigEntity configEntity = ShardConfigRepository.get().loadConfig(entityNumber);
        List shardingConfigs = configEntity.toShardingConfigs(false);
        MainTableConfig mainConfig = XDBConfig.getShardingConfigProvider().getConfigByEntity(entityNumber);
        ShardingIndexRoute indexRoute = mainConfig.getOptions().getIndexRoute();
        ArrayList detailEntities = new ArrayList();
        for (ShardingConfig config : shardingConfigs) {
            String tableName = config.getTable();
            String typeFromConfig = XDBStatisticsHelper.getTypeFromConfig(config);
            try {
                DB.__setupExtContextForUsingXdbTableManager((DBRoute)DBRoute.of((String)dbRouteKey), (boolean)false, () -> {
                    String[] shardingTable;
                    for (String shardTable : shardingTable = XDBConfig.getTableManager().getShardingTable(tableName)) {
                        String shardRoute = indexRoute.getRoute(shardTable);
                        ShardArchiKanbanDetailEntity entity = new ShardArchiKanbanDetailEntity();
                        entity.setShardtable(shardTable);
                        entity.setRoute(shardRoute);
                        entity.setTabletype(typeFromConfig);
                        detailEntities.add(entity);
                    }
                    return null;
                });
            }
            catch (Exception exception) {
                log.error(exception.getMessage(), (Throwable)exception);
            }
        }
        ShardArchiKanbanRepository kanbanRepository = ShardArchiKanbanRepository.get();
        ShardArchiKanbanEntity kanbanEntity = kanbanRepository.loadShardArchiKanban(entityNumber);
        kanbanRepository.clearShardArchiKanbanRouteDetail(kanbanEntity.getId());
        kanbanRepository.insertShardArchiKanbanRouteDetail(detailEntities, fid);
    }
}

