/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.sharding.list;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cbs.plugin.sharding.common.constant.Const;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.id.ID;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;

public class ShardingConfigTemplateListPlugin
extends AbstractListPlugin
implements Const {
    public void itemClick(ItemClickEvent evt) {
        IFormView view;
        BillList billList;
        ListSelectedRowCollection selectedRows;
        String itemKey = evt.getItemKey();
        if ("bar_gen_sql".equals(itemKey) && !(selectedRows = (billList = (BillList)(view = this.getView()).getControl("billlistap")).getSelectedRows()).isEmpty()) {
            Object[] pkIds = selectedRows.getPrimaryKeyValues();
            Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((Object[])pkIds, (String)"bos_cbs_shard_config_tpl");
            StringBuilder sqlScript = new StringBuilder((pkIds.length + 1) * 1024);
            sqlScript.append(this.scriptHead());
            dynamicObjectMap.forEach((k, v) -> sqlScript.append(this.genFormShardingConfigTplSql((DynamicObject)v)));
            String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl("kd_biz_xx_form_sc_tpl.sql", sqlScript.toString().getBytes(StandardCharsets.UTF_8), 500);
            view.openUrl(url);
            view.showMessage(ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f\u3002", (String)"ShardingConfigTemplateListPlugin_1", (String)"bos-cbs-plugin", (Object[])new Object[0]));
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ShardConfigTemplateDataProvider());
    }

    private String scriptHead() {
        return String.format(ResManager.loadKDString((String)"/* creator:%1$s%2$s\u8bf7\u624b\u5de5\u4fee\u6539\u662f\u5426\u539f\u5382\u5b57\u6bb5FISOEM,\u63cf \u8ff0\uff1a0\u4ee3\u8868\u975e\u539f\u5382\uff0c1\u8868\u793a\u539f\u5382\u3002%3$s*/%4$s\u3002", (String)"ShardingConfigTemplateListPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[0]), RequestContext.get().getUserName(), "\r\n", "\n", "\r\n");
    }

    private String genFormShardingConfigTplSql(DynamicObject v) {
        int lastIndexOfN;
        StringBuilder ret = new StringBuilder(1024);
        String strategyParams = v.getString("strategyparams");
        int n = lastIndexOfN = strategyParams != null ? strategyParams.lastIndexOf("\n") : -1;
        if (lastIndexOfN != -1 && lastIndexOfN == strategyParams.length() - 1) {
            strategyParams = strategyParams.substring(0, lastIndexOfN);
        }
        ret.append("DELETE FROM T_CBS_SHARD_CONFIG_TPL WHERE FID=").append(v.getPkValue()).append(";\r\n");
        ret.append("INSERT INTO T_CBS_SHARD_CONFIG_TPL (FID, FENTITYNUMBER, FNUMBER, FSHARDINGFIELDS, FSTRATEGYZH_CN, FSTRATEGYPARAMS, FSTRATEGY, FISOEM) VALUES(").append(v.getPkValue()).append(", '").append(v.getDynamicObject("entitynumber").getString("number")).append("', '").append(v.getString("number")).append("', '").append(v.getString("shardingfields")).append("', '").append(v.getString("strategyzh_cn")).append("', '").append(strategyParams).append("', '").append(v.getString("strategy")).append("', '").append(0).append("');\r\n");
        ret.append("DELETE FROM T_CBS_SHARD_CONFIG_TPL_L WHERE FID=").append(v.getPkValue()).append(";\r\n");
        ret.append("INSERT INTO T_CBS_SHARD_CONFIG_TPL_L (FPKID, FID, FLOCALEID, FNAME) VALUES('").append(ID.genStringId()).append("', ").append(v.getPkValue()).append(", ").append("'zh_CN'").append(", '").append(v.getString("name")).append("');\r\n\r\n");
        return ret.toString();
    }

    static class ShardConfigTemplateDataProvider
    extends ListDataProvider {
        ShardConfigTemplateDataProvider() {
        }

        public DynamicObjectCollection getData(int arg0, int arg1) {
            DynamicObjectCollection rows = super.getData(arg0, arg1);
            if (rows.isEmpty()) {
                return rows;
            }
            for (DynamicObject row : rows) {
                String strategy_multilang;
                String strategy = row.getString("strategyzh_cn");
                if (StringUtils.isEmpty((String)strategy)) continue;
                switch (strategy) {
                    case "ID\u65f6\u5e8f\u7b56\u7565": {
                        strategy_multilang = ResManager.loadKDString((String)"ID\u65f6\u5e8f\u7b56\u7565", (String)"ShardingChooseStrategyEditPlugin_19", (String)"bos-cbs-plugin", (Object[])new Object[0]);
                        break;
                    }
                    case "\u54c8\u5e0c\u53d6\u6a21": {
                        strategy_multilang = ResManager.loadKDString((String)"\u54c8\u5e0c\u53d6\u6a21", (String)"ShardingChooseStrategyEditPlugin_21", (String)"bos-cbs-plugin", (Object[])new Object[0]);
                        break;
                    }
                    case "\u6309\u65e5\u5206\u7247": {
                        strategy_multilang = ResManager.loadKDString((String)"\u6309\u65e5\u5206\u7247", (String)"ShardingChooseStrategyEditPlugin_3", (String)"bos-cbs-plugin", (Object[])new Object[0]);
                        break;
                    }
                    case "\u6309\u6708\u5206\u7247": {
                        strategy_multilang = ResManager.loadKDString((String)"\u6309\u6708\u5206\u7247", (String)"ShardingChooseStrategyEditPlugin_7", (String)"bos-cbs-plugin", (Object[])new Object[0]);
                        break;
                    }
                    case "\u6309\u5e74\u5206\u7247": {
                        strategy_multilang = ResManager.loadKDString((String)"\u6309\u5e74\u5206\u7247", (String)"ShardingChooseStrategyEditPlugin_10", (String)"bos-cbs-plugin", (Object[])new Object[0]);
                        break;
                    }
                    case "\u65e5\u671f\u6c42\u6a21\u5206\u7247": {
                        strategy_multilang = ResManager.loadKDString((String)"\u65e5\u671f\u6c42\u6a21\u5206\u7247", (String)"ShardingChooseStrategyEditPlugin_13", (String)"bos-cbs-plugin", (Object[])new Object[0]);
                        break;
                    }
                    case "\u6620\u5c04\u7b56\u7565": {
                        strategy_multilang = ResManager.loadKDString((String)"\u6620\u5c04\u7b56\u7565", (String)"ShardingChooseStrategyEditPlugin_26", (String)"bos-cbs-plugin", (Object[])new Object[0]);
                        break;
                    }
                    case "\u81ea\u5b9a\u4e49\u7b56\u7565": {
                        strategy_multilang = ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u7b56\u7565", (String)"ShardingChooseStrategyEditPlugin_23", (String)"bos-cbs-plugin", (Object[])new Object[0]);
                        break;
                    }
                    default: {
                        strategy_multilang = "";
                    }
                }
                row.set("strategyzh_cn", (Object)strategy_multilang);
            }
            return rows;
        }
    }
}

