/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.sharding.list;

import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cbs.plugin.sharding.common.constant.Const;
import kd.bos.cbs.plugin.sharding.common.entity.NodeInfo;
import kd.bos.cbs.plugin.statistics.common.util.XDBStatisticsHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.sharding.ShardConfigLoader;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ITreeListView;
import kd.bos.list.ListOperationColumn;
import kd.bos.list.column.ListOperationColumnDesc;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.ServiceInfoFactory;
import kd.bos.mservice.endpoint.EndPointDispatchServiceHelper;
import kd.bos.mservice.monitor.ServiceInfo;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.xdb.entity.ShardRuntimeConfigEntity;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.mservice.ShardingMetadataServiceImpl;
import kd.bos.xdb.repository.impl.ShardConfigLoaderImpl;
import kd.bos.xdb.sharding.config.ShardingConfig;

public class ShardingRuntimeInfoListPlugin
extends StandardTreeListPlugin
implements Const {
    private static final Log logger = LogFactory.getLog(ShardingRuntimeInfoListPlugin.class);

    public void initTreeToolbar(EventObject e) {
        super.initTreeToolbar(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanel_treebtn"});
    }

    public void initializeTree(EventObject e) {
        super.initializeTree(e);
        this.getTreeModel().setRootVisable(true);
        TreeNode root = this.getTreeModel().getRoot();
        root.setText(ResManager.loadKDString((String)"\u8282\u70b9\u4fe1\u606f", (String)"ShardingRuntimeInfoListPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[0]));
    }

    public void refreshNode(RefreshNodeEvent e) {
        super.refreshNode(e);
        TreeNode root = this.getTreeModel().getRoot();
        String currNodeId = (String)e.getNodeId();
        if (StringUtils.equals((CharSequence)currNodeId, (CharSequence)root.getId())) {
            e.setChildNodes(this.loadTreeNodes());
        } else {
            e.setChildNodes(null);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if (Objects.equals(operate.getOperateKey(), "viewmap")) {
            CurrentRowData currentRowData = this.getCurrentRowData();
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("bos_cbs_shard_indexmap");
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            fsp.setCustomParam("ip", (Object)currentRowData.getIp());
            fsp.setCustomParam("table", (Object)currentRowData.getTable());
            this.getView().showForm(fsp);
            args.setCancel(true);
        }
    }

    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.addPackageDataListener(packageDataEvent -> {
            DynamicObject rowData = packageDataEvent.getRowData();
            Object type = rowData.get("type");
            if (packageDataEvent.getSource() instanceof ListOperationColumnDesc && "listoperationcolumnap".equalsIgnoreCase(((ListOperationColumnDesc)packageDataEvent.getSource()).getKey())) {
                List operationColItems = (List)packageDataEvent.getFormatValue();
                for (OperationColItem operationColItem : operationColItems) {
                    if (!"viewmap".equalsIgnoreCase(operationColItem.getOperationKey()) || Objects.equals(type, "0")) continue;
                    operationColItem.setVisible(false);
                    operationColItem.setLocked(true);
                }
            }
        });
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        String strategy = (String)this.getView().getFormShowParameter().getCustomParam("strategy");
        if ("MapStrategy".equalsIgnoreCase(strategy)) {
            return;
        }
        List columnList = args.getListColumns().stream().filter(column -> column.getClass() != ListOperationColumn.class).collect(Collectors.toList());
        args.setListColumns(columnList);
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        super.buildTreeListFilter(e);
        String nodeId = (String)e.getNodeId();
        QFilter filter = this.buildNodeQFilter(nodeId);
        e.addQFilter(filter);
        e.setCancel(true);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new MyListDataProvider());
    }

    private CurrentRowData getCurrentRowData() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRow currentSelectedRowInfo = billList.getCurrentSelectedRowInfo();
        String primaryKeyValue = (String)currentSelectedRowInfo.getPrimaryKeyValue();
        List primaryKeyValueList = Splitter.on((String)":").splitToList((CharSequence)primaryKeyValue);
        return new CurrentRowData((String)primaryKeyValueList.get(0), (String)primaryKeyValueList.get(1));
    }

    private List<TreeNode> loadTreeNodes() {
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(50);
        List<NodeInfo> nodeInfoList = this.getAllNodeInfoFromZk();
        for (NodeInfo nodeInfo : nodeInfoList) {
            TreeNode treeNode = new TreeNode();
            treeNode.setId(nodeInfo.getIp());
            treeNode.setText(String.format("%s[%s]", nodeInfo.getInstanceId(), nodeInfo.getIp()));
            treeNode.setParentid("0");
            treeNodes.add(treeNode);
        }
        return treeNodes;
    }

    private List<NodeInfo> getAllNodeInfoFromZk() {
        try {
            ArrayList<NodeInfo> nodeInfoList = new ArrayList<NodeInfo>(50);
            List serviceInfos = ServiceInfoFactory.get().getServiceList();
            for (ServiceInfo node : serviceInfos) {
                NodeInfo nodeInfo = new NodeInfo();
                nodeInfo.setAppName(node.getAppName());
                nodeInfo.setInstanceId(node.getInstanceId());
                nodeInfo.setIp(node.getIp());
                nodeInfo.setWebPort(node.getWebPort());
                nodeInfo.setStartTimestamp(node.getStartTimestamp());
                nodeInfoList.add(nodeInfo);
            }
            return nodeInfoList;
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap((Throwable)e);
        }
    }

    private QFilter buildNodeQFilter(String nodeId) {
        TreeNode root = this.getTreeModel().getRoot();
        if (!Objects.equals(root.getId(), nodeId)) {
            return new QFilter("ip", "=", (Object)nodeId);
        }
        return null;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if ("refreshNode".equalsIgnoreCase(evt.getOperationKey())) {
            ITreeModel treeModel = this.getTreeModel();
            TreeNode root = treeModel.getRoot();
            if (!Objects.equals(root.getId(), treeModel.getCurrentNodeId())) {
                root.setChildren(this.loadTreeNodes());
            }
            this.getTreeListView().refreshTreeView();
        }
    }

    public void afterCreateNewData(EventObject e) {
        IListView listView = (IListView)this.getView();
        ITreeListView treeListView = listView.getTreeListView();
        treeListView.refreshTreeView();
        String number = (String)this.getView().getFormShowParameter().getCustomParam("number");
        String strategyZh = (String)this.getView().getFormShowParameter().getCustomParam("strategyzh_cn");
        this.getModel().setValue("number", (Object)number);
        this.getModel().setValue("entitynumber", (Object)number);
        this.getModel().setValue("strategyzh_cn", (Object)strategyZh);
    }

    class MyListDataProvider
    extends ListDataProvider {
        MyListDataProvider() {
        }

        public DynamicObjectCollection getData(int start, int limit) {
            super.getData(start, limit);
            String ip = this.getIp();
            if (StringUtils.isEmpty((CharSequence)ip)) {
                ShardingRuntimeInfoListPlugin.this.getPageCache().put("realCount", "0");
                return new DynamicObjectCollection(this.getQueryBuilder().getReturnEntityType(), null);
            }
            ShardingRuntimeInfoListPlugin.this.getPageCache().put("ip", ip);
            List<ShardRuntimeConfigEntity> runtimeConfigEntities = this.getShardRuntimeConfigEntities(ip);
            ShardingRuntimeInfoListPlugin.this.getPageCache().put("realCount", runtimeConfigEntities.size() + "");
            DynamicObjectCollection col = this.getDynamicObjectCollection(start, limit, runtimeConfigEntities);
            this.getQueryResult().setCollection(col);
            return col;
        }

        public int getRealCount() {
            return Integer.parseInt(ShardingRuntimeInfoListPlugin.this.getPageCache().get("realCount"));
        }

        private DynamicObjectCollection getDynamicObjectCollection(int start, int limit, List<ShardRuntimeConfigEntity> runtimeConfigEntities) {
            super.getData(start, limit);
            DynamicObjectCollection col = new DynamicObjectCollection(this.getQueryBuilder().getReturnEntityType(), null);
            for (int dataCount = start; dataCount < start + limit && dataCount < runtimeConfigEntities.size(); ++dataCount) {
                ShardRuntimeConfigEntity entity = runtimeConfigEntities.get(dataCount);
                DynamicObject obj = col.addNew();
                String ip = ShardingRuntimeInfoListPlugin.this.getPageCache().get("ip");
                obj.set("id", (Object)(ip + ":" + entity.getTable()));
                obj.set("table", (Object)entity.getTable());
                obj.set("type", (Object)entity.getType());
                obj.set("shardfields", (Object)entity.getShardFields());
                obj.set("level", (Object)entity.getLevel());
                obj.set("exists", (Object)(entity.isExists() ? "1" : "0"));
            }
            return col;
        }

        private List<ShardRuntimeConfigEntity> getShardRuntimeConfigEntities(String ip) {
            try {
                ShardConfigLoader shardConfigLoader = (ShardConfigLoader)Class.forName(ShardConfigLoaderImpl.class.getName()).newInstance();
                String entityNumber = (String)ShardingRuntimeInfoListPlugin.this.getView().getFormShowParameter().getCustomParam("number");
                List<ShardRuntimeConfigEntity> runtimeConfigEntities = new ArrayList<ShardRuntimeConfigEntity>(100);
                Set bosShardingConfigSet = shardConfigLoader.load(entityNumber);
                if (CollectionUtils.isEmpty((Collection)bosShardingConfigSet)) {
                    return runtimeConfigEntities;
                }
                Map<String, String> table2TypeMap = this.getTable2TypeMap(bosShardingConfigSet);
                runtimeConfigEntities = this.getRuntimeConfigEntities(ip, new ArrayList<String>(table2TypeMap.keySet()));
                runtimeConfigEntities.forEach(entity -> entity.setType((String)table2TypeMap.get(entity.getTable())));
                Collections.sort(runtimeConfigEntities);
                return runtimeConfigEntities;
            }
            catch (Exception e) {
                throw ExceptionUtil.wrap((Throwable)e);
            }
        }

        private Map<String, String> getTable2TypeMap(Set<ShardingConfig> bosShardingConfigSet) {
            return bosShardingConfigSet.stream().collect(Collectors.toMap(ShardingConfig::getTable, XDBStatisticsHelper::getTypeFromConfig));
        }

        private String getIp() {
            QFilter ipQFilter = this.getIpQFilter();
            if (Objects.nonNull(ipQFilter)) {
                return (String)ipQFilter.getValue();
            }
            return "";
        }

        private QFilter getIpQFilter() {
            return this.getQFilters().stream().filter(qFilter -> "ip".equals(qFilter.getProperty())).findFirst().orElse(null);
        }

        private List<ShardRuntimeConfigEntity> getRuntimeConfigEntities(String ip, List<String> tableList) {
            ArrayList<ShardRuntimeConfigEntity> runtimeConfigEntities = new ArrayList(16);
            try {
                runtimeConfigEntities = (List)EndPointDispatchServiceHelper.invoke((String)ip, (String)ShardingMetadataServiceImpl.class.getName(), (String)"getRuntimeConfigEntities", (Object[])new Object[]{tableList});
            }
            catch (Exception e) {
                logger.warn("\u83b7\u53d6\u8fd0\u884c\u65f6\u5206\u7247\u914d\u7f6e\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38\uff0cerrMsg: {}, ip: {}, tableList: {}", new Object[]{e.getMessage(), ip, String.join((CharSequence)",", tableList), e});
            }
            return runtimeConfigEntities;
        }
    }

    private static class CurrentRowData {
        private final String ip;
        private final String table;

        public CurrentRowData(String ip, String table) {
            this.ip = ip;
            this.table = table;
        }

        public String getIp() {
            return this.ip;
        }

        public String getTable() {
            return this.table;
        }
    }
}

