/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.statistics.common.entity;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MetricInfoEntity {
    private static final Pattern regex = Pattern.compile("\\[XPM\\] ((\\w+\\(\\d+>\\d+\\))[: \\w\\[\\],\\$]+|(\\w+)[ \\w\\.]+@[\\w]+[: \\w\\[\\],]+|(Update sharding field: )[\\w\\[\\], ]+)\n\tSQL:\n([\\w \\(\\)\n\t\r:?\\.\",=\\$!><]+)|(Execute error:)([\\w\\W \\(\\)\n\t\r:?\\.\",=\\$!><\\*/';]+)|(TotalSpent over limit \\(\\d+>\\d+\\w+\\))([\\w \\(\\)\n\t\r:?\\.\",=\\$!><\\*/]+)\n\t\\.{3}");
    private static final String indexStr = "at kd.bos.xdb.xpm.metrics";
    private String billNumber;
    private String flag;
    private String sql;
    private String stack;

    public MetricInfoEntity(String billNumber, String toHandleStr) {
        this.billNumber = billNumber;
        this.init(toHandleStr);
    }

    private void init(String toHandleStr) {
        Matcher matcher = regex.matcher(toHandleStr);
        if (matcher.find()) {
            String sqlWithStack;
            String executeError = matcher.group(6);
            String totalSpent = matcher.group(8);
            if (executeError == null) {
                if (totalSpent == null) {
                    String tooManyTable = matcher.group(2);
                    String withoutFullCondition = matcher.group(3);
                    String updateField = matcher.group(4);
                    this.flag = tooManyTable == null ? (withoutFullCondition == null ? updateField : withoutFullCondition) : tooManyTable;
                    sqlWithStack = matcher.group(5);
                } else {
                    this.flag = totalSpent;
                    sqlWithStack = matcher.group(9);
                }
            } else {
                this.flag = executeError;
                sqlWithStack = matcher.group(7);
            }
            int index = sqlWithStack.indexOf(indexStr);
            if (index != -1) {
                this.sql = sqlWithStack.substring(0, index).trim();
                this.stack = sqlWithStack.substring(index - 1).trim();
            } else {
                this.sql = sqlWithStack;
                this.stack = "";
            }
        } else {
            this.flag = "Matcher Error";
            this.sql = "Matcher Error";
            this.stack = toHandleStr;
        }
    }

    public String getBillNumber() {
        return this.billNumber;
    }

    public void setBillNumber(String billNumber) {
        this.billNumber = billNumber;
    }

    public String getFlag() {
        return this.flag;
    }

    public void setFlag(String flag) {
        this.flag = flag;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public String getStack() {
        return this.stack;
    }

    public void setStack(String stack) {
        this.stack = stack;
    }
}

