/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.statistics.config;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import kd.bos.db.RequestContextInfo;
import kd.bos.util.ConfigurationUtil;

public final class XDBStatisticsConfig {
    private static boolean enabled = false;
    private static Set<String> statAccountIds = new HashSet<String>();
    private static int dayInterval = 7;

    public static boolean isEnabled() {
        return enabled;
    }

    public static int getDayInterval() {
        return dayInterval;
    }

    public static boolean isAccountEnable() {
        if (enabled) {
            RequestContextInfo rc = RequestContextInfo.get();
            if (rc == null) {
                return false;
            }
            return statAccountIds.isEmpty() || statAccountIds.contains(rc.getAccountId());
        }
        return false;
    }

    static {
        ConfigurationUtil.observeBoolean((String)"xdb.stat.enable", (boolean)enabled, v -> {
            enabled = v;
        });
        ConfigurationUtil.observeInteger((String)"xdb.stat.dayInterval", (int)dayInterval, v -> {
            dayInterval = v;
        });
        ConfigurationUtil.observeString((String)"xdb.stat.accountIds", (String)"", v -> {
            if (v != null && v.length() > 0) {
                statAccountIds = new HashSet<String>(Arrays.asList(v.split(",")));
            }
        });
    }
}

