/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.statistics.plugin.edit;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cbs.plugin.statistics.common.entity.MetricInfoEntity;
import kd.bos.cbs.plugin.statistics.service.MetricInfoEntityService;
import kd.bos.cbs.plugin.tools.OperateLogUtil;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.id.ID;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class XDBMetricListPlugin
extends AbstractListPlugin {
    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"_toolbar_"});
    }

    public void itemClick(ItemClickEvent evt) {
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String itemKey = source.getOperateKey();
        if ("bar_group".equals(itemKey)) {
            String confirmTip = ResManager.loadKDString((String)"\u7edf\u8ba1\u91c7\u96c6\u7684\u6240\u6709\u6307\u6807\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\uff1f", (String)"XDBMetricListPlugin_0", (String)"bos-cbs-plugin", (Object[])new Object[0]);
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("statisticGroup");
            this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Save, confirmCallBackListener);
        } else if ("bar_delete".equals(itemKey)) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (selectedRows.isEmpty()) {
                return;
            }
            String confirmTip = ResManager.loadKDString((String)"\u5220\u9664\u6240\u9009\u8868\u5355\u7684\u6240\u6709\u7edf\u8ba1\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\uff1f", (String)"XDBMetricListPlugin_1", (String)"bos-cbs-plugin", (Object[])new Object[0]);
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("deleteBillStatistic");
            this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Delete, confirmCallBackListener);
        } else if ("bar_clear".equals(itemKey)) {
            String confirmTip = ResManager.loadKDString((String)"\u6e05\u9664\u6240\u6709\u6307\u6807\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\uff1f", (String)"XDBMetricListPlugin_2", (String)"bos-cbs-plugin", (Object[])new Object[0]);
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("clearBillStatistic");
            this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Delete, confirmCallBackListener);
        } else if ("bar_view".equals(itemKey)) {
            ListShowParameter lsp = new ListShowParameter();
            lsp.setBillFormId("bos_cbs_shard_metric_stat");
            lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)lsp);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            if (messageBoxClosedEvent.getCallBackId().equals("statisticGroup")) {
                ORM orm = ORM.create();
                DynamicObject statDyObj = orm.newDynamicObject("bos_cbs_shard_metric_stat");
                long id = DB.genGlobalLongId();
                Date date = ID.getCreateTime((long)id);
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd-HHmmssSSS");
                String number = "GS-" + sdf.format(date);
                statDyObj.set("id", (Object)id);
                statDyObj.set("number", (Object)number);
                statDyObj.set("createtime", (Object)date);
                DynamicObjectCollection entryEntityCol = statDyObj.getDynamicObjectCollection("entryentity");
                List<String> billNumbers = MetricInfoEntityService.get().queryDistinctMetricBillNumber();
                if (billNumbers.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u6307\u6807\u4fe1\u606f\uff0c\u4e0d\u7528\u7edf\u8ba1\u3002", (String)"XDBMetricListPlugin_3", (String)"bos-cbs-plugin", (Object[])new Object[0]));
                    return;
                }
                for (String billNumber : billNumbers) {
                    DynamicObject entryEntity = orm.newDynamicObject("bos_cbs_shard_metric_stat.entryentity");
                    entryEntity.set("billnumber", (Object)billNumber);
                    DynamicObjectCollection subEntryEntityCol = entryEntity.getDynamicObjectCollection("subentryentity");
                    List<MetricInfoEntity> metricInfos = MetricInfoEntityService.get().queryMetricInfoByBillNumber(billNumber);
                    ArrayList collect = metricInfos.parallelStream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<MetricInfoEntity>(Comparator.comparing(s -> {
                        if (s.getSql() != null) {
                            return s.getSql();
                        }
                        return "";
                    }))), ArrayList::new));
                    for (MetricInfoEntity mie : collect) {
                        DynamicObject subEntryEntity = orm.newDynamicObject("bos_cbs_shard_metric_stat.entryentity.subentryentity");
                        subEntryEntity.set("flag", (Object)mie.getFlag());
                        subEntryEntity.set("sql", (Object)mie.getSql());
                        subEntryEntity.set("stack", (Object)mie.getStack());
                        subEntryEntityCol.add((Object)subEntryEntity);
                    }
                    entryEntityCol.add((Object)entryEntity);
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{statDyObj});
                BillShowParameter fsp = new BillShowParameter();
                fsp.setFormId("bos_cbs_shard_metric_stat");
                fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                fsp.setStatus(OperationStatus.VIEW);
                fsp.setPkId((Object)id);
                this.getView().showForm((FormShowParameter)fsp);
            } else if (messageBoxClosedEvent.getCallBackId().equals("deleteBillStatistic")) {
                this.getView().invokeOperation("dodelete");
            } else if (messageBoxClosedEvent.getCallBackId().equals("clearBillStatistic")) {
                this.clearListData();
            }
        }
    }

    public void recordLog(String opName, String opDesc) {
    }

    private void clearListData() {
        String sql = "truncate table t_cbs_shard_metric ";
        DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[0]);
        String opName = "bar_clear";
        String opDesc = ResManager.loadKDString((String)"\u6e05\u9664\u5206\u7247\u6307\u6807\u91c7\u96c6\u6570\u636e\u6210\u529f", (String)"XDBMetricListPlugin_7", (String)"bos-cbs-plugin", (Object[])new Object[0]);
        MultiLangEnumBridge langEnumBridge = new MultiLangEnumBridge("\u6e05\u9664\u5206\u7247\u6307\u6807\u91c7\u96c6\u6570\u636e\u6210\u529f", "XDBMetricListPlugin_7", "bos-cbs-plugin");
        OperateLogUtil.insertSimpleOperateLog(this.getView(), "bos_cbs_shard_metric", opName, opDesc, RequestContext.get().getOrgId(), "bos_cbs_shard_metric", langEnumBridge, new String[0]);
        this.getView().invokeOperation("refresh");
    }

    public void afterDoOperation(AfterDoOperationEventArgs ae) {
        super.afterDoOperation(ae);
        String operateKey = ae.getOperateKey();
        if ("dodelete".equals(operateKey)) {
            BillList billList = (BillList)this.getControl("billlistap");
            HashSet<String> billNoSet = new HashSet<String>();
            DynamicObjectCollection collection = billList.getSelectedGridDatas(billList.getListFields()).getCollection();
            for (DynamicObject dyo : collection) {
                String billNumber = dyo.getString("billnumber");
                billNoSet.add(billNumber);
            }
            if (!billNoSet.isEmpty()) {
                billNoSet.forEach(item -> {
                    String opName = "bar_delete";
                    String opDesc = String.format(ResManager.loadKDString((String)"\u7f16\u53f7%s\uff0c\u5220\u9664\u6210\u529f", (String)"XDBMetricListPlugin_5", (String)"bos-cbs-plugin", (Object[])new Object[0]), item);
                    MultiLangEnumBridge langEnumBridge = new MultiLangEnumBridge("\u7f16\u53f7%s\uff0c\u5220\u9664\u6210\u529f", "XDBMetricListPlugin_5", "bos-cbs-plugin");
                    OperateLogUtil.insertSimpleOperateLog(this.getView(), "bos_cbs_shard_metric", opName, opDesc, RequestContext.get().getOrgId(), item, langEnumBridge, item);
                });
                QFilter qf = new QFilter("billnumber", "in", billNoSet);
                BusinessDataWriter.delete((String)"bos_cbs_shard_metric", (QFilter[])qf.toArray());
                this.getView().invokeOperation("refresh");
            }
        }
    }

    private <T> Predicate<T> distinct(Function<? super T, ?> key) {
        ConcurrentHashMap map = new ConcurrentHashMap();
        return t -> map.putIfAbsent(key.apply(t), Boolean.TRUE) == null;
    }
}

