/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cbs.plugin.tools;

import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.api.BizAppService;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.service.ServiceFactory;
import kd.bos.service.TimeService;

public class OperateLogUtil {
    public static void insertSimpleOperateLog(IFormView view, String formNumber, String opName, String opDesc, Long orgId, String modifyBillNo, MultiLangEnumBridge langEnumBridge, String ... args) {
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        OpLogAppInfo logInfo = OperateLogUtil.buildLogInfo(opDesc, orgId, opName, formNumber, view, langEnumBridge, args);
        logInfo.setModifyBillNo(modifyBillNo);
        logService.addLog((AppLogInfo)logInfo);
    }

    private static OpLogAppInfo buildLogInfo(String msg, Long orgId, String opKey, String formNumber, IFormView view, MultiLangEnumBridge langEnumBridge, String ... args) {
        AppInfo appInfo;
        OpLogAppInfo logInfo = new OpLogAppInfo();
        logInfo.setUserID(Long.valueOf(RequestContext.get().getUserId()));
        String appNumber = view.getFormShowParameter().getAppId();
        String appId = " ";
        if (StringUtils.isNotEmpty((CharSequence)appNumber) && null != (appInfo = AppMetadataCache.getAppInfo((String)appNumber))) {
            appId = appInfo.getId();
        }
        if (StringUtils.isBlank((CharSequence)appId)) {
            ListShowParameter param;
            BizAppService bizAppService = (BizAppService)ServiceFactory.getService(BizAppService.class);
            String billFormId = null;
            if (view.getFormShowParameter() instanceof ListShowParameter) {
                param = (ListShowParameter)view.getFormShowParameter();
                billFormId = param.getBillFormId();
            } else if (view.getFormShowParameter() instanceof BillShowParameter) {
                param = (BillShowParameter)view.getFormShowParameter();
                billFormId = param.getFormId();
            }
            if (StringUtils.isNotBlank(billFormId)) {
                appId = bizAppService.getAppIdByFormNum(billFormId);
            }
        }
        logInfo.setBizAppID(appId);
        logInfo.setBizObjID(formNumber);
        if (orgId != null && 0L != orgId) {
            logInfo.setOrgID(orgId);
        } else {
            logInfo.setOrgID(Long.valueOf(RequestContext.get().getOrgId()));
        }
        TimeService timeService = new TimeService();
        logInfo.setOpTime(timeService.getCurrentSystemTime());
        logInfo.setClientType(RequestContext.get().getClient());
        logInfo.setClientIP(RequestContext.get().getLoginIP());
        String opName = null;
        try {
            Map dataEntityOperate = EntityMetadataCache.getDataEntityOperate((String)view.getEntityId(), (String)opKey);
            opName = (String)((Map)dataEntityOperate.get("name")).get("zh_CN");
        }
        catch (Exception exception) {
            // empty catch block
        }
        logInfo.setOpName(opKey, opName);
        logInfo.setOpDesc(langEnumBridge, args);
        return logInfo;
    }

    public static void insertSimpleOperateLog(IFormView view, String formNumber, String opName, String opDesc, Long orgId) {
    }

    public static void insertSimpleOperateLog(IFormView view, String formNumber, String opName, String opDesc, Long orgId, String modifyBillNo) {
    }

    public static void insertOperateLog(AfterDoOperationEventArgs afterDoOperationEventArgs, String formNumber, String formName, String opDesc, IFormView view, boolean fromList) {
    }

    private static void writeLog(AfterDoOperationEventArgs afterDoOperationEventArgs, IFormView view, String formNumber, String msg) {
    }
}

