/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.algox;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import kd.bos.algox.JobSession;
import kd.bos.algox.cluster.ClusterFactory;
import kd.bos.algox.monitor.AlgoXJobMonitor;
import kd.bos.algox.monitor.AlgoXJobMonitorFactory;
import kd.bos.monitor.httpserver.AbstractHttpHandler;
import kd.bos.monitor.util.ExceptionHandler;
import kd.bos.monitor.util.HttpClients;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class IerpFlinkProxyHandler
extends AbstractHttpHandler {
    private String PLACEHOLDER = "/algoxfp/";
    private static final int READTIMEOUT = Integer.parseInt(System.getProperty("monitor.proxy.readtimeout", "60"));

    @Override
    public void handle(HttpExchange exchange) throws IOException {
        this.handle0(exchange);
    }

    @Override
    public void handle0(HttpExchange pExchange) throws IOException {
        URI uri = pExchange.getRequestURI();
        String reqPath = uri.getPath();
        int pos = reqPath.indexOf(this.PLACEHOLDER);
        char splitStr = '+';
        int regionStartIndex = reqPath.indexOf(splitStr);
        int regionEndIndex = reqPath.lastIndexOf(splitStr);
        String region = reqPath.substring(regionStartIndex + 1, regionEndIndex);
        reqPath = reqPath.replace(splitStr + region + splitStr, "");
        try {
            String response;
            reqPath = "/" + reqPath.substring(pos + this.PLACEHOLDER.length());
            Object reqPathData = this.formatPath(reqPath);
            if (reqPathData != null) {
                response = String.valueOf(reqPathData);
            } else {
                String monitorUrl = ClusterFactory.getFactory().getClusterClient().getMonitorUrl(region);
                reqPath = monitorUrl + "/" + reqPath;
                response = HttpClients.get(reqPath, null, 5000, READTIMEOUT * 1000);
            }
            this.writeJson(response, pExchange);
        }
        catch (Exception e) {
            this.writeHtml(ExceptionHandler.getExceptionStackTrace(e), pExchange);
        }
        pExchange.close();
    }

    private Object formatPath(String reqPath) throws IOException {
        if (reqPath.startsWith("/jobs/") && reqPath.endsWith("progress")) {
            String[] tempArr = reqPath.split("/");
            String id = tempArr[2];
            int jobProgress = JobSession.getJobProgress((String)id);
            return jobProgress;
        }
        if (reqPath.startsWith("/jobs/") && !"/jobs/overview".equals(reqPath)) {
            String jobDetailsStr;
            String[] tempArr = reqPath.split("/");
            if (tempArr.length < 3) {
                return null;
            }
            AlgoXJobMonitor aMonitor = AlgoXJobMonitorFactory.getAlgoXJobMonitor();
            Map dataMap = aMonitor.query((Object)tempArr[2]);
            if (dataMap == null) {
                return null;
            }
            Object jobDetails = dataMap.get("FJOBDETAILS");
            String string = jobDetailsStr = jobDetails == null ? null : String.valueOf(jobDetails);
            if (StringUtils.isNotEmpty((String)jobDetailsStr)) {
                Map jobDetailMap = (Map)JSONUtils.cast((String)jobDetailsStr, Map.class);
                return jobDetailMap.get(reqPath);
            }
        }
        return null;
    }
}

