/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.auth;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.util.Map;
import kd.bos.monitor.auth.Auther;
import kd.bos.monitor.auth.SessionStore;
import kd.bos.monitor.util.ClassicTo404;
import kd.bos.monitor.util.Encrypt;
import kd.bos.monitor.util.ExchangeUtils;
import kd.bos.monitor.util.TemplateUtil;
import kd.bos.monitor.util.UrlUtils;
import kd.bos.util.StringUtils;
import kd.bos.util.resource.Resources;

public class LoginHandler
implements HttpHandler {
    public static final LoginHandler instance = new LoginHandler();
    protected static final String COOKIEKEY = "loginErrorTimes";
    private String template = TemplateUtil.loadTemplate("/bos-monitor/login/login.html");

    private String xssClean(String value) {
        if (value != null) {
            return value.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "&quot;").replaceAll("'", "&ocirc;");
        }
        return value;
    }

    @Override
    public void handle(HttpExchange exchange) throws IOException {
        Map<String, String> params = ExchangeUtils.parseParameters(exchange);
        String MONITORVERSION = System.getProperty("monitor.version", "new");
        String homeUrl = UrlUtils.getHomeUrl(exchange, "") + "eye/";
        if (!"old".equals(MONITORVERSION)) {
            ExchangeUtils.redirect(exchange, homeUrl);
            return;
        }
        String disable = System.getProperty("monitor.classic.disable", "false");
        if (Boolean.parseBoolean(disable)) {
            ClassicTo404.redirectTo404(exchange);
            return;
        }
        String loginId = params.get("loginId");
        String user = params.get("user");
        user = this.xssClean(user);
        String password = params.get("password");
        password = this.xssClean(password);
        if (this.isFromEye(exchange) && StringUtils.isEmpty((String)loginId)) {
            Map<String, String> eyeAuth = this.getEyeAuth(LoginHandler.getToken(exchange));
            user = eyeAuth.get("user");
            password = eyeAuth.get("password");
            loginId = "loginId";
        }
        if (StringUtils.isEmpty((String)loginId)) {
            this.renderHtml(exchange, "", user);
        } else if (StringUtils.isEmpty((String)user)) {
            this.renderHtml(exchange, Resources.getString((String)"\u7528\u6237\u540d\u4e3a\u7a7a", (String)"LoginHandler_0", (String)"bos-monitor", (Object[])new Object[0]), user);
        } else if (StringUtils.isEmpty((String)password)) {
            this.renderHtml(exchange, Resources.getString((String)"\u5bc6\u7801\u4e3a\u7a7a", (String)"LoginHandler_1", (String)"bos-monitor", (Object[])new Object[0]), user);
        } else {
            try {
                String decrypt = Encrypt.decrypt(password);
                if (Auther.checkUser(user, decrypt)) {
                    this.writeSession(exchange, user, decrypt);
                    this.redirect(exchange);
                } else {
                    this.setLoginErrorTimesCookie(exchange);
                    this.renderHtml(exchange, Resources.getString((String)"\u7528\u6237\u4e0d\u5b58\u5728\u6216\u8005\u5bc6\u7801\u9519\u8bef", (String)"LoginHandler_3", (String)"bos-monitor", (Object[])new Object[0]), user);
                }
            }
            catch (Exception e) {
                this.renderHtml(exchange, "password decode error:" + e.getMessage(), user);
            }
        }
    }

    private static boolean checkToken(HttpExchange exchange) {
        String token = LoginHandler.getToken(exchange);
        if (token == null) {
            return false;
        }
        return SessionStore.get().exists(token);
    }

    private Map<String, String> getEyeAuth(String token) {
        return SessionStore.get().get(token);
    }

    private static String getToken(HttpExchange exchange) {
        String authToken = exchange.getRequestHeaders().getFirst("Auth_Token");
        if (StringUtils.isEmpty((String)authToken)) {
            String[] cookiearry;
            String cookies = exchange.getRequestHeaders().getFirst("Cookie");
            if (StringUtils.isEmpty((String)cookies)) {
                return null;
            }
            for (String cookie : cookiearry = cookies.split(";")) {
                if (!(cookie = cookie.replaceAll(" ", "")).startsWith("Auth_Token=")) continue;
                authToken = cookie.replace("Auth_Token=", "").replace(";", "");
            }
        }
        return authToken;
    }

    private boolean isFromEye(HttpExchange exchange) {
        return LoginHandler.checkToken(exchange);
    }

    private int getLoginErrorTimes(HttpExchange exchange) {
        String cookies = exchange.getRequestHeaders().getFirst("Cookie");
        int num = 0;
        if (cookies != null) {
            String[] cookiePairs;
            for (String pair : cookiePairs = cookies.split(";")) {
                if (pair.indexOf(COOKIEKEY) == -1) continue;
                String[] KV = pair.split("=");
                num = Integer.parseInt(KV[1]);
            }
        }
        return num;
    }

    private void setLoginErrorTimesCookie(HttpExchange exchange) {
        int loginErrorTimes = this.getLoginErrorTimes(exchange);
        int num = loginErrorTimes + 1;
        exchange.getResponseHeaders().add("Set-Cookie", "loginErrorTimes=" + num);
    }

    private void writeSession(HttpExchange exchange, String user, String password) {
        Auther.newSession(exchange, user, password);
    }

    private void redirect(HttpExchange exchange) throws IOException {
        ExchangeUtils.redirect(exchange, UrlUtils.getHomeUrl(exchange, null));
    }

    private void renderHtml(HttpExchange exchange, String message, String user) throws IOException {
        String html = this.template.replace("{message}", message);
        html = html.replace("{user}", user == null ? "" : user);
        this.writeHtml(html, exchange);
    }

    protected void writeHtml(String str, HttpExchange exchange) throws IOException {
        byte[] bytes = str.getBytes("UTF-8");
        exchange.getResponseHeaders().set("Content-Type", "text/html; charset=UTF-8");
        exchange.sendResponseHeaders(202, bytes.length);
        exchange.getResponseBody().write(bytes);
        exchange.close();
    }
}

