/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.auth;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import kd.bos.monitor.metric.MetricHandler;

public class LoginResourceHandler
implements HttpHandler {
    private final String path;
    private String context;

    public LoginResourceHandler(String path, String context) {
        this.path = path;
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readBytes(InputStream str) throws IOException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            int thisLine;
            while ((thisLine = str.read()) != -1) {
                bos.write(thisLine);
            }
            bos.flush();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpExchange pExchange) throws IOException {
        URI uri = pExchange.getRequestURI();
        OutputStream os = null;
        InputStream in = null;
        try {
            String reqPath = uri.getPath();
            int pos = reqPath.indexOf(this.context);
            reqPath = reqPath.substring(pos + this.context.length());
            if (!reqPath.startsWith("/")) {
                reqPath = "/" + reqPath;
            }
            if ("/".equals(reqPath)) {
                reqPath = "/login.html";
            }
            if ((in = MetricHandler.class.getResourceAsStream(this.path + reqPath)) == null) {
                pExchange.sendResponseHeaders(404, 0L);
                pExchange.close();
                return;
            }
            if (reqPath.endsWith(".jsx")) {
                pExchange.getResponseHeaders().set("Content-Type", "text/javascript; charset=UTF-8");
            } else if (reqPath.endsWith(".css")) {
                pExchange.getResponseHeaders().set("Content-Type", "text/css; charset=UTF-8");
            } else if (reqPath.endsWith(".html")) {
                pExchange.getResponseHeaders().set("Content-Type", "text/html; charset=UTF-8");
            }
            byte[] response = this.readBytes(in);
            pExchange.sendResponseHeaders(202, response.length);
            os = pExchange.getResponseBody();
            os.write(response);
        }
        finally {
            if (os != null) {
                os.close();
            }
            if (in != null) {
                in.close();
            }
            pExchange.close();
        }
    }
}

