/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.auth;

import java.util.Map;
import kd.bos.monitor.auth.SessionStore;

public class MixSessionStore
extends SessionStore {
    private SessionStore local;
    private SessionStore cache;

    public MixSessionStore(SessionStore local, SessionStore cache) {
        this.local = local;
        this.cache = cache;
    }

    @Override
    public void store(String sessionId, Map<String, String> sessionInfo) {
        this.local.store(sessionId, sessionInfo);
        this.cache.store(sessionId, sessionInfo);
    }

    @Override
    public boolean exists(String sessionId) {
        if (this.local.exists(sessionId)) {
            return true;
        }
        if (this.cache.exists(sessionId)) {
            this.local.store(sessionId, this.cache.get(sessionId));
            return true;
        }
        return false;
    }

    @Override
    public Map<String, String> get(String sessionId) {
        Map<String, String> map = this.local.get(sessionId);
        if (map == null) {
            map = this.cache.get(sessionId);
            this.local.store(sessionId, map);
        }
        return map;
    }

    @Override
    public void remove(String sessionId) {
        this.local.remove(sessionId);
        this.cache.remove(sessionId);
    }
}

