/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.dlock;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.context.RequestContext;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.dlock.AbstractDLock;
import kd.bos.dlock.DLock;
import kd.bos.dlock.DLockInfo;
import kd.bos.monitor.httpserver.InnerHandler;
import kd.bos.monitor.util.UrlUtils;

public class DLockHandler
extends InnerHandler {
    private static final String MAGIC = "<a href='";
    private AtomicInteger seq = new AtomicInteger();

    public DLockHandler(String context) {
        super(context);
    }

    private String encode(String v) {
        try {
            return Base64.getEncoder().encodeToString(v.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            return v;
        }
    }

    private String decode(String v) {
        try {
            return new String(Base64.getDecoder().decode(v), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return v;
        }
    }

    @Override
    protected void handle0(HttpExchange exchange) throws IOException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Map<String, String> params = this.getParams(exchange, false);
        String linkActionAccountId = this.getParam(params, "accountId", "");
        String unlockPath = this.decode(this.getParam(params, "unlock", ""));
        String clearlockPath = this.decode(this.getParam(params, "clearlock", ""));
        StringBuilder html = new StringBuilder(2048);
        html.append("<head><meta charset='utf-8'/><title>DLock</title></hread>");
        html.append("<h1>DLock</h1>");
        html.append("No.").append(this.seq.incrementAndGet());
        html.append("&nbsp;&nbsp;").append(sdf.format(new Date()));
        String proxyUrl = this.getParam(params, "proxyurl", "");
        String baseUrl = this.getInnerHandlerUrl();
        String refreshURL = UrlUtils.encodeProxy(baseUrl, proxyUrl);
        html.append("<br/>url=").append(baseUrl);
        html.append("&nbsp;&nbsp;<a href='").append(refreshURL).append("'>refresh</a>");
        html.append("<br/>");
        if (unlockPath.length() > 0) {
            html.append("unlock=").append(unlockPath).append("<br/>");
        }
        if (clearlockPath.length() > 0) {
            html.append("clearlock=").append(clearlockPath).append("<br/>");
        }
        html.append("<pre>");
        html.append(this.dlock(baseUrl, proxyUrl, unlockPath, clearlockPath, linkActionAccountId));
        html.append("</pre>");
        html.append("</form>");
        this.writeHtml(html.toString(), exchange);
    }

    private String dlock(String baseUrl, String proxyUrl, String unlockPath, String clearlockPath, String linkActionAccountId) {
        String[] accountIds;
        StringBuilder sb = new StringBuilder();
        String dlockType = System.getProperty("DLock.type", "zookeeper");
        sb.append("DLock.type=").append(dlockType);
        if (!"redis".equals(dlockType)) {
            sb.append("<br/>");
            sb.append("DLock.performance=").append(System.getProperty("DLock.performance", "false"));
        }
        sb.append("<br/><br/>");
        DLock dlock = DLock.create((String)"none");
        for (String accountId : accountIds = ((AbstractDLock)dlock).getLockAccountIds()) {
            RequestContext.create().setAccountId(accountId);
            TreeMap<String, DLockInfo> map = new TreeMap<String, DLockInfo>(DLock.getAllLockInfo());
            if (map.isEmpty()) continue;
            try {
                Account account = AccountUtils.getAccountById((String)accountId);
                sb.append("tenantId=").append(account.getTenantId()).append(", accountName=").append(account.getAccountName()).append(", accountNumber=").append(account.getAccountNumber()).append(", accountId=").append(accountId).append(", count=").append(map.size()).append("<br/><br/>");
            }
            catch (Exception e) {
                continue;
            }
            this.append(sb, map, linkActionAccountId, accountId, baseUrl, proxyUrl, unlockPath, clearlockPath);
            sb.append("<br/><br/>");
        }
        return sb.toString();
    }

    private void append(StringBuilder sb, Map<String, DLockInfo> map, String linkActionAccountId, String accountId, String baseUrl, String proxyUrl, String unlockPath, String clearlockPath) {
        int i = 0;
        for (Map.Entry<String, DLockInfo> entry : map.entrySet()) {
            String path = entry.getKey();
            DLockInfo di = entry.getValue();
            sb.append(++i);
            sb.append("&nbsp;&nbsp;");
            sb.append(di);
            sb.append("&nbsp;&nbsp;");
            if (linkActionAccountId.equals(accountId) && path.equals(unlockPath)) {
                DLock.forceUnlock((String[])new String[]{path});
                sb.append("<font color='red'>unlocked</font>");
                if (DLock.getLockInfo((String)path) != null) {
                    sb.append("&nbsp;");
                    sb.append(this.createClearLockTag(baseUrl, proxyUrl, path, accountId));
                }
            } else if (linkActionAccountId.equals(accountId) && path.equals(clearlockPath)) {
                DLock.forceClear((String[])new String[]{path});
                sb.append("<font color='red'>cleared</font>");
            } else {
                sb.append(this.createUnLockTag(baseUrl, proxyUrl, path, accountId));
                sb.append("&nbsp;");
                sb.append(this.createClearLockTag(baseUrl, proxyUrl, path, accountId));
            }
            sb.append("<br/>");
        }
    }

    private String createUnLockTag(String baseUrl, String proxyUrl, String path, String accountId) {
        String url = this.buildURL(baseUrl + "?unlock=" + this.encode(path) + "&accountId=" + accountId, proxyUrl);
        return MAGIC + url + "'>unlock</a>";
    }

    private String createClearLockTag(String baseUrl, String proxyUrl, String path, String accountId) {
        String url = this.buildURL(baseUrl + "?clearlock=" + this.encode(path) + "&accountId=" + accountId, proxyUrl);
        return MAGIC + url + "'>clearlock</a>";
    }

    private String buildURL(String baseUrl, String proxyUrl) {
        return UrlUtils.encodeProxy(baseUrl, proxyUrl);
    }

    private String getParam(Map<String, String> params, String key, String def) {
        String value = params.get(key);
        if (value == null) {
            return def;
        }
        return value;
    }
}

