/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.home;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kd.bos.context.OperationContextCreator;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.monitor.auth.Auther;
import kd.bos.monitor.home.ActionEnum;
import kd.bos.monitor.home.NodeInfo;
import kd.bos.monitor.httpserver.AbstractHttpHandler;
import kd.bos.monitor.service.MonitorServerService;
import kd.bos.monitor.util.ClassicTo404;
import kd.bos.monitor.util.TemplateUtil;
import kd.bos.monitor.util.UrlUtils;
import kd.bos.util.resource.Resources;

public class ClassicHomeHandler
extends AbstractHttpHandler {
    private static final Log logger = LogFactory.getLog(ClassicHomeHandler.class);
    private static String TRACELOGFORMTEMPLATE = TemplateUtil.loadTemplate("/bos-monitor/log/tracelogform.template");
    private static String TRACEZIPKINFORMTEMPLATE = TemplateUtil.loadTemplate("/bos-monitor/log/tracezipkinform.template");
    private static final String TARGET_BLANK = "' target='_blank'>";
    private static final String SPAN_HREF = "|<span><a href='";
    private static final String A_SPAN = "</a></span> ";
    private static final String MAGIC = ")&baseurl=";
    private static final String UTF8 = "UTF-8";
    private static final String TD_SUF = "</td>";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle0(HttpExchange exchange) throws IOException {
        boolean disable = ClassicTo404.redirectTo404(exchange);
        if (disable) {
            return;
        }
        String urlHost = UrlUtils.getHomeUrl(exchange, null);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        OperationContextCreator.getOrCreateForBos();
        try {
            ArrayList<NodeInfo> serverNodes = this.getSortedNodeInfos();
            String clusterName = Instance.getClusterName();
            if (clusterName != null) {
                pw.println("<html><head><meta http-equiv='Content-Type' content='text/html; charset=UTF-8' /><meta http-equiv='pragma' content='no-cache'><meta http-equiv='cache-control' content='no-cache'><meta http-equiv='expires' content='0'><meta http-equiv='X-UA-Compatible' content='IE=EmulateIE9'/><title>" + Resources.getString((String)"\u96c6\u7fa4\u76d1\u63a7", (String)"HomeHandler_0", (String)"bos-monitor", (Object[])new Object[0]) + "</title></head></html>");
                pw.println("<font face=\"Helvetica Neue\"><center><h1>" + Resources.getString((String)"\u96c6\u7fa4\u76d1\u63a7", (String)"HomeHandler_1", (String)"bos-monitor", (Object[])new Object[0]) + "(" + clusterName + ")</h1></center>");
                pw.println("<div>");
                pw.println("<a href='" + this.createLogQueryUrl(clusterName, urlHost) + TARGET_BLANK + Resources.getString((String)"\u65e5\u5fd7\u67e5\u8be2(\u96c6\u7fa4\u8303\u56f4)", (String)"HomeHandler_2", (String)"bos-monitor", (Object[])new Object[0]) + "</a>");
                pw.println("<span>|</span> <a href='newthreaddump' target='_blank'>" + Resources.getString((String)"\u5806\u6808\u67e5\u8be2(\u96c6\u7fa4\u8303\u56f4)", (String)"HomeHandler_15", (String)"bos-monitor", (Object[])new Object[0]) + "</a>");
                pw.println("<span>|</span> <a href='clusternodehealth' target='_blank'>" + Resources.getString((String)"\u5065\u5eb7\u72b6\u51b5(\u96c6\u7fa4)", (String)"HomeHandler_16", (String)"bos-monitor", (Object[])new Object[0]) + "</a>");
                pw.println("<span>|</span> <a href='servicecatalog' target='_blank'>" + Resources.getString((String)"\u670d\u52a1\u76ee\u5f55", (String)"HomeHandler_17", (String)"bos-monitor", (Object[])new Object[0]) + "</a>");
                String zipkinUrl = System.getProperty("monitor.zipkin.url");
                if (zipkinUrl != null) {
                    if (!zipkinUrl.endsWith("/")) {
                        zipkinUrl = zipkinUrl + "/";
                    }
                    pw.println("<span>|</span> <a href='tc/' target='_blank'>" + Resources.getString((String)"\u67e5\u770b\u8c03\u7528\u94fe", (String)"HomeHandler_3", (String)"bos-monitor", (Object[])new Object[0]) + "</a>");
                }
                pw.println("<span>|</span> <a href='rabbit' target='_blank'>" + Resources.getString((String)"MQ\u76d1\u63a7", (String)"HomeHandler_4", (String)"bos-monitor", (Object[])new Object[0]) + "</a>");
                pw.println("<span>|</span> <a href='redis' target='_blank'>" + Resources.getString((String)"redis\u76d1\u63a7", (String)"HomeHandler_5", (String)"bos-monitor", (Object[])new Object[0]) + "</a>");
                pw.println("</div>");
                pw.println("<br/>");
                TreeMap map = new TreeMap();
                for (NodeInfo nodeInfo : serverNodes) {
                    String appName = nodeInfo.getAppName();
                    if (appName == null) continue;
                    ArrayList<NodeInfo> list = (ArrayList<NodeInfo>)map.get(appName);
                    if (list == null) {
                        list = new ArrayList<NodeInfo>();
                        map.put(appName, list);
                    }
                    list.add(nodeInfo);
                }
                for (Map.Entry entry : map.entrySet()) {
                    this.renderAppName(pw, clusterName, (String)entry.getKey(), (List)entry.getValue(), urlHost, Auther.isGuestUser(exchange));
                }
                this.renderTraceLogForm(pw);
                String string = exchange.getRequestURI().getPath();
                this.renderTraceZipkinForm(pw, string);
                pw.println("</font>");
            } else {
                pw.println("<font face=\"Helvetica Neue\"><title>" + Resources.getString((String)"\u96c6\u7fa4\u76d1\u63a7", (String)"HomeHandler_0", (String)"bos-monitor", (Object[])new Object[0]) + "</title>");
                pw.println("<center><h1>" + Resources.getString((String)"\u96c6\u7fa4\u76d1\u63a7", (String)"HomeHandler_6", (String)"bos-monitor", (Object[])new Object[0]) + "</h1></center>");
                pw.println("<br/>");
                TreeMap<String, ArrayList<NodeInfo>> map = new TreeMap<String, ArrayList<NodeInfo>>();
                for (NodeInfo nodeInfo : serverNodes) {
                    String string = nodeInfo.getAppName();
                    if (string == null) continue;
                    ArrayList<NodeInfo> list = (ArrayList<NodeInfo>)map.get(string);
                    if (list == null) {
                        list = new ArrayList<NodeInfo>();
                        map.put(string, list);
                    }
                    list.add(nodeInfo);
                }
                for (Map.Entry entry : map.entrySet()) {
                    this.renderAppName(pw, clusterName, (String)entry.getKey(), (List)entry.getValue(), urlHost, Auther.isGuestUser(exchange));
                }
                pw.println("</font>");
            }
            String str = sw.toString();
            byte[] bytes = str.getBytes(UTF8);
            exchange.getResponseHeaders().set("Content-Type", "text/html; charset=UTF-8");
            exchange.sendResponseHeaders(202, bytes.length);
            exchange.getResponseBody().write(bytes);
            exchange.close();
        }
        catch (Exception t) {
            logger.error("classic home exception", (Throwable)t);
        }
        finally {
            if (pw != null) {
                pw.flush();
                pw.close();
            }
        }
    }

    private void renderTraceZipkinForm(PrintWriter pw, String contextPath) {
        String url = contextPath;
        if (url != null) {
            if (url.endsWith("/")) {
                url = url.substring(0, url.length() - 1);
            }
            pw.println(TRACEZIPKINFORMTEMPLATE.replace("{zipkinUrl}", url));
        } else {
            String message = "<div>" + Resources.getString((String)"\u8bf7\u914d\u7f6e", (String)"HomeHandler_7", (String)"bos-monitor", (Object[])new Object[0]) + "monitor.zipkin.url" + Resources.getString((String)"\u4ee5\u67e5\u770b\u8c03\u7528\u94fe</div>", (String)"HomeHandler_8", (String)"bos-monitor", (Object[])new Object[0]);
            pw.println(message);
        }
    }

    private void renderTraceLogForm(PrintWriter pw) {
        pw.println(TRACELOGFORMTEMPLATE);
    }

    private String createDetailHtml(NodeInfo nodeInfo) {
        StringBuilder sb = new StringBuilder();
        sb.append("startAt:").append(nodeInfo.getStartTime());
        sb.append(",hostIp:").append(nodeInfo.getHostIp());
        if (nodeInfo.getWebPort() != null) {
            sb.append(",web port:").append(nodeInfo.getWebPort());
        }
        if (nodeInfo.getMservicePort() != null) {
            sb.append(",service port:").append(nodeInfo.getMservicePort());
            sb.append(",registerDubboZk:").append(nodeInfo.isDubboRegister());
            sb.append(",registerMQConsumer:").append(nodeInfo.isMqConsumerRegister());
        }
        return sb.toString();
    }

    private String createMetricUrl(NodeInfo nodeInfo, String urlHost) {
        String url = "/monitor0/metric?title=" + Resources.getString((String)"\u6307\u6807\u76d1\u63a7", (String)"HomeHandler_9", (String)"bos-monitor", (Object[])new Object[0]) + "(" + nodeInfo.getIp() + "/" + nodeInfo.getInstanceId() + MAGIC + nodeInfo.getMonitorUrl(false);
        return this.createProxyUrl(nodeInfo, url, urlHost);
    }

    private String createAlgoXUrl(NodeInfo nodeInfo, String urlHost) {
        try {
            String flinkServer = URLEncoder.encode(urlHost + "proxy2/abc/" + nodeInfo.getHostIp() + ":" + nodeInfo.getHostMonitorPort() + "/monitor0/algoxfp/", UTF8);
            return urlHost + "algox/index?server=" + flinkServer;
        }
        catch (UnsupportedEncodingException e) {
            logger.error("UnsupportedEncodingException", (Throwable)e);
            return "";
        }
    }

    private String createPoolUrl(NodeInfo nodeInfo, String urlHost) {
        String url = "/monitor0/metric-pool?title=" + Resources.getString((String)"\u8fde\u63a5\u6c60\u76d1\u63a7", (String)"HomeHandler_10", (String)"bos-monitor", (Object[])new Object[0]) + "(" + nodeInfo.getIp() + "/" + nodeInfo.getInstanceId() + MAGIC + nodeInfo.getMonitorUrl(false);
        return this.createProxyUrl(nodeInfo, url, urlHost);
    }

    private String createElkUrl(NodeInfo nodeInfo, String urlHost) {
        String url = "/monitor0/metric-elk?title=" + Resources.getString((String)"elk\u6570\u636e\u76d1\u63a7", (String)"HomeHandler_11", (String)"bos-monitor", (Object[])new Object[0]) + "(" + nodeInfo.getIp() + "/" + nodeInfo.getInstanceId() + MAGIC + nodeInfo.getMonitorUrl(false);
        return this.createProxyUrl(nodeInfo, url, urlHost);
    }

    private String createDataSourceUrl(NodeInfo nodeInfo, String urlHost) {
        String url = "/monitor0/datasource";
        return this.createProxyUrl(nodeInfo, url, urlHost);
    }

    private String createThreadCpuThreadUrl(NodeInfo nodeInfo, String urlHost) {
        String url = "/monitor0/top?title=" + Resources.getString((String)"cpu\u91c7\u96c6", (String)"HomeHandler_12", (String)"bos-monitor", (Object[])new Object[0]) + "(" + nodeInfo.getIp() + "/" + nodeInfo.getInstanceId() + ")";
        return this.createProxyUrl(nodeInfo, url, urlHost);
    }

    private String createMeminfoUrl(NodeInfo nodeInfo, String urlHost) {
        String url = "/monitor0/meminfo?title=" + Resources.getString((String)"\u5185\u5b58\u5bf9\u8c61\u4fe1\u606f", (String)"HomeHandler_13", (String)"bos-monitor", (Object[])new Object[0]) + "(" + nodeInfo.getIp() + "/" + nodeInfo.getInstanceId() + MAGIC + nodeInfo.getMonitorUrl(false) + "&live=0";
        return this.createProxyUrl(nodeInfo, url, urlHost);
    }

    private String createSpeedTestUrl(NodeInfo nodeInfo, String urlHost) {
        String url = "/monitor0/speedtest";
        return this.createProxyUrl(nodeInfo, url, urlHost);
    }

    private String createLBMonitor(NodeInfo nodeInfo, String urlHost) {
        String url = "/monitor0/nodehealthcharts?title=" + Resources.getString((String)"\u5065\u5eb7\u8d1f\u8f7d\u76d1\u63a7", (String)"HomeHandler_20", (String)"bos-monitor", (Object[])new Object[0]) + "(" + nodeInfo.getIp() + "/" + nodeInfo.getInstanceId() + MAGIC + nodeInfo.getMonitorUrl(false);
        return this.createProxyUrl(nodeInfo, url, urlHost);
    }

    private String createDLockUrl(NodeInfo nodeInfo, String urlHost) {
        String url = "/monitor0/dlock";
        return this.createProxyUrl(nodeInfo, url, urlHost);
    }

    private String createThreaddumpUrl(NodeInfo nodeInfo, String urlHost) {
        String url = "/monitor0/threaddump";
        return this.createProxyUrl(nodeInfo, url, urlHost);
    }

    private String createServiceUrl(NodeInfo nodeInfo, String urlHost, String sName) {
        String url = "/monitor0/service/" + sName;
        return this.createProxyUrl(nodeInfo, url, urlHost);
    }

    private String createSystemPropertiesUrl(NodeInfo nodeInfo, String urlHost) {
        String url = "/monitor0/systemproperties";
        return this.createProxyUrl(nodeInfo, url, urlHost);
    }

    private String createLogQueryUrl(String clusterName, String urlHost) {
        return this.createLogQueryUrl(clusterName, null, urlHost);
    }

    private String createLogQueryUrl(String clusterName, String appName, String urlHost) {
        return this.createLogQueryUrl(clusterName, appName, null, urlHost);
    }

    private String createLogQueryUrl(String clusterName, String appName, NodeInfo nodeInfo, String urlHost) {
        String url = "logquery?clusterName=" + clusterName;
        if (appName != null) {
            url = url + "&appName=" + appName;
        }
        if (nodeInfo != null) {
            url = url + "&instanceId=" + nodeInfo.getInstanceId();
        }
        return url;
    }

    private String createProxyUrl(NodeInfo nodeInfo, String url, String urlHost) {
        StringBuilder sb = new StringBuilder("proxy?");
        try {
            String proxyurl = URLEncoder.encode(nodeInfo.getMonitorUrl(false) + url, UTF8);
            sb.append("url=").append(proxyurl);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("UnsupportedEncodingException", (Throwable)e);
        }
        return sb.toString();
    }

    private String createActionHtml(String clusterName, String appName, NodeInfo nodeInfo, String urlHost, boolean isGuest) {
        StringBuilder sb = new StringBuilder("<div>");
        Set<ActionEnum> guestExcludeActions = this.guestExcludeActions();
        if (!isGuest || !guestExcludeActions.contains((Object)ActionEnum.THREADSTACK)) {
            sb.append("<span><a href='").append(this.createThreaddumpUrl(nodeInfo, urlHost)).append(TARGET_BLANK).append(ActionEnum.THREADSTACK.getName()).append("</a></span>");
        }
        if (!isGuest || !guestExcludeActions.contains((Object)ActionEnum.SYSTEMATTRIBUTES)) {
            sb.append(SPAN_HREF).append(this.createSystemPropertiesUrl(nodeInfo, urlHost)).append(TARGET_BLANK).append(ActionEnum.SYSTEMATTRIBUTES.getName()).append("</a></span>");
        }
        if (!(clusterName == null || isGuest && guestExcludeActions.contains((Object)ActionEnum.NODELOGQUERY))) {
            sb.append(SPAN_HREF).append(this.createLogQueryUrl(clusterName, appName, nodeInfo, urlHost)).append(TARGET_BLANK).append(ActionEnum.NODELOGQUERY.getName()).append(A_SPAN);
        }
        if (!isGuest || !guestExcludeActions.contains((Object)ActionEnum.REALTIMEMONITOR)) {
            sb.append(SPAN_HREF).append(this.createMetricUrl(nodeInfo, urlHost)).append(TARGET_BLANK).append(ActionEnum.REALTIMEMONITOR.getName()).append(A_SPAN);
        }
        if (!isGuest || !guestExcludeActions.contains((Object)ActionEnum.ALGOX)) {
            sb.append(SPAN_HREF).append(this.createAlgoXUrl(nodeInfo, urlHost)).append(TARGET_BLANK).append(ActionEnum.ALGOX.getName()).append(A_SPAN);
        }
        if (!isGuest || !guestExcludeActions.contains((Object)ActionEnum.CONNECTIONPOOLMONITOR)) {
            sb.append(SPAN_HREF).append(this.createPoolUrl(nodeInfo, urlHost)).append(TARGET_BLANK).append(ActionEnum.CONNECTIONPOOLMONITOR.getName()).append(A_SPAN);
        }
        if (!isGuest || !guestExcludeActions.contains((Object)ActionEnum.DATASOURCE)) {
            sb.append(SPAN_HREF).append(this.createDataSourceUrl(nodeInfo, urlHost)).append(TARGET_BLANK).append(ActionEnum.DATASOURCE.getName()).append(A_SPAN);
        }
        if (!isGuest || !guestExcludeActions.contains((Object)ActionEnum.DLOCK)) {
            sb.append(SPAN_HREF).append(this.createDLockUrl(nodeInfo, urlHost)).append(TARGET_BLANK).append(ActionEnum.DLOCK.getName()).append(A_SPAN);
        }
        if (!isGuest || !guestExcludeActions.contains((Object)ActionEnum.MEMORYOBJECT)) {
            sb.append(SPAN_HREF).append(this.createMeminfoUrl(nodeInfo, urlHost)).append(TARGET_BLANK).append(ActionEnum.MEMORYOBJECT.getName()).append(A_SPAN);
        }
        if (!isGuest || !guestExcludeActions.contains((Object)ActionEnum.TESTSPEED)) {
            sb.append(SPAN_HREF).append(this.createSpeedTestUrl(nodeInfo, urlHost)).append(TARGET_BLANK).append(ActionEnum.TESTSPEED.getName()).append(A_SPAN);
        }
        if (!isGuest || !guestExcludeActions.contains((Object)ActionEnum.SERVICESTATUS)) {
            sb.append(SPAN_HREF).append(this.createServiceUrl(nodeInfo, urlHost, "servicestatus")).append(TARGET_BLANK).append(ActionEnum.SERVICESTATUS.getName()).append(A_SPAN);
        }
        if (!isGuest || !guestExcludeActions.contains((Object)ActionEnum.STOPSERVICE)) {
            sb.append(SPAN_HREF).append(this.createServiceUrl(nodeInfo, urlHost, "pauseservice")).append(TARGET_BLANK).append(ActionEnum.STOPSERVICE.getName()).append(A_SPAN);
        }
        if (!isGuest || !guestExcludeActions.contains((Object)ActionEnum.RECOVERYSERVICE)) {
            sb.append(SPAN_HREF).append(this.createServiceUrl(nodeInfo, urlHost, "resumeservice")).append(TARGET_BLANK).append(ActionEnum.RECOVERYSERVICE.getName()).append(A_SPAN);
        }
        if (!isGuest || !guestExcludeActions.contains((Object)ActionEnum.LOADBLANCE)) {
            sb.append(SPAN_HREF).append(this.createLBMonitor(nodeInfo, urlHost)).append(TARGET_BLANK).append(ActionEnum.LOADBLANCE.getName()).append(A_SPAN);
        }
        sb.append("</div>");
        return sb.toString();
    }

    private void renderAppName(PrintWriter pw, String clusterName, String appName, List<NodeInfo> list, String urlHost, boolean isGuest) {
        pw.println("<div class='AppList' style='border:1;'>");
        pw.println("<div><h2 style='display : inline;'>appName:" + appName + " </h2>&nbsp;&nbsp;&nbsp;" + (clusterName != null ? "<a href='" + this.createLogQueryUrl(clusterName, appName, urlHost) + TARGET_BLANK + Resources.getString((String)"\u5e94\u7528\u65e5\u5fd7\u67e5\u8be2", (String)"HomeHandler_14", (String)"bos-monitor", (Object[])new Object[0]) + "(" + appName + ")</a>" : "") + "</div>");
        pw.println("<table border=1>");
        pw.println("<tr><td align=middle style='width:20%'>Instance Id</td><td>IP</td><td align=middle>Detail</td><td align=middle style='width:40%'>Actions</td></tr>");
        for (NodeInfo nodeInfo : list) {
            pw.print("<tr>");
            pw.println("<td valign=top >" + nodeInfo.getInstanceId() + TD_SUF + "<td valign=top>" + nodeInfo.getIp() + TD_SUF + "<td valign=top>" + this.createDetailHtml(nodeInfo) + TD_SUF + "<td valign=top >" + this.createActionHtml(clusterName, appName, nodeInfo, urlHost, isGuest) + TD_SUF);
            pw.print("</tr>");
        }
        pw.println("</table>");
        pw.println("</div><br/>");
    }

    private ArrayList<NodeInfo> getSortedNodeInfos() {
        ArrayList<NodeInfo> list = MonitorServerService.getAllNodes();
        Collections.sort(list, (o1, o2) -> Long.compare(o1.getStartTimestamp(), o2.getStartTimestamp()));
        return list;
    }

    private Set<ActionEnum> guestExcludeActions() {
        HashSet<ActionEnum> set = new HashSet<ActionEnum>();
        String excludeActionStr = System.getProperty("monitor.guest.exclude.action");
        if (excludeActionStr == null || excludeActionStr.length() <= 0) {
            excludeActionStr = "dataSource,serviceStatus,stopService,recoveryService";
        }
        for (String str : excludeActionStr.split(",")) {
            ActionEnum actionEnum = ActionEnum.valueOfNumber(str.trim());
            if (actionEnum == null) continue;
            set.add(actionEnum);
        }
        return set;
    }
}

