/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.httpserver;

import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.monitor.httpserver.HandlerProvider;
import kd.bos.util.NetAddressUtils;

public class MonitorHttpServer {
    private static MonitorHttpServer instance = null;
    public static final String THREAD_NAME = "monitor-http";
    private HttpServer server;
    private Executor executor;
    private AtomicLong id = new AtomicLong();

    public MonitorHttpServer(int port) throws IOException {
        this.server = HttpServer.create(new InetSocketAddress(NetAddressUtils.getBindedHostIP(), port), 0);
        this.executor = Executors.newFixedThreadPool(4, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                return new Thread(runnable, "monitor-http-" + MonitorHttpServer.this.id.incrementAndGet());
            }
        });
        instance = this;
    }

    public void addHandler(String context, HttpHandler handler) {
        this.server.createContext(context, handler);
    }

    public void addHandler(String context, HandlerProvider provider) {
        this.server.createContext(context, provider.get());
    }

    public void start() throws IOException {
        this.server.setExecutor(this.executor);
        this.server.start();
    }

    public static MonitorHttpServer getInstance() {
        return instance;
    }

    public void stop() {
        this.server.stop(0);
    }
}

