/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.log;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import kd.bos.monitor.util.TemplateUtil;
import kd.bos.util.StringUtils;

public class ESQueryBuilder {
    private static final String TEMPLATE = ESQueryBuilder.loadTemplate();

    static String loadTemplate() {
        return TemplateUtil.loadTemplate("/bos-monitor/log/esqueryjson.template");
    }

    public static String build(String[] keywords, String[] keywordFields, Map<String, String> filters, Date startTime, Date endTime, int size, int from) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyy-MM-dd'T'HH:mm:ssZ");
        String keywordJson = ESQueryBuilder.createKeywordJson(keywords, keywordFields);
        String result = TEMPLATE.replace("{{messages}}", keywordJson);
        String startTimeStr = sdf.format(startTime);
        String endTimeStr = sdf.format(endTime);
        result = result.replace("{{startTime}}", startTimeStr);
        result = result.replace("{{endTime}}", endTimeStr);
        StringBuilder sb = new StringBuilder();
        ESQueryBuilder.createFilterJson(filters, sb);
        result = result.replace("{{filters}}", sb.toString());
        result = result.replace("{{size}}", String.valueOf(size));
        result = result.replace("{{from}}", String.valueOf(from));
        return result;
    }

    private static void createFilterJson(Map<String, String> filters, StringBuilder sb) {
        if (filters == null || filters.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> entry : filters.entrySet()) {
            if (StringUtils.isEmpty((String)entry.getValue())) continue;
            sb.append(String.format(",{\"term\":{\"%s\":\"%s\"}}", entry.getKey() + ".keyword", entry.getValue()));
        }
    }

    private static String createKeywordJson(String[] keywords, String[] keywordFields) {
        if (keywords == null || keywords.length == 0 || keywordFields == null || keywordFields.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String keyword : keywords) {
            for (String field : keywordFields) {
                sb.append(String.format("{\"wildcard\": {\"%s\": \"*%s*\"}}", field + ".keyword", keyword)).append(',');
            }
        }
        String toString = sb.toString();
        if (toString.endsWith(",")) {
            toString = toString.substring(0, toString.length() - 1);
        }
        return toString;
    }
}

