/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.objmem;

import com.sun.net.httpserver.HttpExchange;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.URI;
import java.util.Map;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.monitor.httpserver.AbstractHttpHandler;
import kd.bos.monitor.metric.MetricHandler;
import kd.bos.monitor.objmem.CollectResult;
import kd.bos.monitor.objmem.CollectTask;
import kd.bos.monitor.objmem.MemInfoCollector;
import kd.bos.monitor.objmem.Meminfo;
import kd.bos.monitor.objmem.collector.OSMemInfoCollector;
import kd.bos.monitor.util.UriQuery;
import kd.bos.monitor.util.UrlUtils;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.StringUtils;

public class ObjMeminfoHandler
extends AbstractHttpHandler {
    private static final Log logger = LogFactory.getLog(ObjMeminfoHandler.class);
    private final String resourcePath;
    private String context;
    private MemInfoCollector collector;
    private static final String RESULT = "{result}";
    private static final String DATA = "{DATA}";
    private static int PID = -1;
    private static final String CLS_NAME = "clsName";

    public ObjMeminfoHandler(String resourcePath, String context) {
        this.resourcePath = resourcePath;
        this.context = context;
        this.collector = new OSMemInfoCollector();
    }

    public static int getPid() {
        if (PID < 0) {
            try {
                RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
                String name = runtime.getName();
                PID = Integer.parseInt(name.substring(0, name.indexOf(64)));
            }
            catch (Exception e) {
                PID = 0;
            }
        }
        return PID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handle0(HttpExchange exchange) throws IOException {
        URI uri = exchange.getRequestURI();
        OutputStream os = null;
        InputStream in = null;
        try {
            Map<String, String> params = UriQuery.toMap(exchange.getRequestURI().getRawQuery());
            CollectTask task = new CollectTask();
            if ("1".equals(params.get("live"))) {
                task.setLive(true);
            }
            task.setNumber(ConfigurationUtil.getInteger((String)"monitor.collectmem.number", (Integer)1000));
            if (!StringUtils.isEmpty((String)params.get(CLS_NAME))) {
                task.setClsName(params.get(CLS_NAME));
            } else {
                task.setClsName("");
            }
            task.setPid(ObjMeminfoHandler.getPid());
            String reqPath = uri.getPath();
            int pos = reqPath.indexOf(this.context);
            reqPath = reqPath.substring(pos + this.context.length());
            if (!reqPath.startsWith("/")) {
                reqPath = "/" + reqPath;
            }
            if ("/".equals(reqPath)) {
                reqPath = "/index.html";
            }
            if ((in = MetricHandler.class.getResourceAsStream(this.resourcePath + reqPath)) == null) {
                exchange.sendResponseHeaders(404, 0L);
                exchange.close();
                return;
            }
            exchange.getResponseHeaders().set("Content-Type", "text/html; charset=UTF-8");
            byte[] response = this.readBytes(in);
            CollectResult result = this.collector.getMemInfo(task);
            response = this.replaceContent(response, params, task, result);
            exchange.sendResponseHeaders(202, response.length);
            os = exchange.getResponseBody();
            os.write(response);
            exchange.close();
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    private String encodeProxy(String uri, String proxyurl) {
        return "" + UrlUtils.encodeProxy(uri, proxyurl) + "";
    }

    private byte[] replaceContent(byte[] response, Map<String, String> params, CollectTask task, CollectResult result) throws UnsupportedEncodingException {
        String proxyurl = params.get("proxyurl");
        String title = params.get("title");
        String baseurl = params.get("baseurl");
        String text = new String(response, "UTF-8");
        try {
            String url = baseurl + this.context + "?title=" + title + "&baseurl=" + baseurl;
            text = text.replace("${action}", proxyurl);
            text = text.replace("${url}", url);
            text = text.replace("{title}", title);
            text = text.replace("{baseurl}", baseurl);
            text = text.replace("{clsName}", task.getClsName() != null ? task.getClsName() : "");
            text = text.replace("{cluster}", Instance.getClusterName());
            text = text.replace("{notice}", result.getError() != null ? result.getError() : "");
            text = text.replace("{checked}", "1".equals(params.get("live")) ? "checked" : "");
            if (result.getList() != null) {
                StringBuilder builder = new StringBuilder();
                StringBuilder databuilder = new StringBuilder();
                databuilder.append("[");
                int number = task.getNumber();
                int index = 0;
                for (Meminfo info : result.getList()) {
                    if (!StringUtils.isEmpty((String)params.get(CLS_NAME)) && !info.getClsName().contains(params.get(CLS_NAME))) continue;
                    if (index >= number) break;
                    if (databuilder.length() > 1) {
                        databuilder.append(",");
                    }
                    databuilder.append("{");
                    databuilder.append("'").append(CLS_NAME).append("'").append(":").append("'").append(info.getClsName()).append("'");
                    databuilder.append(",");
                    databuilder.append("'").append("instances").append("'").append(":").append("'").append(info.getInstances()).append("'");
                    databuilder.append(",");
                    databuilder.append("'").append("bytes").append("'").append(":").append("'").append(info.getBytes()).append("'");
                    databuilder.append("}");
                    ++index;
                }
                databuilder.append("]");
                text = text.replace(DATA, databuilder.toString());
                builder.append("<table id=\"memtable\">");
                builder.append("<tr>");
                builder.append("<th class='ascorder' style='width:50%' onclick=\"showorder('clsName')\">\u7c7b\u540d<span id='clsName_arrow'></span></th><th style='width:20%' class='ascorder' onclick=\"showorder('instances')\">\u5b9e\u4f8b\u6570\u91cf<span id='instances_arrow'></span></th><th style='width:30%' class='ascorder' onclick=\"showorder('bytes')\">\u5b57\u8282\u6570<span id='bytes_arrow' class='arrow dsc'></span></th>");
                builder.append("</table>");
                text = text.replace(RESULT, builder.toString());
            } else {
                text = text.replace(RESULT, "");
                text = text.replace(DATA, "[]");
            }
        }
        catch (Exception e) {
            logger.error("replace Content exception", (Throwable)e);
        }
        return text.getBytes("UTF-8");
    }

    private String formatHtml(String text, StringBuilder builder, StringBuilder databuilder, Map<String, String> params, CollectTask task, CollectResult result) {
        databuilder.append("[");
        int number = task.getNumber();
        int index = 0;
        for (Meminfo info : result.getList()) {
            if (!StringUtils.isEmpty((String)params.get(CLS_NAME)) && !info.getClsName().contains(params.get(CLS_NAME))) continue;
            if (index >= number) break;
            if (databuilder.length() > 1) {
                databuilder.append(",");
            }
            databuilder.append("{");
            databuilder.append("'").append(CLS_NAME).append("'").append(":").append("'").append(info.getClsName()).append("'");
            databuilder.append(",");
            databuilder.append("'").append("instances").append("'").append(":").append("'").append(info.getInstances()).append("'");
            databuilder.append(",");
            databuilder.append("'").append("bytes").append("'").append(":").append("'").append(info.getBytes()).append("'");
            databuilder.append("}");
            ++index;
        }
        databuilder.append("]");
        text = text.replace(DATA, databuilder.toString());
        builder.append("<table id=\"memtable\">");
        builder.append("<tr>");
        builder.append("<th class='ascorder' style='width:50%' onclick=\"showorder('clsName')\">\u7c7b\u540d<span id='clsName_arrow'></span></th><th style='width:20%' class='ascorder' onclick=\"showorder('instances')\">\u5b9e\u4f8b\u6570\u91cf<span id='instances_arrow'></span></th><th style='width:30%' class='ascorder' onclick=\"showorder('bytes')\">\u5b57\u8282\u6570<span id='bytes_arrow' class='arrow dsc'></span></th>");
        builder.append("</table>");
        return text.replace(RESULT, builder.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readBytes(InputStream str) throws IOException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            int thisLine;
            while ((thisLine = str.read()) != -1) {
                bos.write(thisLine);
            }
            bos.flush();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }
}

