/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.postfunction;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Timer;
import java.util.TimerTask;
import kd.bos.context.OperationContextCreator;
import kd.bos.monitor.postfunction.PostFunc;
import kd.bos.monitor.postfunction.PostFunction;
import kd.bos.monitor.postfunction.es.ESStatsProcessor;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.HttpClientUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PostFunction
public class ESStatsCollectFunc
implements PostFunc {
    private Timer timer = new Timer("ESStats-collector", true);
    private static Logger logger = LoggerFactory.getLogger(ESStatsCollectFunc.class);
    private static ESStatsProcessor parse = null;
    private static int interval = 10;

    @Override
    public void start() {
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                boolean enable = ConfigurationUtil.getBoolean((String)"monitor.collectes.enable", (Boolean)false);
                if (enable) {
                    OperationContextCreator.getOrCreateForBos();
                    String es_url = System.getProperty("monitor.es.url");
                    String stat_url = es_url + "_nodes/stats?pretty";
                    try {
                        String result = HttpClientUtils.get((String)stat_url);
                        JSONObject json = JSON.parseObject((String)result);
                        parse.parse(json);
                    }
                    catch (Exception ex) {
                        logger.error("schedule collect es error,", (Throwable)ex);
                    }
                }
            }
        }, interval * 1000, (long)(interval * 1000));
    }

    static {
        String parseCls = ConfigurationUtil.getString((String)"monitor.collectes.statsparser", (String)"kd.bos.monitor.postfunction.es.ESStatsV5Processor");
        try {
            Class<?> cls = Class.forName(parseCls);
            parse = (ESStatsProcessor)cls.newInstance();
        }
        catch (ClassNotFoundException e) {
            logger.error("class not found", (Throwable)e);
        }
        catch (InstantiationException e) {
            logger.error("static block exception", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error("illegal access exception", (Throwable)e);
        }
    }
}

