/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.postfunction;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import kd.bos.context.OperationContextCreator;
import kd.bos.monitor.objmem.CollectResult;
import kd.bos.monitor.objmem.CollectTask;
import kd.bos.monitor.objmem.Meminfo;
import kd.bos.monitor.objmem.collector.OSMemInfoCollector;
import kd.bos.monitor.postfunction.PostFunc;
import kd.bos.monitor.postfunction.PostFunction;
import kd.bos.util.ConfigurationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PostFunction
public class ScheduleMemCollectFunc
implements PostFunc {
    private static Logger logger = LoggerFactory.getLogger(ScheduleMemCollectFunc.class);
    private static int PID = -1;
    protected static boolean enable = false;
    protected static int interval = 30;
    protected static int triggerPercent = 60;
    protected static int topcount = 20;
    protected static String orderby = "bytes";
    protected static String classpackage = "";
    protected OSMemInfoCollector collector;
    private Timer timer = new Timer("JVMsnapshot-collector", true);

    public static int getPid() {
        if (PID < 0) {
            try {
                RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
                String name = runtime.getName();
                PID = Integer.parseInt(name.substring(0, name.indexOf(64)));
            }
            catch (Exception e) {
                PID = 0;
            }
        }
        return PID;
    }

    public ScheduleMemCollectFunc() {
        this.collector = new OSMemInfoCollector();
    }

    private static void fillProperties() {
        interval = ConfigurationUtil.getInteger((String)"monitor.collectmem.interval", (Integer)30);
        triggerPercent = ConfigurationUtil.getInteger((String)"monitor.collectmem.triggerPercent", (Integer)90);
        topcount = ConfigurationUtil.getInteger((String)"monitor.collectmem.topcount", (Integer)20);
        orderby = ConfigurationUtil.getString((String)"monitor.collectmem.orderby", (String)"bytes");
        classpackage = ConfigurationUtil.getString((String)"monitor.collectmem.classpackage", (String)"");
        enable = ConfigurationUtil.getBoolean((String)"monitor.collectmem.enable", (Boolean)false);
    }

    @Override
    public void start() {
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    OperationContextCreator.getOrCreateForBos();
                    ScheduleMemCollectFunc.fillProperties();
                    if (enable && ScheduleMemCollectFunc.checkTrigger()) {
                        CollectTask task = new CollectTask();
                        task.setClsName("");
                        task.setPid(ScheduleMemCollectFunc.getPid());
                        CollectResult result = ScheduleMemCollectFunc.this.collector.getMemInfo(task);
                        ScheduleMemCollectFunc.this.runTask(result);
                    }
                }
                catch (Exception ex) {
                    logger.error("schedule collect meminfo error,", (Throwable)ex);
                }
            }
        }, interval * 1000, (long)(interval * 1000));
    }

    private void runTask(CollectResult result) {
        List<Meminfo> list = result.getList();
        if (list == null) {
            return;
        }
        StringBuilder databuilder = new StringBuilder();
        int index = 0;
        databuilder.append("JVMSnapshot[").append(result.getUsedMb()).append("MB/").append(result.getMaxMb()).append("MB,").append(result.getPercent()).append("%], top ").append(topcount).append(" classes:").append("\r\n");
        for (Meminfo info : result.getList()) {
            if (index >= topcount || !ScheduleMemCollectFunc.filterClass(info.getClsName())) continue;
            databuilder.append(info.getClsName()).append(":").append(info.getInstances()).append("instances,").append(info.getBytes()).append("bytes\r\n");
            ++index;
        }
        if (databuilder.length() > 0) {
            logger.info(databuilder.toString());
        }
    }

    public static boolean filterClass(String clsName) {
        if ("".equals(classpackage)) {
            return true;
        }
        return clsName.startsWith(classpackage);
    }

    public static boolean checkTrigger() {
        int kb = 1024;
        int sumTotal = 0;
        int sumUsed = 0;
        for (int i = 0; i < 3; ++i) {
            MemoryMXBean memory = ManagementFactory.getMemoryMXBean();
            MemoryUsage headMemory = memory.getHeapMemoryUsage();
            long max = headMemory.getMax() / (long)kb / (long)kb;
            long used = headMemory.getUsed() / (long)kb / (long)kb;
            sumUsed = (int)((long)sumUsed + used);
            sumTotal = (int)((long)sumTotal + max);
            try {
                Thread.currentThread();
                Thread.sleep(3000L);
                continue;
            }
            catch (InterruptedException e) {
                logger.error("thread sleep exception", (Throwable)e);
            }
        }
        int totalPercent = sumUsed * 100 / (sumTotal == 0 ? 1 : sumTotal);
        return totalPercent >= triggerPercent;
    }
}

