/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.postfunction.es;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.metric.MetricSystem;
import kd.bos.monitor.postfunction.es.ESStats;

public class ThreadPoolBulkStats
implements ESStats {
    private static final String THREADS = "threads";
    private static final String QUEUE = "queue";
    private static final String ACTIVE = "active";
    private static final String REJECTED = "rejected";
    private static final String COMPLETED = "completed";
    private static Map<String, Map<String, Object>> pools = new HashMap<String, Map<String, Object>>();

    public static Map<String, Map<String, Object>> getPools() {
        return pools;
    }

    @Override
    public void parse(String ip, JSONObject threadpool) {
        JSONObject bulk = threadpool.getJSONObject("bulk");
        int threads = bulk.getInteger(THREADS);
        int queue = bulk.getInteger(QUEUE);
        int active = bulk.getInteger(ACTIVE);
        long rejected = bulk.getInteger(REJECTED).intValue();
        long completed = bulk.getInteger(COMPLETED).intValue();
        ThreadPoolBulkStats.setMetric(ip, threads, queue, active, rejected, completed);
    }

    public static synchronized void setMetric(String url, int threads, int queue, int active, long rejected, long completed) {
        String metricUrl;
        String string = metricUrl = url.indexOf(":") >= 0 ? url.replaceAll(":", "-") : url;
        if (!pools.containsKey(metricUrl)) {
            pools.put(metricUrl, new HashMap());
            try {
                MetricSystem.registerGauge((String)("kd.metrics.es.threadpool.bulk.threads." + metricUrl), () -> pools.get(metricUrl).containsKey(THREADS) ? pools.get(metricUrl).get(THREADS) : Integer.valueOf(0));
                MetricSystem.registerGauge((String)("kd.metrics.es.threadpool.bulk.active." + metricUrl), () -> pools.get(metricUrl).containsKey(ACTIVE) ? pools.get(metricUrl).get(ACTIVE) : Integer.valueOf(0));
                MetricSystem.registerGauge((String)("kd.metrics.es.threadpool.bulk.queue." + metricUrl), () -> pools.get(metricUrl).containsKey(QUEUE) ? pools.get(metricUrl).get(QUEUE) : Integer.valueOf(0));
                MetricSystem.registerGauge((String)("kd.metrics.es.threadpool.bulk.rejected." + metricUrl), () -> pools.get(metricUrl).containsKey(REJECTED) ? pools.get(metricUrl).get(REJECTED) : Integer.valueOf(0));
                MetricSystem.registerGauge((String)("kd.metrics.es.threadpool.bulk.completed." + metricUrl), () -> pools.get(metricUrl).containsKey(COMPLETED) ? pools.get(metricUrl).get(COMPLETED) : Integer.valueOf(0));
            }
            catch (Exception e) {
                return;
            }
        }
        pools.get(metricUrl).put(THREADS, threads);
        pools.get(metricUrl).put(ACTIVE, active);
        pools.get(metricUrl).put(QUEUE, queue);
        pools.get(metricUrl).put(REJECTED, rejected);
        pools.get(metricUrl).put(COMPLETED, completed);
    }
}

