/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.proxy;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import kd.bos.monitor.httpserver.AbstractHttpHandler;
import kd.bos.monitor.proxy.ProxyHandler;
import kd.bos.monitor.util.HttpClients;
import kd.bos.url.UrlService;

public class IerpProxyHandler
extends AbstractHttpHandler {
    private static final String PLACEHOLDER = "/cyh/";
    private static final int READ_TIMEOUT = Integer.parseInt(System.getProperty("monitor.proxy.readtimeout", "60"));

    @Override
    public void handle(HttpExchange exchange) throws IOException {
        this.handle0(exchange);
    }

    @Override
    public void handle0(HttpExchange pExchange) throws IOException {
        URI uri = pExchange.getRequestURI();
        String reqPath = uri.getPath();
        int pos = reqPath.indexOf(PLACEHOLDER);
        reqPath = UrlService.getDomainContextUrl() + "/" + reqPath.substring(pos + PLACEHOLDER.length());
        try {
            HashMap<String, String> proxyHeader = new HashMap<String, String>();
            Headers headers = pExchange.getRequestHeaders();
            pExchange.getRequestHeaders();
            for (String key : headers.keySet()) {
                Object list = headers.get(key);
                if (list == null || list.isEmpty()) continue;
                proxyHeader.put(key, (String)list.get(0));
            }
            proxyHeader.put(ProxyHandler.PROXY_HEADER_KEY, ProxyHandler.PROXY_HEADER_VALUE);
            String response = HttpClients.get(reqPath, proxyHeader, 5000, READ_TIMEOUT * 1000);
            response = this.cleanXSSResponse(response);
            this.writeJson(response, pExchange);
        }
        catch (Exception e) {
            String msg = this.cleanXSSResponse(e.getMessage());
            this.writeHtml(msg, pExchange);
        }
        pExchange.close();
    }
}

