/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.service;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.mservice.keepalive.LivingKeeperUtils;
import kd.bos.redis.JedisClient;

public class LivingServiceUtils {
    private static Map<String, String> instanceHostMaps = new ConcurrentHashMap<String, String>(2);

    public static boolean isInstanceAlive(String instanceId) {
        try (JedisClient jedis = LivingKeeperUtils.createLivingMonitorJedisClient();){
            boolean bl = jedis.exists(LivingKeeperUtils.PRE + instanceId);
            return bl;
        }
    }

    public static String getInstanceHostIpPort(String instanceId) {
        return instanceHostMaps.computeIfAbsent(instanceId, k -> {
            try (JedisClient jedis = LivingKeeperUtils.createLivingMonitorJedisClient();){
                String string = jedis.get(LivingKeeperUtils.PRE + instanceId);
                return string;
            }
        });
    }
}

