/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.service;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.monitor.config.MonitorConfig;
import kd.bos.monitor.home.NodeInfo;
import kd.bos.monitor.httpserver.InnerHandler;
import kd.bos.monitor.proxy.ProxyHandler;
import kd.bos.monitor.service.ClusterNodeUtils;
import kd.bos.monitor.util.HttpClients;
import kd.bos.mservice.monitor.HealthLevel;
import kd.bos.mservice.monitor.healthmanage.cluster.ClusterHealth;
import kd.bos.mservice.monitor.healthmanage.inspect.InvokeStatistics;
import kd.bos.mservice.monitor.healthmanage.inspect.InvokeStatisticsFactory;
import kd.bos.util.resource.Resources;

public class LoadBalanceMonitorHandler
extends InnerHandler {
    private static final Log logger = LogFactory.getLog(LoadBalanceMonitorHandler.class);
    public static final String PROXY_HEADER_KEY = ProxyHandler.PROXY_HEADER_KEY;
    public static final String PROXY_HEADER_VALUE = ProxyHandler.PROXY_HEADER_VALUE;

    public LoadBalanceMonitorHandler(String context) {
        super(context);
    }

    @Override
    protected void handle0(HttpExchange exchange) throws IOException {
        try {
            StringBuilder sb = new StringBuilder();
            String ip = MonitorConfig.getNodeInfo().getIp();
            String title = Resources.getString((String)"\u8282\u70b9", (String)"LoadBalanceMonitorHandler_1", (String)"bos-monitor", (Object[])new Object[0]) + ":" + ip + "/" + Instance.getInstanceId();
            sb.append("<h1 id='").append(ip).append("'>").append("</h1>");
            sb.append("<tr>");
            sb.append("</tr><br><br>");
            sb.append(" Loadbalance detail is : <br>");
            Collection staticticses = InvokeStatisticsFactory.getAllStatistics();
            sb.append("<table border=\"1\" cellpadding=\"5\">");
            for (InvokeStatistics indicator : staticticses) {
                sb.append("<tr>");
                sb.append("<td> ").append(indicator.getName()).append(" </td><td> ");
                List ls = indicator.statistics();
                ls.forEach(sinfo -> {
                    String instanceId = sinfo.getInstanceid();
                    sb.append(instanceId).append("(").append(sinfo.getHosts()).append(") :").append(sinfo.getTps());
                    sb.append("------------");
                    int leve = ClusterHealth.getHealth((String)instanceId);
                    sb.append(HealthLevel.from((int)leve));
                    if (leve >= HealthLevel.NORMAL.getLevel()) {
                        NodeInfo node = ClusterNodeUtils.getNodeInfos(instanceId);
                        HashMap<String, String> proxyHeader = new HashMap<String, String>();
                        proxyHeader.put(PROXY_HEADER_KEY, PROXY_HEADER_VALUE);
                        String url = node.getMonitorUrl(false) + "/monitor0/nodehealth?isShowWorestIndicator=true";
                        sb.append("  ,detail : ");
                        try {
                            String response = HttpClients.get(url, proxyHeader, 2000, 2000);
                            sb.append(response);
                        }
                        catch (Exception e) {
                            sb.append(" get detail error").append(e);
                        }
                    }
                    sb.append("<br>");
                });
                sb.append("</td>");
                sb.append("</tr>");
            }
            sb.append("</table>");
            this.writeHtml(sb.toString(), exchange);
        }
        catch (Exception e) {
            this.writeHtml("featch exception ! " + e, exchange);
            logger.error("featch exception exception", (Throwable)e);
        }
    }
}

