/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.service;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.context.OperationContextCreator;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.framework.instance.ClusterInstances;
import kd.bos.framework.lifecycle.Service;
import kd.bos.framework.zoowhisper.ZooEventifyCenter;
import kd.bos.framework.zoowhisper.ZooEventifyCenterFactory;
import kd.bos.monitor.MonitorServerMain;
import kd.bos.monitor.config.MonitorConfig;
import kd.bos.monitor.home.NodeInfo;
import kd.bos.monitor.service.LivingKeeper;
import kd.bos.util.CoreConstants;
import kd.bos.util.JSONUtils;

public class MonitorServerService
implements Service {
    private static int PID = -1;
    private static ScheduledExecutorService es = Executors.newScheduledThreadPool(2, new ThreadFactory(){
        private AtomicInteger atomicInteger = new AtomicInteger(0);

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "MonitorRegistryServcie-" + this.atomicInteger.incrementAndGet());
        }
    });
    private boolean started = false;

    public static String getRootPath() {
        return ZooEventifyCenter.getRootPath((String)"configUrl") + CoreConstants.MONITORROOTPATH;
    }

    public static int getPid() {
        if (PID < 0) {
            try {
                RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
                String name = runtime.getName();
                PID = Integer.parseInt(name.substring(0, name.indexOf(64)));
            }
            catch (Exception e) {
                PID = 0;
            }
        }
        return PID;
    }

    public String getName() {
        return "MonitorServerService";
    }

    public boolean isStarted() {
        return this.started;
    }

    public void start() {
        try {
            OperationContextCreator.getOrCreateForBos();
            MonitorServerMain.start();
        }
        catch (IOException e) {
            this.started = true;
        }
        String path = MonitorServerService.getRootPath();
        NodeInfo info = MonitorConfig.getNodeInfo();
        try {
            String nodePath = path + "/" + info.getInstanceId() + "(" + info.getIp() + ")";
            info.setNodePath(nodePath);
            ZooEventifyCenter zooEventify = ZooEventifyCenterFactory.getMessageCenter();
            zooEventify.setNode("configUrl", CoreConstants.MONITORROOTPATH, info.getInstanceId() + "(" + info.getIp() + ")", JSONUtils.toString((Object)info));
            int intervalSecond = 3;
            es.scheduleWithFixedDelay(new LivingKeeper(info.getInstanceId(), info.getIp(), info.getMservicePort(), intervalSecond), 0L, intervalSecond, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{"MonitorServerService start exception!"});
        }
        this.started = true;
    }

    public void stop() {
        this.started = false;
    }

    public static ArrayList<NodeInfo> getAllNodes() {
        ArrayList<NodeInfo> list = new ArrayList<NodeInfo>();
        Map nodesMap = ClusterInstances.getAllOriginNodesString();
        nodesMap.forEach((k, v) -> {
            try {
                NodeInfo nodeInfo = (NodeInfo)JSONUtils.cast((String)v, NodeInfo.class, (boolean)true);
                list.add(nodeInfo);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        });
        return list;
    }
}

