/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.service;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.monitor.config.MonitorConfig;
import kd.bos.monitor.home.NodeInfo;
import kd.bos.monitor.httpserver.InnerHandler;
import kd.bos.mservice.catalog.ServiceCatalogFactory;
import kd.bos.mservice.spi.define.MServiceDefineMeta;

public class ServiceCatalogHandler
extends InnerHandler {
    private static final Log logger = LogFactory.getLog(ServiceCatalogHandler.class);

    public ServiceCatalogHandler(String context) {
        super(context);
    }

    @Override
    protected void handle0(HttpExchange exchange) throws IOException {
        try {
            Map typeServiceDefinesMap = ServiceCatalogFactory.getCatalog().getServiceDefineOfType();
            StringBuilder sb = new StringBuilder();
            NodeInfo ninfo = MonitorConfig.getNodeInfo();
            String ip = ninfo.getIp() + ":" + ninfo.getWebPort();
            sb.append("<h1 id='").append(ip).append("'>").append("Service Catalog of ").append(Instance.getClusterName()).append("</h1>");
            typeServiceDefinesMap.forEach((type, serviceDefineLs) -> {
                AtomicInteger ai = new AtomicInteger(0);
                sb.append("<br>").append((String)type).append("</br>");
                sb.append("<table border=\"1\" cellpadding=\"5\"> <tr>").append("<th>Index</th>").append("<th>\u670d\u52a1\u540d</th>").append("<th>\u670d\u52a1\u5206\u7ec4</th>").append("<th>\u5e94\u7528</th>").append("<th>\u4f20\u8f93\u534f\u8bae</th>").append("<th>\u7f16\u7801\u534f\u8bae</th>").append("<th>\u670d\u52a1\u63a5\u53e3</th>").append("<th>\u5b9e\u73b0\u7c7b</th>").append("<th>\u63cf\u8ff0</th>").append("<th>\u65b9\u6cd5</th></tr>");
                serviceDefineLs.forEach(sd -> {
                    sb.append("<tr>");
                    sb.append("<td> ").append(ai.incrementAndGet()).append(" </td> ");
                    sb.append("<td> ").append(sd.getServiceName()).append(" </td><td> ").append(sd.getGroup()).append(" </td><td> ").append(this.appidsToString(sd.getAppIds())).append(" </td><td> ").append(sd.getTransProtocolTypes()).append(" </td><td> ").append(sd.getDataCodecs()).append(" </td><td> ").append(this.showString(sd.getServiceInterface())).append(" </td><td> ").append(sd.getServiceImplClass()).append(" </td><td> ").append(this.showString(sd.getServiceDesc())).append("</td>");
                    StringBuilder sbMethod = new StringBuilder("<table border=\"0\" cellpadding=\"2\" align=\"center\"> <tr><th>Method</th><th>requestPath</th><th>descript</th></tr>");
                    for (MServiceDefineMeta.MethodDefine md : sd.getMethods()) {
                        sbMethod.append("<tr><td>").append(md.getServiceMethodName()).append("</td><td align=\"center\">").append(md.getServiceMethodPath()).append("</td><td align=\"center\">").append(md.getServiceMethodDesc()).append("</td></tr>");
                    }
                    sbMethod.append("</table>");
                    sb.append(" </td><td> ").append((CharSequence)sbMethod).append("</td>");
                    sb.append("</tr>");
                });
                sb.append("</table>");
            });
            this.writeHtml(sb.toString(), exchange);
        }
        catch (Exception e) {
            this.writeHtml("featch exception ! " + e, exchange);
            logger.error("featch exception exception", (Throwable)e);
        }
    }

    private String showString(String s) {
        return s == null ? "\u65e0" : s;
    }

    private String appidsToString(String[] args) {
        if (args == null) {
            return "all";
        }
        StringBuilder sb = new StringBuilder();
        for (String arg : args) {
            sb.append(arg);
        }
        return sb.toString();
    }
}

