/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.thread;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.monitor.home.NodeInfo;
import kd.bos.monitor.httpserver.InnerHandler;
import kd.bos.monitor.proxy.ProxyHandler;
import kd.bos.monitor.thread.ThreadDumpAllHandler;
import kd.bos.monitor.thread.ThreadDumpUtil;
import kd.bos.monitor.thread.entity.AllThreadDumpInfo;
import kd.bos.monitor.thread.entity.KeyValueEntity;
import kd.bos.monitor.thread.entity.ThreadDumpInfo;
import kd.bos.monitor.thread.entity.ThreadInfo;
import kd.bos.monitor.util.HttpClients;
import kd.bos.monitor.util.UriQuery;
import kd.bos.trace.tracer.TraceStatistics;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import kd.bos.util.resource.Resources;

public class NewThreadDumpHandler
extends InnerHandler {
    private static final String PROXY_HEADER_KEY = ProxyHandler.PROXY_HEADER_KEY;
    private static final Log logger = LogFactory.getLog(ThreadDumpAllHandler.class);
    private static final String PROXY_HEADER_VALUE = ProxyHandler.PROXY_HEADER_VALUE;
    private static final int READ_TIME_OUT = Integer.parseInt(System.getProperty("monitor.proxy.readtimeout", "60"));
    private static final List<Set<String>> EXCEPTION_NODES = new ArrayList<Set<String>>();
    private String appNameParam = "*";
    private String ipParam = "*";
    private int selected = 12;
    private String keyParam = "";
    private String excludeKeyParam = "";
    private int rowParam = 20;
    private boolean isOpenParam = false;
    private static final String CSS = "<style>\n    .modal {\n        display: none;\n        position: fixed;\n        z-index: 1;\n        padding-top: 100px;\n        left: 0;\n        top: 0;\n        width: 100%;\n        height: 100%;\n        overflow: auto;\n        background-color: rgb(0,0,0);\n        background-color: rgba(0,0,0,0.4);\n    }\n    .modal-content {\n        background-color: #fefefe;\n        margin: auto;\n        padding: 20px;\n        border: 1px solid #888;\n        width: 60%;\n    }\n    .close {\n        color: #aaaaaa;\n        float: right;\n        font-size: 28px;\n        font-weight: bold;\n    }\n    .close:hover,\n    .close:focus {\n        color: #000;\n        text-decoration: none;\n        cursor: pointer;\n    }\n    .go-top {\n        position: fixed;\n        bottom: 20px;\n        right: 20px;\n    }  \n    .go-top a {\n        display: block;\n        text-decoration: none;\n        color: #333;\n        background-color: #f2f2f2;\n        border: 1px solid #ccc;\n        padding: 10px 20px;\n        border-radius: 5px;\n        letter-spacing: 2px;\n    }</style>";
    private static final String SCRIPT = "<script>\n    function getIP(appName) {\n        var url = \"./newthreaddump?ajaxAppName=\" + appName;\n        ajaxGet(url, function (response) {\n            var ipNode = document.getElementById(\"ip\");\n            ipNode.options.length = 1;\n            ipJSON = JSON.parse(response);\n            var ipList = ipJSON.ips;\n            var exceptionIpList = ipJSON.exceptionIps;\n            for (var i = 0; i < ipList.length; i++) {\n                var textNode = document.createTextNode(ipList[i]);\n                var optionNode = document.createElement(\"option\");\n                if (isExceptionIp(ipList[i], exceptionIpList)) {\n                    optionNode.style.color = \"red\";\n                }\n                optionNode.appendChild(textNode);\n                ipNode.appendChild(optionNode);\n            }\n        });\n\n        function isExceptionIp(ip, exceptionIpList) {\n            var flag = false;\n            for (var i = 0; i < exceptionIpList.length; i++) {\n                if (ip === exceptionIpList[i]) {\n                    flag = true;\n                    break;\n                }\n            }\n            return flag;\n        }\n    }\n    function ajaxGet(url, callback) {\n        var xhr = new XMLHttpRequest();\n        xhr.open('GET', url, true);\n        xhr.send();\n        xhr.onreadystatechange = function () {\n            if (xhr.readyState === 4 && xhr.status === 202) {\n                callback(xhr.responseText);\n            }\n        }\n    }\nfunction showMore(id) {\n    var hide = \"hide\" + id.substring(4)\n    var more = document.getElementById(id)\n    document.getElementById(hide).style.display = \"block\"\n    more.innerHTML = \"\u6536\u8d77\";\n    more.href = \"javascript:void(0);\"\n    more.setAttribute(\"onclick\", \"showLess(id)\")\n    more.setAttribute(\"name\", \"less\")\n}\nfunction showLess(id) {\n    var hide = \"hide\" + id.substring(4)\n    var less = document.getElementById(id)\n    document.getElementById(hide).style.display = \"none\";\n    less.innerHTML = \"\u5c55\u5f00\";\n    less.href = \"javascript:void(0);\"\n    less.setAttribute(\"onclick\", \"showMore(id)\")\n    less.setAttribute(\"name\", \"more\")\n}\nfunction showAllMore() {\n    var nodeList = document.getElementsByName(\"hide\")\n    var moreNodeList = document.getElementsByName(\"more\")\n    var moreList = []\n    for (const more of moreNodeList) {\n        moreList.push(more)\n    }\n    for (const node of nodeList) {\n        node.style.display = \"block\"\n    }\n    for (const more of moreList) {\n        more.innerHTML = \"\u6536\u8d77\"\n        more.href = \"javascript:void(0);\"\n        more.setAttribute(\"onclick\", \"showLess(id)\")\n        more.setAttribute(\"name\", \"less\")\n    }\n}\nfunction showAllLess() {\n    var nodeList = document.getElementsByName(\"hide\")\n    var lessNodeList = document.getElementsByName(\"less\")\n    var lessList = []\n    for (const less of lessNodeList) {\n        lessList.push(less)\n    }\n    for (const node of nodeList) {\n        node.style.display = \"none\"\n    }\n    for (const less of lessList) {\n        less.innerHTML = \"\u5c55\u5f00\";\n        less.href = \"javascript:void(0);\"\n        less.setAttribute(\"onclick\", \"showMore(id)\")\n        less.setAttribute(\"name\", \"more\")\n    }\n}function openModal(id) {\n        var modalId = id + \"-modal\";\n        var spanId = id + \"-span\";\n        var modal = document.getElementById(modalId);\n        var span = document.getElementById(spanId);\n\n        modal.style.display = \"block\";\n        span.onclick = function() {\n            modal.style.display = \"none\";\n        }\n        window.onclick = function(event) {\n            if (event.target === modal) {\n                modal.style.display = \"none\";\n            }\n        }\n    }\nfunction getRemote(id, traceId, ipAndPort){\n    var div = document.getElementById(id);\n    var url = \"./newremotethreaddump?traceId=\" + traceId + \"&ipAndPort=\" + ipAndPort;\n    ajaxGet(url, function (response) {\n        div.innerHTML = response;\n    });\n}</script>";
    private static final String FLOAT = "<div class=\"go-top\">\n    <a href=\"#\">\u8fd4\u56de\u9876\u90e8</a>\n    <a href=\"javascript:void(0)\" onClick=\"showAllMore()\">\u5c55\u5f00\u5168\u90e8</a>\n    <a href=\"javascript:void(0)\" onClick=\"showAllLess()\">\u6536\u8d77\u5168\u90e8</a>\n</div>";

    public NewThreadDumpHandler(String context) {
        super(context);
    }

    @Override
    protected void handle0(HttpExchange exchange) throws IOException {
        ArrayList<NodeInfo> nodeInfoList = ThreadDumpUtil.getSortedNodeInfos();
        Map<String, String> params = UriQuery.toMap(exchange.getRequestURI().getQuery());
        String ajaxAppName = params.get("ajaxAppName");
        String appName = params.get("appname");
        if (appName == null) {
            appName = nodeInfoList.size() > 10 ? ((NodeInfo)nodeInfoList.get(0)).getAppName() : "*";
        }
        String ip = params.get("ip") == null ? "*" : params.get("ip");
        String key = params.get("key") == null ? "" : params.get("key");
        String excludeKey = params.get("excludeKey") == null ? "" : params.get("excludeKey");
        this.appNameParam = appName;
        this.ipParam = ip;
        this.keyParam = key;
        this.excludeKeyParam = excludeKey;
        this.rowParam = this.rowParamToInt(params.get("row"));
        this.isOpenParam = params.get("isOpen") != null;
        this.setSelectChecked(exchange);
        if (!StringUtils.isEmpty((String)ajaxAppName)) {
            this.ajaxDropDownHandle(exchange, ajaxAppName);
            return;
        }
        List<NodeInfo> filterNodeInfoList = this.getFilteredNodeInfoList(nodeInfoList, appName, ip);
        List<AllThreadDumpInfo> allThreadDumpInfoList = this.asynGetAllThreadDumpInfoList(filterNodeInfoList, exchange);
        List<ThreadDumpInfo> sortedThreadDumpInfoList = this.createSortedThreadDumpInfoList(allThreadDumpInfoList);
        List<String> deadLockList = this.createDeadLockList(allThreadDumpInfoList);
        String data = "<font face=\"Helvetica Neue\">" + this.titleToHTML(nodeInfoList) + this.deadLockListToHTML(deadLockList) + this.threadDumpInfoListToHTML(sortedThreadDumpInfoList) + (this.isOpenParam ? "<script>showAllMore()</script>" : "") + "</font>";
        this.sendResponse(exchange, data);
    }

    private void ajaxDropDownHandle(HttpExchange exchange, String ajaxAppName) {
        ArrayList<NodeInfo> nodeInfoList = ThreadDumpUtil.getSortedNodeInfos();
        Multimap<String, String> appNameAndIpMultimap = this.createAppNameAndIpMultimap(nodeInfoList);
        List<String> allIpList = this.getAllIpList(nodeInfoList);
        StringBuilder data = new StringBuilder();
        try {
            data.append("{\"ips\": ").append(ajaxAppName.equals("*") ? JSONUtils.toString(allIpList) : JSONUtils.toString((Object)appNameAndIpMultimap.get((Object)ajaxAppName))).append(",\"exceptionIps\":").append(EXCEPTION_NODES.isEmpty() ? "[]" : JSONUtils.toString(EXCEPTION_NODES.get(0))).append("}");
            this.sendResponse(exchange, data.toString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private List<NodeInfo> getFilteredNodeInfoList(List<NodeInfo> nodeInfoList, String appName, String ip) {
        Multimap<String, NodeInfo> appNameAndNodeInfoMultimap = this.createAppNameAndNodeInfoMultimap(nodeInfoList);
        if (!ip.equals("*")) {
            ArrayList<NodeInfo> filteredNodeInfoList = new ArrayList<NodeInfo>(1);
            filteredNodeInfoList.add(this.getNodeInfoByIp(ip, nodeInfoList));
            return filteredNodeInfoList;
        }
        if (appName.equals("*")) {
            return nodeInfoList;
        }
        return new ArrayList<NodeInfo>(appNameAndNodeInfoMultimap.get((Object)appName));
    }

    private void sendResponse(HttpExchange exchange, String data) throws IOException {
        byte[] bytes = data.getBytes(StandardCharsets.UTF_8);
        exchange.getResponseHeaders().set("Content-Type", "text/html; charset=UTF-8");
        exchange.sendResponseHeaders(202, bytes.length);
        exchange.getResponseBody().write(bytes);
        exchange.close();
    }

    private void addOperateToThreadName(AllThreadDumpInfo allThreadDumpInfo, NodeInfo nodeInfo) {
        List<ThreadDumpInfo> threadDumpInfoList = allThreadDumpInfo.getThreadDumpInfoList();
        for (ThreadDumpInfo threadDumpInfo : threadDumpInfoList) {
            if (threadDumpInfo.getTraceId() == null) continue;
            threadDumpInfo.setShowThreadName(threadDumpInfo.getShowThreadName() + " [<a href=./#/logQuery-new?appName=" + nodeInfo.getAppName() + "&instanceId=" + nodeInfo.getInstanceId() + "&traceId=" + threadDumpInfo.getTraceId() + " target=view_window>" + Resources.getString((String)"\u67e5\u770b\u65e5\u5fd7", (String)"NewThreadDumpHandler_11", (String)"bos-monitor", (Object[])new Object[0]) + "</a>]");
        }
    }

    private void setSelectChecked(HttpExchange exchange) {
        Map<String, String> params = UriQuery.toMap(exchange.getRequestURI().getQuery());
        int value = 8;
        int live = 4;
        int webRequest = 2;
        int service = 1;
        if (params.get("live") != null && params.get("live").equals("true")) {
            value |= live;
        }
        if (params.get("threadname") != null && params.get("threadname").contains("http-request-pool")) {
            value |= webRequest;
        }
        if (params.get("threadname") != null && params.get("threadname").contains("RpcRequest")) {
            value |= service;
        }
        if (params.get("live") == null && params.get("threadname") == null) {
            value = 12;
        }
        this.selected = value;
    }

    private List<ThreadDumpInfo> createSortedThreadDumpInfoList(List<AllThreadDumpInfo> allThreadDumpInfoList) {
        ArrayList<ThreadDumpInfo> threadDumpInfoList = new ArrayList<ThreadDumpInfo>();
        for (AllThreadDumpInfo allThreadDumpInfo : allThreadDumpInfoList) {
            if (allThreadDumpInfo == null) continue;
            threadDumpInfoList.addAll(allThreadDumpInfo.getThreadDumpInfoList());
        }
        threadDumpInfoList.sort((o1, o2) -> {
            if (o1.getDuration().equals("") && o2.getDuration().equals("")) {
                return 0;
            }
            if (o1.getDuration().equals("")) {
                return 1;
            }
            if (o2.getDuration().equals("")) {
                return -1;
            }
            return (int)(Long.parseLong(o2.getDuration()) - Long.parseLong(o1.getDuration()));
        });
        int index = 1;
        for (ThreadDumpInfo threadDumpInfo : threadDumpInfoList) {
            threadDumpInfo.setShowThreadName(index + "." + threadDumpInfo.getShowThreadName());
            ++index;
        }
        return threadDumpInfoList;
    }

    private List<String> createDeadLockList(List<AllThreadDumpInfo> allThreadDumpInfoList) {
        ArrayList<String> deadLockList = new ArrayList<String>();
        for (AllThreadDumpInfo allThreadDumpInfo : allThreadDumpInfoList) {
            if (allThreadDumpInfo == null || allThreadDumpInfo.getDeadLockList() == null) continue;
            deadLockList.addAll(allThreadDumpInfo.getDeadLockList());
        }
        return deadLockList;
    }

    private String getAccessUrlOfNodeInfo(HttpExchange exchange, NodeInfo nodeInfo) {
        Map<String, String> params = UriQuery.toMap(exchange.getRequestURI().getQuery());
        boolean live = false;
        if (params.get("live") == null) {
            live = true;
        } else if (params.get("live").equals("true")) {
            live = true;
        }
        String threadName = params.get("threadname") == null ? "" : params.get("threadname");
        String key = params.get("key") == null ? "" : params.get("key");
        String excludeKey = params.get("excludeKey") == null ? "" : params.get("excludeKey");
        return nodeInfo.getMonitorUrl(false) + "/monitor/eye/newthreaddumpproxy?proxyurl=/monitor/eye/proxy&appname=" + nodeInfo.getAppName() + "&ip=" + nodeInfo.getIp() + (live ? "&live=true" : "&live=false") + "&threadname=" + threadName + "&key=" + key + "&excludeKey=" + excludeKey;
    }

    private Multimap<String, String> createAppNameAndIpMultimap(List<NodeInfo> nodeInfoList) {
        ArrayListMultimap appNameAndIpMultimap = ArrayListMultimap.create();
        for (NodeInfo nodeInfo : nodeInfoList) {
            appNameAndIpMultimap.put((Object)nodeInfo.getAppName(), (Object)nodeInfo.getIp());
        }
        return appNameAndIpMultimap;
    }

    private Multimap<String, NodeInfo> createAppNameAndNodeInfoMultimap(List<NodeInfo> nodeInfoList) {
        ArrayListMultimap appNameAndIpMultimap = ArrayListMultimap.create();
        for (NodeInfo nodeInfo : nodeInfoList) {
            appNameAndIpMultimap.put((Object)nodeInfo.getAppName(), (Object)nodeInfo);
        }
        return appNameAndIpMultimap;
    }

    private NodeInfo getNodeInfoByIp(String ip, List<NodeInfo> nodeInfoList) {
        for (NodeInfo nodeInfo : nodeInfoList) {
            if (!ip.equals(nodeInfo.getIp())) continue;
            return nodeInfo;
        }
        return null;
    }

    private List<String> getAllIpList(List<NodeInfo> nodeInfoList) {
        ArrayList<String> allIpList = new ArrayList<String>(nodeInfoList.size());
        for (NodeInfo nodeInfo : nodeInfoList) {
            allIpList.add(nodeInfo.getIp());
        }
        return allIpList;
    }

    private HashSet<String> getAppNameSet(List<NodeInfo> nodeInfoList) {
        HashSet<String> appNameSet = new HashSet<String>();
        for (NodeInfo nodeInfo : nodeInfoList) {
            appNameSet.add(nodeInfo.getAppName());
        }
        return appNameSet;
    }

    private String getThreadDumpInfoJsonFromUrl(String accessUrlOfNodeInfo) throws Exception {
        HashMap<String, String> proxyHeader = new HashMap<String, String>();
        proxyHeader.put(PROXY_HEADER_KEY, PROXY_HEADER_VALUE);
        try {
            return HttpClients.get(accessUrlOfNodeInfo, proxyHeader, 5000, READ_TIME_OUT * 1000);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    private AllThreadDumpInfo castThreadDumpInfoJsonToThreadDumpInfo(String allThreadDumpInfoJSON) throws Exception {
        AllThreadDumpInfo allThreadDumpInfo = null;
        if (allThreadDumpInfoJSON != null) {
            try {
                allThreadDumpInfo = (AllThreadDumpInfo)JSONUtils.cast((String)allThreadDumpInfoJSON, AllThreadDumpInfo.class);
            }
            catch (IOException e) {
                throw new Exception(e);
            }
        }
        return allThreadDumpInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AllThreadDumpInfo> asynGetAllThreadDumpInfoList(List<NodeInfo> filterNodeInfoList, HttpExchange exchange) {
        ExecutorService executorService = Executors.newFixedThreadPool(4);
        CountDownLatch countDownLatch = new CountDownLatch(filterNodeInfoList.size());
        CopyOnWriteArrayList<AllThreadDumpInfo> allThreadDumpInfoList = new CopyOnWriteArrayList<AllThreadDumpInfo>();
        HashSet exceptionNodes = new HashSet();
        if (EXCEPTION_NODES.isEmpty()) {
            EXCEPTION_NODES.add(exceptionNodes);
        } else {
            EXCEPTION_NODES.set(0, exceptionNodes);
        }
        try {
            for (NodeInfo filteredNodeInfo : filterNodeInfoList) {
                executorService.submit(() -> {
                    try {
                        String accessUrlOfNodeInfo = this.getAccessUrlOfNodeInfo(exchange, filteredNodeInfo);
                        String allThreadDumpInfoJson = this.getThreadDumpInfoJsonFromUrl(accessUrlOfNodeInfo);
                        AllThreadDumpInfo allThreadDumpInfo = this.castThreadDumpInfoJsonToThreadDumpInfo(allThreadDumpInfoJson);
                        if (allThreadDumpInfo != null) {
                            this.addOperateToThreadName(allThreadDumpInfo, filteredNodeInfo);
                            allThreadDumpInfoList.add(allThreadDumpInfo);
                        }
                    }
                    catch (Exception e) {
                        exceptionNodes.add(filteredNodeInfo.getIp());
                    }
                    finally {
                        countDownLatch.countDown();
                    }
                });
            }
            try {
                countDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        finally {
            executorService.shutdown();
        }
        return allThreadDumpInfoList;
    }

    private String threadDumpInfoListToHTML(List<ThreadDumpInfo> threadDumpInfoList) {
        StringBuilder content = new StringBuilder();
        for (ThreadDumpInfo threadDumpInfo : threadDumpInfoList) {
            String remoteIPAndPort = threadDumpInfo.getRemoteIPAndPort();
            if (remoteIPAndPort == null) {
                content.append("<b style=\"color: blue\">").append(threadDumpInfo.getShowThreadName()).append("</b>").append("<br>").append(this.getFormatThreadStatisticInfo(threadDumpInfo)).append(this.getFormatMemSpanInfo(threadDumpInfo)).append(this.getFormatStackTrace(threadDumpInfo)).append("<br>");
                continue;
            }
            StringBuilder remoteContent = new StringBuilder();
            String remoteId = UUID.randomUUID().toString().split("-")[0];
            remoteContent.append("<div id=").append(remoteId).append(" style=\"display: flex; align-items: flex-start\">").append("</div>").append("<script> getRemote('").append(remoteId).append("','").append(threadDumpInfo.getTraceId()).append("','").append(threadDumpInfo.getRemoteIPAndPort()).append("')</script>");
            content.append("<div style=\"display: flex; align-items: flex-start\">").append("<div style=\"display: inline-block; width: 900px; word-wrap: break-word\">").append("<b style=\"color: blue\">").append(threadDumpInfo.getShowThreadName()).append("</b>").append("<br>").append(this.getFormatThreadStatisticInfo(threadDumpInfo)).append(this.getFormatMemSpanInfo(threadDumpInfo)).append(this.getFormatStackTrace(threadDumpInfo)).append("</div>").append((CharSequence)remoteContent).append("</div><br>");
        }
        return content.toString();
    }

    private String getFormatThreadStatisticInfo(ThreadDumpInfo threadDumpInfo) {
        String info = "<b>[" + Resources.getString((String)"\u7ebf\u7a0b\u4fe1\u606f", (String)"NewThreadDumpHandler_10", (String)"bos-monitor", (Object[])new Object[0]) + "]&nbsp;&nbsp;";
        String content = Resources.getString((String)"\u5b9e\u4f8bIP", (String)"NewThreadDumpHandler_9", (String)"bos-monitor", (Object[])new Object[0]) + ": " + threadDumpInfo.getIp() + "&nbsp;" + Resources.getString((String)"\u5fae\u670d\u52a1", (String)"NewThreadDumpHandler_8", (String)"bos-monitor", (Object[])new Object[0]) + ": " + threadDumpInfo.getAppName() + "</b><br>";
        if (StringUtils.isNotEmpty((String)threadDumpInfo.getStartTime())) {
            content = content + "&nbsp;&nbsp;" + Resources.getString((String)"\u542f\u52a8\u65f6\u95f4", (String)"ThreadDumpHandler_1", (String)"bos-monitor", (Object[])new Object[0]) + ": " + threadDumpInfo.getStartTime() + ", " + Resources.getString((String)"\u5df2\u8fd0\u884c", (String)"ThreadDumpHandler_2", (String)"bos-monitor", (Object[])new Object[0]) + ": " + threadDumpInfo.getDuration() + Resources.getString((String)"\u6beb\u79d2", (String)"ThreadDumpHandler_3", (String)"bos-monitor", (Object[])new Object[0]) + (StringUtils.isEmpty((String)threadDumpInfo.getClientUrl()) ? "" : "<br>&nbsp;&nbsp;URL: " + threadDumpInfo.getClientUrl()) + (StringUtils.isEmpty((String)threadDumpInfo.getUserName()) ? "" : "<br>&nbsp;&nbsp;UserName: " + this.cleanXss(threadDumpInfo.getUserName())) + (StringUtils.isEmpty((String)threadDumpInfo.getTenantId()) ? "" : "<br>&nbsp;&nbsp;TenantId: " + threadDumpInfo.getTenantId()) + (StringUtils.isEmpty((String)threadDumpInfo.getFormId()) ? "" : "<br>&nbsp;&nbsp;FormId: " + threadDumpInfo.getFormId()) + (StringUtils.isEmpty((String)threadDumpInfo.getAction()) ? "" : "<br>&nbsp;&nbsp;Action: " + threadDumpInfo.getAction()) + (threadDumpInfo.getThreadTraceStatList() == null || threadDumpInfo.getThreadTraceStatList().size() == 0 ? "" : "<br><b>[" + Resources.getString((String)"\u7ebf\u7a0b\u7edf\u8ba1", (String)"ThreadDumpHandler_5", (String)"bos-monitor", (Object[])new Object[0]) + "]</b><br>" + this.getFormatThreadTraceStat(threadDumpInfo.getThreadTraceStatList())) + "<br>";
        }
        return info + content;
    }

    private String cleanXss(String message) {
        if (!StringUtils.isEmpty((String)message)) {
            message = message.replaceAll("'", "&#39;");
            message = message.replaceAll("<", "&lt;");
            message = message.replaceAll(">", "&gt;");
            message = message.replaceAll("\"", "&quot;");
            message = message.replaceAll("'", "&#x27;");
            message = message.replaceAll("/", "&#x2f;");
        }
        return message;
    }

    private String getFormatMemSpanInfo(ThreadDumpInfo threadDumpInfo) {
        List<ThreadInfo.MemSpanInfo> memSpanInfoList = threadDumpInfo.getMemSpanInfoList();
        if (memSpanInfoList.isEmpty()) {
            return "";
        }
        StringBuilder content = new StringBuilder();
        for (ThreadInfo.MemSpanInfo memSpanInfo : memSpanInfoList) {
            String btnId = UUID.randomUUID().toString().split("-")[0];
            content.append("<b>[").append(Resources.getString((String)"\u5f53\u524d\u65b9\u6cd5", (String)"ThreadDumpHandler_7", (String)"bos-monitor", (Object[])new Object[0])).append("]</b> ").append(" ").append(Resources.getString((String)"\u5f00\u59cb\u65f6\u95f4", (String)"ThreadDumpHandler_8", (String)"bos-monitor", (Object[])new Object[0])).append(": ").append(memSpanInfo.getMethodStartTime()).append(", ").append(Resources.getString((String)"\u5df2\u6267\u884c", (String)"ThreadDumpHandler_9", (String)"bos-monitor", (Object[])new Object[0])).append(": ").append(memSpanInfo.getMethodDuration()).append(Resources.getString((String)"\u6beb\u79d2", (String)"ThreadDumpHandler_10", (String)"bos-monitor", (Object[])new Object[0])).append(", ").append(Resources.getString((String)"\u6267\u884c\u65b9\u6cd5", (String)"ThreadDumpHandler_11", (String)"bos-monitor", (Object[])new Object[0])).append(": ");
            if (memSpanInfo.getExecuteMethod().contains("[")) {
                content.append(memSpanInfo.getExecuteMethod(), 0, memSpanInfo.getExecuteMethod().indexOf("[")).append("<a id=").append(btnId).append(" href=\"javascript:void(0);\" onclick=\"openModal(this.id)\">\u67e5\u770b</a>").append("<div id=").append(btnId).append("-modal class=\"modal\"><div class=\"modal-content\"><span id=").append(btnId).append("-span class=\"close\">&times;</span><h3>").append(Resources.getString((String)"\u6267\u884c\u65b9\u6cd5", (String)"ThreadDumpHandler_11", (String)"bos-monitor", (Object[])new Object[0])).append("</h3><p>").append(memSpanInfo.getExecuteMethod()).append("</p></div></div>");
            } else {
                content.append(memSpanInfo.getExecuteMethod()).append("<br>");
            }
            List<KeyValueEntity> details = memSpanInfo.getDetails();
            if (details.size() != 0) {
                for (KeyValueEntity detail : details) {
                    if ("service".equals(detail.getKey())) continue;
                    content.append("<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;").append("[ ").append(detail.getKey()).append(" ]: ").append(detail.getValue());
                }
            }
            content.append("<br>");
        }
        return content.toString();
    }

    private String getFormatThreadTraceStat(List<TraceStatistics.ThreadTraceStat> threadTraceStatList) {
        StringBuilder content = new StringBuilder();
        for (TraceStatistics.ThreadTraceStat threadTraceStat : threadTraceStatList) {
            content.append("&nbsp;&nbsp;").append(threadTraceStat.getType()).append(": ").append(Resources.getString((String)"\u6267\u884c\u6b21\u6570", (String)"NewThreadDumpHandler_1", (String)"bos-monitor", (Object[])new Object[0])).append(": ").append(threadTraceStat.getExecCount()).append(", ").append(Resources.getString((String)"\u603b\u65f6\u95f4", (String)"NewThreadDumpHandler_2", (String)"bos-monitor", (Object[])new Object[0])).append(": ").append(threadTraceStat.getTotalDuration()).append(Resources.getString((String)"\u6beb\u79d2", (String)"ThreadDumpHandler_3", (String)"bos-monitor", (Object[])new Object[0])).append(", ").append(Resources.getString((String)"\u5e73\u5747\u65f6\u95f4", (String)"NewThreadDumpHandler_3", (String)"bos-monitor", (Object[])new Object[0])).append(": ").append(threadTraceStat.getAvgDuration()).append(Resources.getString((String)"\u6beb\u79d2", (String)"ThreadDumpHandler_3", (String)"bos-monitor", (Object[])new Object[0])).append("<br>");
        }
        return content.toString();
    }

    private String getFormatStackTrace(ThreadDumpInfo threadDumpInfo) {
        List<String> stackTraceList = threadDumpInfo.getStackTraceInfoList();
        if (stackTraceList.isEmpty()) {
            return "";
        }
        StringBuilder formatStackTrace = new StringBuilder();
        formatStackTrace.append("<b>[").append(Resources.getString((String)"\u7ebf\u7a0b\u5806\u6808", (String)"ThreadDumpHandler_12", (String)"bos-monitor", (Object[])new Object[0])).append("]</b><br>");
        int line = this.rowParam;
        String divId = UUID.randomUUID().toString().split("-")[0];
        for (String stackTrace : stackTraceList) {
            formatStackTrace.append("&nbsp;&nbsp;at ").append(stackTrace).append("<br>");
            if (--line != 0) continue;
            formatStackTrace.append("<div id=hide-").append(divId).append(" name='hide' style=\"display: none\">");
        }
        if (line <= 0) {
            formatStackTrace.append("</div><a href=\"javascript:void(0);\" onclick=\"showMore(this.id)\" id=more-").append(divId).append(" name='more'>\u5c55\u5f00</a>");
        }
        return formatStackTrace.toString();
    }

    private String deadLockListToHTML(List<String> deadLockList) {
        if (deadLockList.isEmpty()) {
            return "";
        }
        StringBuilder content = new StringBuilder("<font color=\"red\">Thread DeadLock checked!!!</font><br><br>");
        for (String deadLock : deadLockList) {
            content.append(deadLock);
        }
        return content.toString();
    }

    private String getThreadTypeSelectHTML() {
        String options;
        String select = Resources.getString((String)"\u7ebf\u7a0b\u7c7b\u578b", (String)"NewThreadDumpHandler_7", (String)"bos-monitor", (Object[])new Object[0]);
        switch (this.selected) {
            case 8: {
                options = "<select name=allThread style=\"width: 160;\">\n            <option value=true&live=false selected>\u6240\u6709\u7ebf\u7a0b</option>\n            <option value=true&live=true>\u6240\u6709\u6d3b\u8dc3\u7ebf\u7a0b</option>\n            <option value=true&threadname=http-request-pool&live=false>\u6240\u6709WEB\u7ebf\u7a0b</option>\n            <option value=true&threadname=http-request-pool&live=true>\u6240\u6709\u6d3b\u8dc3WEB\u7ebf\u7a0b</option>\n            <option value=true&threadname=RpcRequest&live=false>\u6240\u6709\u670d\u52a1\u7ebf\u7a0b</option>\n            <option value=true&threadname=RpcRequest&live=true>\u6240\u6709\u6d3b\u8dc3\u670d\u52a1\u7ebf\u7a0b</option>\n            <option value=true&threadname=RpcRequest,http-request-pool&live=false>\u6240\u6709WEB\u548c\u670d\u52a1\u7ebf\u7a0b</option>\n            <option value=true&threadname=RpcRequest,http-request-pool&live=true>\u6240\u6709\u6d3b\u8dc3WEB\u548c\u670d\u52a1\u7ebf\u7a0b</option>\n        </select>";
                break;
            }
            case 10: {
                options = "<select name=allThread style=\"width: 160;\">\n            <option value=true&live=false>\u6240\u6709\u7ebf\u7a0b</option>\n            <option value=true&live=true>\u6240\u6709\u6d3b\u8dc3\u7ebf\u7a0b</option>\n            <option value=true&threadname=http-request-pool&live=false selected>\u6240\u6709WEB\u7ebf\u7a0b</option>\n            <option value=true&threadname=http-request-pool&live=true>\u6240\u6709\u6d3b\u8dc3WEB\u7ebf\u7a0b</option>\n            <option value=true&threadname=RpcRequest&live=false>\u6240\u6709\u670d\u52a1\u7ebf\u7a0b</option>\n            <option value=true&threadname=RpcRequest&live=true>\u6240\u6709\u6d3b\u8dc3\u670d\u52a1\u7ebf\u7a0b</option>\n            <option value=true&threadname=RpcRequest,http-request-pool&live=false>\u6240\u6709WEB\u548c\u670d\u52a1\u7ebf\u7a0b</option>\n            <option value=true&threadname=RpcRequest,http-request-pool&live=true>\u6240\u6709\u6d3b\u8dc3WEB\u548c\u670d\u52a1\u7ebf\u7a0b</option>\n        </select>";
                break;
            }
            case 14: {
                options = "<select name=allThread style=\"width: 160;\">\n            <option value=true&live=false>\u6240\u6709\u7ebf\u7a0b</option>\n            <option value=true&live=true>\u6240\u6709\u6d3b\u8dc3\u7ebf\u7a0b</option>\n            <option value=true&threadname=http-request-pool&live=false>\u6240\u6709WEB\u7ebf\u7a0b</option>\n            <option value=true&threadname=http-request-pool&live=true selected>\u6240\u6709\u6d3b\u8dc3WEB\u7ebf\u7a0b</option>\n            <option value=true&threadname=RpcRequest&live=false>\u6240\u6709\u670d\u52a1\u7ebf\u7a0b</option>\n            <option value=true&threadname=RpcRequest&live=true>\u6240\u6709\u6d3b\u8dc3\u670d\u52a1\u7ebf\u7a0b</option>\n            <option value=true&threadname=RpcRequest,http-request-pool&live=false>\u6240\u6709WEB\u548c\u670d\u52a1\u7ebf\u7a0b</option>\n            <option value=true&threadname=RpcRequest,http-request-pool&live=true>\u6240\u6709\u6d3b\u8dc3WEB\u548c\u670d\u52a1\u7ebf\u7a0b</option>\n        </select>";
                break;
            }
            case 9: {
                options = "<select name=allThread style=\"width: 160;\">\n            <option value=true&live=false>\u6240\u6709\u7ebf\u7a0b</option>\n            <option value=true&live=true>\u6240\u6709\u6d3b\u8dc3\u7ebf\u7a0b</option>\n            <option value=true&threadname=http-request-pool&live=false>\u6240\u6709WEB\u7ebf\u7a0b</option>\n            <option value=true&threadname=http-request-pool&live=true>\u6240\u6709\u6d3b\u8dc3WEB\u7ebf\u7a0b</option>\n            <option value=true&threadname=RpcRequest&live=false selected>\u6240\u6709\u670d\u52a1\u7ebf\u7a0b</option>\n            <option value=true&threadname=RpcRequest&live=true>\u6240\u6709\u6d3b\u8dc3\u670d\u52a1\u7ebf\u7a0b</option>\n            <option value=true&threadname=RpcRequest,http-request-pool&live=false>\u6240\u6709WEB\u548c\u670d\u52a1\u7ebf\u7a0b</option>\n            <option value=true&threadname=RpcRequest,http-request-pool&live=true>\u6240\u6709\u6d3b\u8dc3WEB\u548c\u670d\u52a1\u7ebf\u7a0b</option>\n        </select>";
                break;
            }
            case 13: {
                options = "<select name=allThread style=\"width: 160;\">\n            <option value=true&live=false>\u6240\u6709\u7ebf\u7a0b</option>\n            <option value=true&live=true>\u6240\u6709\u6d3b\u8dc3\u7ebf\u7a0b</option>\n            <option value=true&threadname=http-request-pool&live=false>\u6240\u6709WEB\u7ebf\u7a0b</option>\n            <option value=true&threadname=http-request-pool&live=true>\u6240\u6709\u6d3b\u8dc3WEB\u7ebf\u7a0b</option>\n            <option value=true&threadname=RpcRequest&live=false>\u6240\u6709\u670d\u52a1\u7ebf\u7a0b</option>\n            <option value=true&threadname=RpcRequest&live=true selected>\u6240\u6709\u6d3b\u8dc3\u670d\u52a1\u7ebf\u7a0b</option>\n            <option value=true&threadname=RpcRequest,http-request-pool&live=false>\u6240\u6709WEB\u548c\u670d\u52a1\u7ebf\u7a0b</option>\n            <option value=true&threadname=RpcRequest,http-request-pool&live=true>\u6240\u6709\u6d3b\u8dc3WEB\u548c\u670d\u52a1\u7ebf\u7a0b</option>\n        </select>";
                break;
            }
            case 11: {
                options = "<select name=allThread style=\"width: 160;\">\n            <option value=true&live=false>\u6240\u6709\u7ebf\u7a0b</option>\n            <option value=true&live=true>\u6240\u6709\u6d3b\u8dc3\u7ebf\u7a0b</option>\n            <option value=true&threadname=http-request-pool&live=false>\u6240\u6709WEB\u7ebf\u7a0b</option>\n            <option value=true&threadname=http-request-pool&live=true>\u6240\u6709\u6d3b\u8dc3WEB\u7ebf\u7a0b</option>\n            <option value=true&threadname=RpcRequest&live=false>\u6240\u6709\u670d\u52a1\u7ebf\u7a0b</option>\n            <option value=true&threadname=RpcRequest&live=true>\u6240\u6709\u6d3b\u8dc3\u670d\u52a1\u7ebf\u7a0b</option>\n            <option value=true&threadname=RpcRequest,http-request-pool&live=false selected>\u6240\u6709WEB\u548c\u670d\u52a1\u7ebf\u7a0b</option>\n            <option value=true&threadname=RpcRequest,http-request-pool&live=true>\u6240\u6709\u6d3b\u8dc3WEB\u548c\u670d\u52a1\u7ebf\u7a0b</option>\n        </select>";
                break;
            }
            case 15: {
                options = "<select name=allThread style=\"width: 160;\">\n            <option value=true&live=false>\u6240\u6709\u7ebf\u7a0b</option>\n            <option value=true&live=true>\u6240\u6709\u6d3b\u8dc3\u7ebf\u7a0b</option>\n            <option value=true&threadname=http-request-pool&live=false>\u6240\u6709WEB\u7ebf\u7a0b</option>\n            <option value=true&threadname=http-request-pool&live=true>\u6240\u6709\u6d3b\u8dc3WEB\u7ebf\u7a0b</option>\n            <option value=true&threadname=RpcRequest&live=false>\u6240\u6709\u670d\u52a1\u7ebf\u7a0b</option>\n            <option value=true&threadname=RpcRequest&live=true>\u6240\u6709\u6d3b\u8dc3\u670d\u52a1\u7ebf\u7a0b</option>\n            <option value=true&threadname=RpcRequest,http-request-pool&live=false>\u6240\u6709WEB\u548c\u670d\u52a1\u7ebf\u7a0b</option>\n            <option value=true&threadname=RpcRequest,http-request-pool&live=true selected>\u6240\u6709\u6d3b\u8dc3WEB\u548c\u670d\u52a1\u7ebf\u7a0b</option>\n        </select>";
                break;
            }
            default: {
                options = "<select name=allThread style=\"width: 160;\">\n            <option value=true&live=false>\u6240\u6709\u7ebf\u7a0b</option>\n            <option value=true&live=true selected>\u6240\u6709\u6d3b\u8dc3\u7ebf\u7a0b</option>\n            <option value=true&threadname=http-request-pool&live=false>\u6240\u6709WEB\u7ebf\u7a0b</option>\n            <option value=true&threadname=http-request-pool&live=true>\u6240\u6709\u6d3b\u8dc3WEB\u7ebf\u7a0b</option>\n            <option value=true&threadname=RpcRequest&live=false>\u6240\u6709\u670d\u52a1\u7ebf\u7a0b</option>\n            <option value=true&threadname=RpcRequest&live=true>\u6240\u6709\u6d3b\u8dc3\u670d\u52a1\u7ebf\u7a0b</option>\n            <option value=true&threadname=RpcRequest,http-request-pool&live=false>\u6240\u6709WEB\u548c\u670d\u52a1\u7ebf\u7a0b</option>\n            <option value=true&threadname=RpcRequest,http-request-pool&live=true>\u6240\u6709\u6d3b\u8dc3WEB\u548c\u670d\u52a1\u7ebf\u7a0b</option>\n        </select>";
            }
        }
        return select + options;
    }

    private String titleToHTML(List<NodeInfo> nodeInfoList) {
        StringBuilder appNameSelect;
        List<String> ipList;
        HashSet<String> appNameSet = this.getAppNameSet(nodeInfoList);
        String title = Resources.getString((String)"\u7ebf\u7a0b\u76d1\u63a7", (String)"ThreadDumpAllHandler_1", (String)"bos-monitor", (Object[])new Object[0]);
        String APP_NAME = Resources.getString((String)"\u5fae\u670d\u52a1", (String)"NewThreadDumpHandler_8", (String)"bos-monitor", (Object[])new Object[0]);
        String IP = Resources.getString((String)"\u5b9e\u4f8bIP", (String)"NewThreadDumpHandler_9", (String)"bos-monitor", (Object[])new Object[0]);
        String select = this.getThreadTypeSelectHTML();
        Multimap<String, String> appNameAndNodeInfoMultimap = this.createAppNameAndIpMultimap(nodeInfoList);
        if (this.appNameParam.equals("*")) {
            ipList = this.getAllIpList(nodeInfoList);
            appNameSelect = new StringBuilder(APP_NAME).append("<select name=appname style=\"width: 160;\" onchange=getIP(this.value)> <option value=* selected=selected>\u5168\u90e8</option>");
        } else {
            ipList = new ArrayList<String>(appNameAndNodeInfoMultimap.get((Object)this.appNameParam));
            appNameSelect = new StringBuilder(APP_NAME).append("<select name=appname style=\"width: 160;\" onchange=getIP(this.value)> <option value=*>\u5168\u90e8</option>");
        }
        for (String appName : appNameSet) {
            if (appName.equals(this.appNameParam)) {
                appNameSelect.append("<option value=").append(appName).append(" selected=selected>").append(appName).append("</option>");
                continue;
            }
            appNameSelect.append("<option value=").append(appName).append(">").append(appName).append("</option>");
        }
        appNameSelect.append("</select>&nbsp;&nbsp;");
        StringBuilder ipSelect = this.ipParam.equals("*") ? new StringBuilder(IP).append("<select name=ip style=\"width: 160;\" id=ip><option value=* selected=selected>\u5168\u90e8</option>") : new StringBuilder(IP).append("<select name=ip style=\"width: 160;\" id=ip><option value=*>\u5168\u90e8</option>");
        for (String ip : ipList) {
            if (EXCEPTION_NODES.get(0).contains(ip)) {
                if (ip.equals(this.ipParam)) {
                    ipSelect.append("<option style=\"color: red\" value=").append(ip).append(" selected=selected>").append(ip).append("</option>");
                    continue;
                }
                ipSelect.append("<option style=\"color: red\" value=").append(ip).append(">").append(ip).append("</option>");
                continue;
            }
            if (ip.equals(this.ipParam)) {
                ipSelect.append("<option value=").append(ip).append(" selected=selected>").append(ip).append("</option>");
                continue;
            }
            ipSelect.append("<option value=").append(ip).append(">").append(ip).append("</option>");
        }
        ipSelect.append("</select>");
        return "<title>" + title + "</title><center><h1>" + title + "(" + nodeInfoList.size() + Resources.getString((String)"\u4e2a\u8282\u70b9)", (String)"ThreadDumpAllHandler_2", (String)"bos-monitor", (Object[])new Object[0]) + "</h1></center>" + CSS + SCRIPT + "<form name=input action=./newthreaddump method=get>" + select + "&nbsp;&nbsp;" + appNameSelect + ipSelect + "&nbsp;&nbsp;" + Resources.getString((String)"\u5305\u542b\u5173\u952e\u5b57", (String)"NewThreadDumpHandler_5", (String)"bos-monitor", (Object[])new Object[0]) + ":&nbsp;<input type=text name=key style=\"width: 150\" value='" + this.cleanXSSParam(this.keyParam) + "'>&nbsp;&nbsp;" + Resources.getString((String)"\u6392\u9664\u5173\u952e\u5b57", (String)"NewThreadDumpHandler_6", (String)"bos-monitor", (Object[])new Object[0]) + ":&nbsp;<input type=text name=excludeKey style=\"width: 150\" value='" + this.cleanXSSParam(this.excludeKeyParam) + "'>&nbsp;&nbsp;" + Resources.getString((String)"\u5806\u6808\u5c55\u5f00\u884c\u6570", (String)"NewThreadDumpHandler_12", (String)"bos-monitor", (Object[])new Object[0]) + ":&nbsp;<input type=text name=row style=\"width: 50\" value='" + (this.isOpenParam ? "" : Integer.valueOf(this.rowParam)) + "'>&nbsp;&nbsp;<label for=\"cbox\">\u5c55\u5f00\u5168\u90e8\u5806\u6808</label><input type=\"checkbox\" name=\"isOpen\" value=\"true\"" + (this.isOpenParam ? "checked" : "") + " style=\"zoom: 150%;\">&nbsp;&nbsp;<input type=submit value=" + Resources.getString((String)"\u67e5\u8be2", (String)"NewThreadDumpHandler_4", (String)"bos-monitor", (Object[])new Object[0]) + " style=\"width: 60\"></form><br>" + FLOAT;
    }

    private int rowParamToInt(String rowParam) {
        int row = 20;
        try {
            int parseRow = Integer.parseInt(rowParam);
            return parseRow <= 0 ? row : parseRow;
        }
        catch (Exception e) {
            return row;
        }
    }
}

