/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.thread;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.OperationContextCreator;
import kd.bos.framework.instance.ClusterInstances;
import kd.bos.instance.Instance;
import kd.bos.monitor.config.MonitorConfig;
import kd.bos.monitor.home.NodeInfo;
import kd.bos.monitor.httpserver.InnerHandler;
import kd.bos.monitor.thread.ThreadDumpUtil;
import kd.bos.monitor.thread.ThreadInfo;
import kd.bos.monitor.util.UriQuery;
import kd.bos.trace.tracer.TraceStatistics;
import kd.bos.trace.tracer.TracerImpl;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import kd.bos.util.WebPortUtil;
import kd.bos.util.resource.Resources;

public class ThreadDumpHandler
extends InnerHandler {
    private static final String TIME_STR = "/time:";
    private static final String TRACE_ID_STR = "/traceId:";
    private static Set<String> excludeThreadNames;
    private static String DEFAULT_MONITOR_THREAD;
    private static List<String> monitorThreadList;
    private static ThreadMXBean mbean;
    private static final String HIDDEN_THREADS;
    private static final String TD_SUF_TD = "</td><td>";
    private static final String MAGIC = "<td valign=top><a href=";
    private static final String MAGIC2 = "</a></td>&nbsp;";

    public ThreadDumpHandler(String context) {
        super(context);
    }

    @Override
    public void handle0(HttpExchange exchange) throws IOException {
        String names = System.getProperty("monitor.exclude.threads");
        if (StringUtils.isNotEmpty((String)names)) {
            String[] split;
            for (String threadName : split = names.split(",")) {
                excludeThreadNames.add(threadName);
            }
        }
        OperationContextCreator.getOrCreateForBos();
        boolean isWebNode = WebPortUtil.isWebNode();
        Map<String, String> params = UriQuery.toMap(exchange.getRequestURI().getQuery());
        String handlerUrl = super.getInnerHandlerUrl();
        String proxyurl = params.get("proxyurl");
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        this.outPrintTitle(out, params, proxyurl, handlerUrl, isWebNode);
        List<ThreadInfo> threads = this.getSortedThreadsInfo(proxyurl);
        this.outPrintDeadLock(out);
        this.outPrintState(threads, out);
        this.outPrintSearchBox(out, params, proxyurl, handlerUrl);
        this.outPrintStackTrace(threads, out, params, handlerUrl);
        out.close();
        String str = sw.toString();
        sw.close();
        byte[] bytes = str.getBytes("UTF-8");
        exchange.getResponseHeaders().set("Content-Type", "text/html; charset=UTF-8");
        exchange.sendResponseHeaders(202, bytes.length);
        exchange.getResponseBody().write(bytes);
        exchange.close();
    }

    private void outPrintSearchBox(PrintWriter out, Map<String, String> params, String proxyurl, String uri) {
        String threadname = params.get("threadname");
        if (threadname == null) {
            threadname = "";
        }
        params.put("threadname", threadname);
    }

    private void outPrintState(List<ThreadInfo> threads, PrintWriter out) {
        Integer[] data;
        HashMap<String, Integer[]> stats = new HashMap<String, Integer[]>(4);
        stats.put("others", new Integer[]{0, 0, 0, 0});
        for (ThreadInfo threadInfo : threads) {
            boolean find = false;
            for (String monitorThread : monitorThreadList) {
                if (threadInfo.thread.getName().indexOf(monitorThread) < 0) continue;
                Integer[] data2 = (Integer[])stats.get(monitorThread);
                if (data2 != null) {
                    this.fillThreadStatData(data2, threadInfo);
                } else {
                    data2 = new Integer[]{0, 0, 0, 0};
                    this.fillThreadStatData(data2, threadInfo);
                    stats.put(monitorThread, data2);
                }
                find = true;
            }
            if (find) continue;
            data = (Integer[])stats.get("others");
            this.fillThreadStatData(data, threadInfo);
        }
        out.println("<table>");
        out.println("<tr>");
        out.println("<td></td><td>WAITING</td><td>RUNNABLE</td><td>BLOCKED</td><td>TIMED_WAITING</td>");
        for (Map.Entry entry : stats.entrySet()) {
            String key = (String)entry.getKey();
            data = (Integer[])entry.getValue();
            out.println("<tr>");
            out.println("<td>" + key + TD_SUF_TD + data[0] + TD_SUF_TD + data[1] + TD_SUF_TD + data[2] + TD_SUF_TD + data[3] + "</td>");
            out.println("</tr>");
        }
        out.println("</tr>");
        out.println("</table>");
        out.println("<br/>");
    }

    private void fillThreadStatData(Integer[] data, ThreadInfo t) {
        if (t.thread.getState() == Thread.State.WAITING) {
            data[0] = data[0] + 1;
        } else if (t.thread.getState() == Thread.State.RUNNABLE) {
            data[1] = data[1] + 1;
        } else if (t.thread.getState() == Thread.State.BLOCKED) {
            data[2] = data[2] + 1;
        } else if (t.thread.getState() == Thread.State.TIMED_WAITING) {
            data[3] = data[3] + 1;
        }
    }

    private void outPrintStackTrace(List<ThreadInfo> threads, PrintWriter out, Map<String, String> params, String uri) {
        String tlive = params.get("live");
        String tlivesize = params.get("livesize");
        String threadname = params.get("threadname");
        String dbThread = params.get("isDbThread");
        String traceIdParam = params.get("traceId");
        boolean isDbThread = dbThread == null ? false : dbThread.equals("true");
        int livesize = 18;
        if (tlivesize != null) {
            try {
                livesize = Integer.parseInt(tlivesize);
            }
            catch (Exception e) {
                livesize = 18;
            }
        }
        boolean live = "true".equals(tlive) || "on".equals(tlive);
        long now = System.currentTimeMillis();
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        int lineno = 1;
        for (ThreadInfo t : threads) {
            String showThreadName;
            boolean isOutThread;
            String _threadName = t.threadname;
            StackTraceElement[] stes = t.stes;
            if (stes == null || !(isOutThread = this.isOutPrintThread(t, threadname, isDbThread, livesize, live, traceIdParam))) continue;
            int pos = _threadName.indexOf(TIME_STR);
            String traceId = null;
            StringBuilder sb = new StringBuilder();
            if (pos > 0) {
                showThreadName = _threadName.substring(0, pos);
                try {
                    long time = Long.parseLong(_threadName.substring(pos + TIME_STR.length(), pos + 13 + TIME_STR.length()));
                    cal.setTimeInMillis(time);
                    sb.append("[").append(Resources.getString((String)"\u5f53\u524d\u7ebf\u7a0b", (String)"ThreadDumpHandler_0", (String)"bos-monitor", (Object[])new Object[0])).append("] ").append(Resources.getString((String)"\u542f\u52a8\u65f6\u95f4", (String)"ThreadDumpHandler_1", (String)"bos-monitor", (Object[])new Object[0])).append(" : ").append(formatter.format(cal.getTime()));
                    sb.append(", ").append(Resources.getString((String)"\u5df2\u8fd0\u884c", (String)"ThreadDumpHandler_2", (String)"bos-monitor", (Object[])new Object[0])).append(" : ").append(now - time).append(Resources.getString((String)"\u6beb\u79d2", (String)"ThreadDumpHandler_3", (String)"bos-monitor", (Object[])new Object[0]));
                }
                catch (NumberFormatException e) {
                    showThreadName = _threadName;
                }
                int traceIdPos = _threadName.indexOf(TRACE_ID_STR);
                if (traceIdPos > 0) {
                    traceId = _threadName.substring(traceIdPos + TRACE_ID_STR.length()).split("/")[0];
                }
            } else {
                showThreadName = _threadName;
            }
            out.println("<a href=" + ThreadDumpUtil.encodeProxy(uri + "?threadname=" + _threadName, params.get("proxyurl")) + ">" + lineno++ + "_[" + showThreadName + "]</a><br>");
            if (traceId != null) {
                String url = System.getProperty("monitor.zipkin.url") + "/traces/" + traceId;
                sb.append(", traceId=").append(traceId).append(",&nbsp;").append("<a href=").append(url).append(">").append(Resources.getString((String)"\u67e5\u770b\u8c03\u7528\u94fe", (String)"ThreadDumpHandler_4", (String)"bos-monitor", (Object[])new Object[0])).append("</a>");
            }
            if (sb.length() > 0) {
                out.print("&nbsp;&nbsp;");
                out.print(sb);
                out.println("<br>");
            }
            if (t.memspanStr.length() > 0) {
                out.print(t.memspanStr);
            }
            if (pos > 0 && t.threadTraceStatistic != null && t.threadTraceStatistic.length() > 0) {
                out.println("&nbsp;&nbsp;[" + Resources.getString((String)"\u7ebf\u7a0b\u7edf\u8ba1", (String)"ThreadDumpHandler_5", (String)"bos-monitor", (Object[])new Object[0]) + "]<br>");
                out.println(t.threadTraceStatistic);
                out.println("<br>");
            }
            if (sb.length() > 0) {
                out.print("&nbsp;&nbsp;[" + Resources.getString((String)"\u7ebf\u7a0b\u5806\u6808", (String)"ThreadDumpHandler_6", (String)"bos-monitor", (Object[])new Object[0]) + "]<br>");
            }
            for (StackTraceElement ste : stes) {
                out.println("&nbsp;&nbsp;&nbsp;&nbsp;at  &nbsp;" + ste + "<br>");
            }
            out.println("<br>&nbsp;&nbsp;<br>");
        }
    }

    private boolean isOutPrintThread(ThreadInfo t, String threadname, boolean isDbThread, int livesize, boolean live, String traceIdParam) {
        String _threadName = t.threadname;
        for (String exclude : excludeThreadNames) {
            if (!_threadName.toLowerCase().contains(exclude.toLowerCase())) continue;
            return false;
        }
        StackTraceElement[] stes = t.stes;
        if (stes.length > 0 && stes[0] != null && stes[0].toString().contains("Thread.dumpThreads")) {
            return false;
        }
        if (StringUtils.isNotEmpty((String)threadname) && !_threadName.toLowerCase().contains(threadname.toLowerCase())) {
            return false;
        }
        if (_threadName.toLowerCase().contains("abandoned connection")) {
            return false;
        }
        for (StackTraceElement ste : stes) {
            if (!ste.toString().contains("ProxyHandler")) continue;
            return false;
        }
        if (live && stes.length < livesize) {
            return false;
        }
        if (StringUtils.isNotEmpty((String)traceIdParam)) {
            return _threadName.contains(traceIdParam);
        }
        return true;
    }

    private List<ThreadInfo> getSortedThreadsInfo(String proxyurl) {
        Map<Thread, StackTraceElement[]> m = Thread.getAllStackTraces();
        ArrayList<ThreadInfo> threads = new ArrayList<ThreadInfo>();
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        m.forEach((t, stes) -> {
            String threadName = t.getName();
            ThreadInfo threadInfo = new ThreadInfo(t.getName(), (StackTraceElement[])stes, (Thread)t);
            String threadTraceStatistic = TraceStatistics.getThreadTraceStatistic((Thread)t);
            if (threadTraceStatistic.length() > 0) {
                threadInfo.threadTraceStatistic = threadTraceStatistic;
            }
            threads.add(threadInfo);
            Map map = TracerImpl.getInstrumentMap((Thread)t);
            if (map != null) {
                map.forEach((k, v) -> {
                    cal.setTimeInMillis((long)v);
                    threadInfo.memspanStr.append("&nbsp;&nbsp;").append("[").append(Resources.getString((String)"\u5f53\u524d\u65b9\u6cd5", (String)"ThreadDumpHandler_7", (String)"bos-monitor", (Object[])new Object[0])).append("] ").append(Resources.getString((String)"\u5f00\u59cb\u65f6\u95f4", (String)"ThreadDumpHandler_8", (String)"bos-monitor", (Object[])new Object[0])).append(" : ").append(formatter.format(cal.getTime())).append(", ").append(Resources.getString((String)"\u5df2\u6267\u884c", (String)"ThreadDumpHandler_9", (String)"bos-monitor", (Object[])new Object[0])).append(" : ").append(System.currentTimeMillis() - v).append(Resources.getString((String)"\u6beb\u79d2", (String)"ThreadDumpHandler_10", (String)"bos-monitor", (Object[])new Object[0])).append(", ").append(Resources.getString((String)"\u6267\u884c\u65b9\u6cd5", (String)"ThreadDumpHandler_11", (String)"bos-monitor", (Object[])new Object[0])).append(" : ").append(k.getType()).append(".").append(k.getName());
                    Map tags = k.tags();
                    if (tags.containsKey("remoteUrl")) {
                        int traceIdPos = threadName.indexOf(TRACE_ID_STR);
                        String traceId = "";
                        if (traceIdPos > 0) {
                            traceId = threadName.substring(traceIdPos + TRACE_ID_STR.length()).split("/")[0];
                        }
                        threadInfo.memspanStr.append(this.getThreadDumpUrl((String)tags.get("remoteUrl"), traceId, proxyurl)).append("<br>");
                    } else {
                        threadInfo.memspanStr.append("<br>");
                    }
                    if (tags != null) {
                        tags.forEach((tk, tv) -> {
                            if (!"service".equals(tk) && !"remoteUrl".equals(tk)) {
                                threadInfo.memspanStr.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;").append("[ ").append((String)tk).append(" ]: ").append((String)tv).append("<br>");
                            }
                        });
                    }
                });
            }
        });
        return ThreadDumpHandler.sort(threads);
    }

    private String getThreadDumpUrl(String remoterUrl, String traceId, String proxyUrl) {
        StringBuilder sb = new StringBuilder();
        StringBuilder url = new StringBuilder("http:/");
        String[] split = remoterUrl.split(":");
        url.append(split[0]).append(":").append(ThreadDumpHandler.getMonitorPort(remoterUrl)).append("/monitor0/threaddump?threadname=RpcRequest&traceId=").append(traceId);
        String encodeProxy = ThreadDumpUtil.encodeProxy(url.toString(), proxyUrl);
        sb.append("<a target='_blank' href=").append(encodeProxy).append(">\u67e5\u8be2\u8fdc\u7a0b\u5806\u6808</a>");
        return sb.toString();
    }

    private static String getMonitorPort(String ip) {
        Map nodesMap = ClusterInstances.getAllOriginNodesString();
        try {
            for (Map.Entry entry : nodesMap.entrySet()) {
                String value = (String)entry.getValue();
                NodeInfo nodeInfo = (NodeInfo)JSONUtils.cast((String)value, NodeInfo.class, (boolean)true);
                if (!ip.contains(nodeInfo.getIp())) continue;
                return nodeInfo.getMonitorPort();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return MonitorConfig.getMonitorPort();
    }

    private void outPrintTitle(PrintWriter out, Map<String, String> params, String proxyurl, String uri, boolean isWebNode) {
        String ip = MonitorConfig.getNodeInfo().getIp();
        String title = Resources.getString((String)"\u7ebf\u7a0b\u5806\u6808", (String)"ThreadDumpHandler_12", (String)"bos-monitor", (Object[])new Object[0]) + ":" + ip + "/" + Instance.getInstanceId();
        out.println("<title>" + title + "</title>");
        out.println("<center><h1>" + title + "</h1></center>");
        out.println("<tr>");
        out.println(MAGIC + ThreadDumpUtil.encodeProxy(uri + "?live=false", proxyurl) + ">All thread" + MAGIC2 + "");
        out.println(MAGIC + ThreadDumpUtil.encodeProxy(uri + "?live=true", proxyurl) + ">living thread" + MAGIC2 + "");
        if (isWebNode || Instance.isWebMserviceInOne()) {
            out.println(MAGIC + ThreadDumpUtil.encodeProxy(uri + "?threadname=http-request-pool&live=false", proxyurl) + ">web request thread" + MAGIC2 + "");
            out.println(MAGIC + ThreadDumpUtil.encodeProxy(uri + "?threadname=http-request-pool&live=true", proxyurl) + ">living web request thread" + MAGIC2 + "");
        }
        if (!isWebNode || Instance.isWebMserviceInOne()) {
            out.println(MAGIC + ThreadDumpUtil.encodeProxy(uri + "?threadname=" + "RpcRequest" + "&live=false", proxyurl) + ">service thread" + MAGIC2 + "");
            out.println(MAGIC + ThreadDumpUtil.encodeProxy(uri + "?threadname=" + "RpcRequest" + "&live=true", proxyurl) + ">living service thread" + MAGIC2 + "");
        }
        out.println("</tr><br><br>");
    }

    private void outPrintDeadLock(PrintWriter out) {
        long[] deadlockedThreads = mbean.findDeadlockedThreads();
        if (deadlockedThreads == null || deadlockedThreads.length == 0) {
            return;
        }
        out.println("<font color=\"red\">Thread DeadLock checked!!!</font><br><br>");
        for (long pid : deadlockedThreads) {
            java.lang.management.ThreadInfo threadInfo = mbean.getThreadInfo(pid, Integer.MAX_VALUE);
            String s = threadInfo.toString();
            s = s.replaceAll("\n", "<br>").replaceAll("\t", "&nbsp;&nbsp;&nbsp;").replaceAll("owned by", "owned by Thread ");
            out.println("Thread " + s);
            out.println("<br>");
        }
    }

    public static List<ThreadInfo> sort(List<ThreadInfo> threads) {
        ThreadInfo[] threadIfs = threads.toArray(new ThreadInfo[0]);
        int size = threadIfs.length;
        for (int i = 0; i < size; ++i) {
            for (int j = 1; j < size - i; ++j) {
                ThreadInfo threadIf1 = threadIfs[j - 1];
                ThreadInfo threadIf2 = threadIfs[j];
                String preName = threadIf1.threadname;
                String sufName = threadIf2.threadname;
                int prePos = preName.indexOf(TIME_STR);
                int sufPos = sufName.indexOf(TIME_STR);
                if (prePos < 0 && sufPos > 0) {
                    ThreadInfo temp = threadIfs[j - 1];
                    threadIfs[j - 1] = threadIfs[j];
                    threadIfs[j] = temp;
                    continue;
                }
                if (prePos <= 0 || sufPos <= 0) continue;
                try {
                    long l1 = Long.parseLong(preName.substring(prePos + TIME_STR.length()));
                    long l2 = Long.parseLong(sufName.substring(sufPos + TIME_STR.length()));
                    if (l1 <= l2) continue;
                    ThreadInfo temp = threadIfs[j - 1];
                    threadIfs[j - 1] = threadIfs[j];
                    threadIfs[j] = temp;
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return Arrays.asList(threadIfs);
    }

    static {
        String[] split;
        excludeThreadNames = new HashSet<String>(6);
        DEFAULT_MONITOR_THREAD = "RpcRequest,MQ-rabbit-pool,http-request";
        monitorThreadList = new ArrayList<String>();
        mbean = ManagementFactory.getThreadMXBean();
        HIDDEN_THREADS = System.getProperty("monitor.hidden.threads", "HistoricalDataClearService,ShardingMovingService,MsgJetSubscirbe,PKTempTableDBRegistryHeartbeatService,PKTempTableDBRegistryClearService");
        String monitorThread = System.getProperty("monitor_threads", DEFAULT_MONITOR_THREAD);
        String[] threads = monitorThread.split(",");
        monitorThreadList.addAll(Arrays.asList(threads));
        excludeThreadNames.add("monitor-http");
        for (String threadName : split = HIDDEN_THREADS.split(",")) {
            excludeThreadNames.add(threadName);
        }
    }
}

