/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.trace;

import com.sun.net.httpserver.HttpExchange;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import kd.bos.monitor.httpserver.AbstractHttpHandler;
import kd.bos.monitor.metric.MetricHandler;
import kd.bos.monitor.util.ClassicTo404;
import kd.bos.monitor.util.UrlUtils;

public class TraceHandler
extends AbstractHttpHandler {
    private final String path;

    public TraceHandler(String path) {
        this.path = path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handle0(HttpExchange exchange) throws IOException {
        boolean disable = ClassicTo404.redirectTo404(exchange);
        if (disable) {
            return;
        }
        OutputStream os = null;
        InputStream in = null;
        try {
            exchange.getResponseHeaders().set("Content-Type", "text/html; charset=UTF-8");
            String baseUrl = UrlUtils.getHomeUrl(exchange, "tc");
            if (baseUrl.toLowerCase(Locale.ENGLISH).startsWith("http")) {
                baseUrl = baseUrl.substring(baseUrl.indexOf("//") + 2);
                baseUrl = baseUrl.substring(baseUrl.indexOf("/"));
            } else {
                int pos = baseUrl.indexOf("/traces");
                if (pos > 0) {
                    baseUrl = baseUrl.substring(0, pos + 1);
                }
            }
            in = MetricHandler.class.getResourceAsStream(this.path + "/trace.html");
            byte[] response = this.readBytes(in);
            response = this.replaceIndex(response, baseUrl);
            exchange.sendResponseHeaders(202, response.length);
            os = exchange.getResponseBody();
            os.write(response);
            exchange.close();
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    private byte[] replaceIndex(byte[] response, String baseUrl) throws UnsupportedEncodingException {
        String text = new String(response, "UTF-8");
        text = text.replace("{baseUrl}", baseUrl);
        return text.getBytes("UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readBytes(InputStream str) throws IOException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            int thisLine;
            while ((thisLine = str.read()) != -1) {
                bos.write(thisLine);
            }
            bos.flush();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }
}

