/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.trace;

import com.sun.net.httpserver.HttpExchange;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Map;
import kd.bos.monitor.httpserver.AbstractHttpHandler;
import kd.bos.monitor.metric.MetricHandler;
import kd.bos.monitor.util.UrlUtils;

public class TraceSpecialResourceHandler
extends AbstractHttpHandler {
    private final String path;

    public TraceSpecialResourceHandler(String path, Map<String, String> variables) {
        this.path = path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handle0(HttpExchange pExchange) throws IOException {
        URI uri = pExchange.getRequestURI();
        OutputStream os = null;
        InputStream in = null;
        try {
            int lastindex;
            String reqPath;
            String res;
            String httpRootUrl = UrlUtils.getMonitorRootUrl(pExchange);
            if (httpRootUrl.endsWith("/")) {
                httpRootUrl = httpRootUrl.substring(0, httpRootUrl.length() - 1);
            }
            if (!(res = (reqPath = uri.getPath()).substring((lastindex = reqPath.lastIndexOf("/")) + 1)).startsWith("/")) {
                res = "/" + res;
            }
            if ((in = MetricHandler.class.getResourceAsStream(this.path + res)) == null) {
                pExchange.sendResponseHeaders(404, 0L);
                pExchange.close();
                return;
            }
            if (reqPath.endsWith(".js")) {
                pExchange.getResponseHeaders().set("Content-Type", "text/javascript; charset=UTF-8");
            } else if (reqPath.endsWith(".jsx")) {
                pExchange.getResponseHeaders().set("Content-Type", "text/javascript; charset=UTF-8");
            } else if (reqPath.endsWith(".css")) {
                pExchange.getResponseHeaders().set("Content-Type", "text/css; charset=UTF-8");
            } else if (reqPath.endsWith(".html")) {
                pExchange.getResponseHeaders().set("Content-Type", "text/html; charset=UTF-8");
            } else if (reqPath.endsWith(".json")) {
                pExchange.getResponseHeaders().set("Content-Type", "application/json; charset=UTF-8");
            } else if (reqPath.endsWith(".properties")) {
                pExchange.getResponseHeaders().set("Content-Type", "text/html; charset=UTF-8");
            }
            byte[] response = this.readBytes(in);
            pExchange.sendResponseHeaders(202, response.length);
            os = pExchange.getResponseBody();
            os.write(response);
            pExchange.close();
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readBytes(InputStream str) throws IOException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            int thisLine;
            while ((thisLine = str.read()) != -1) {
                bos.write(thisLine);
            }
            bos.flush();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }
}

