/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.util;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassUtil {
    public static List<Class<?>> getAllClassByPackageName(Package pkg) {
        String packageName = pkg.getName();
        List<Class<?>> returnClassList = ClassUtil.getClasses(packageName);
        return returnClassList;
    }

    public static List<Class<?>> getAllClassByInterface(Class<?> c) {
        ArrayList returnClassList = null;
        if (!c.isInterface()) {
            return null;
        }
        String packageName = c.getPackage().getName();
        List<Class<?>> allClass = ClassUtil.getClasses(packageName);
        if (allClass == null) {
            return null;
        }
        returnClassList = new ArrayList();
        for (Class<?> cls : allClass) {
            if (!c.isAssignableFrom(cls) || c.equals(cls)) continue;
            returnClassList.add(cls);
        }
        return returnClassList;
    }

    public static String[] getPackageAllClassName(String classLocation, String packageName) {
        String[] packagePathSplit = packageName.split("[.]");
        StringBuilder realClassLocation = new StringBuilder(classLocation);
        int packageLength = packagePathSplit.length;
        for (int i = 0; i < packageLength; ++i) {
            realClassLocation.append(File.separator).append(packagePathSplit[i]);
        }
        File packeageDir = new File(realClassLocation.toString());
        if (packeageDir.isDirectory()) {
            String[] allClassName = packeageDir.list();
            return allClassName;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<Class<?>> getClasses(String packageName) {
        ArrayList classes = new ArrayList();
        boolean recursive = true;
        String packageDirName = packageName.replace('.', '/');
        try {
            Enumeration<URL> dirs = Thread.currentThread().getContextClassLoader().getResources(packageDirName);
            while (dirs.hasMoreElements()) {
                URL url = dirs.nextElement();
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                    ClassUtil.findAndAddClassesInPackageByFile(packageName, filePath, recursive, classes);
                    continue;
                }
                if (!"jar".equals(protocol)) continue;
                try {
                    JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
                    Enumeration<JarEntry> entries = jar.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        String name = entry.getName();
                        if (name.charAt(0) == '/') {
                            name = name.substring(1);
                        }
                        if (!name.startsWith(packageDirName)) continue;
                        int idx = name.lastIndexOf(47);
                        if (idx != -1) {
                            packageName = name.substring(0, idx).replace('/', '.');
                        }
                        if (idx == -1 && !recursive || !name.endsWith(".class") || entry.isDirectory()) continue;
                        String className = name.substring(packageName.length() + 1, name.length() - 6);
                        try {
                            classes.add(Class.forName(packageName + '.' + className));
                        }
                        catch (ClassNotFoundException e) {}
                    }
                }
                catch (IOException e) {
                    return classes;
                }
            }
        }
        catch (IOException e) {
            return classes;
        }
    }

    private static void findAndAddClassesInPackageByFile(String packageName, String packagePath, final boolean recursive, List<Class<?>> classes) {
        File[] dirfiles;
        File dir = new File(packagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        for (File file : dirfiles = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return recursive && file.isDirectory() || file.getName().endsWith(".class");
            }
        })) {
            try {
                if (file.isDirectory()) {
                    ClassUtil.findAndAddClassesInPackageByFile(packageName + "." + file.getName(), file.getCanonicalPath(), recursive, classes);
                    continue;
                }
                String className = file.getName().substring(0, file.getName().length() - 6);
                classes.add(Class.forName(packageName + '.' + className));
            }
            catch (IOException | ClassNotFoundException e) {
                // empty catch block
            }
        }
    }
}

