/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.util;

import com.google.common.io.CharStreams;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import kd.bos.monitor.httpserver.Redirectable;
import kd.bos.monitor.util.UriQuery;

public class ExchangeUtils {
    public static void redirect(HttpExchange exchange, String url) throws IOException {
        if (exchange instanceof Redirectable) {
            ((Redirectable)((Object)exchange)).sendRedirect(url);
        } else {
            exchange.getResponseHeaders().add("Location", url);
            exchange.sendResponseHeaders(301, -1L);
            exchange.close();
        }
    }

    public static Map<String, String> parseParameters(HttpExchange exchange) throws IOException {
        if ("post".equalsIgnoreCase(exchange.getRequestMethod())) {
            return ExchangeUtils.parsePostParameters(exchange);
        }
        return ExchangeUtils.parseGetParameters(exchange);
    }

    private static Map<String, String> parseGetParameters(HttpExchange exchange) {
        URI uri = exchange.getRequestURI();
        String query = uri.getQuery();
        return UriQuery.toMap(query);
    }

    public static Map<String, String> parsePostParameters(HttpExchange exchange) throws IOException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        InputStreamReader isr = new InputStreamReader(exchange.getRequestBody(), "utf-8");
        String query = CharStreams.toString((Readable)isr);
        ExchangeUtils.parseQuery(query, parameters);
        return parameters;
    }

    private static void parseQuery(String query, Map<String, String> parameters) throws UnsupportedEncodingException {
        if (query != null) {
            String[] pairs = query.split("[&]");
            String encoding = System.getProperty("file.encoding");
            for (String pair : pairs) {
                String[] param = pair.split("[=]");
                String key = null;
                String value = null;
                if (param.length > 0) {
                    key = URLDecoder.decode(param[0], encoding);
                }
                if (param.length > 1) {
                    value = URLDecoder.decode(param[1], encoding);
                }
                parameters.put(key, value);
            }
        }
    }
}

