/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.monitor.util;

import com.sun.net.httpserver.HttpExchange;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class UrlUtils {
    private static final String IERP = "/ierp";
    private static final String HTTPS = "https";

    public static String getHomeUrl(HttpExchange exchange, String context) {
        String url = System.getProperty("monitor.urlcontext");
        if (url == null) {
            url = System.getProperty("monitor.url");
        }
        if (url != null) {
            if (!url.endsWith("/")) {
                url = url + "/";
            }
            if (context != null) {
                url = url + context;
            }
            if (!url.endsWith("/")) {
                url = url + "/";
            }
            return url;
        }
        url = exchange.getRequestURI().getRawPath();
        if (url.endsWith("/monitor")) {
            url = url + "/";
        }
        url = url.substring(0, url.lastIndexOf("/") + 1);
        return url;
    }

    public static String getMonitorRootUrl(HttpExchange exchange) {
        String url = exchange.getRequestURI().toString();
        if (url.startsWith(IERP)) {
            url = url.substring(IERP.length());
        }
        int pos = url.indexOf("/monitor");
        url = url.substring(0, pos) + "/";
        return UrlUtils.getFullHostUrl(exchange) + url;
    }

    public static String getMonitorUriContext(HttpExchange exchange) {
        String url = exchange.getRequestURI().toString();
        if (url.startsWith(IERP)) {
            return IERP;
        }
        return "";
    }

    public static String getContext(HttpExchange exchange) {
        String url = UrlUtils.getFullHostUrl(exchange);
        String context = exchange.getRequestURI().getPath();
        if (context.startsWith(IERP)) {
            context = context.substring(IERP.length());
        }
        return url + context;
    }

    private static String getFullHostUrl(HttpExchange exchange) {
        String url = System.getProperty("monitor.urlcontext");
        if (url != null) {
            return url;
        }
        String host = exchange.getRequestHeaders().getFirst("host");
        String context = exchange.getRequestHeaders().getFirst("context");
        String protocol = null;
        String s = exchange.getRequestHeaders().getFirst(HTTPS);
        boolean https = false;
        https = s != null ? "1".equals(s) : exchange.getProtocol().toLowerCase().contains(HTTPS);
        protocol = https ? HTTPS : "http";
        url = protocol + "://" + host;
        if (context != null) {
            url = context.startsWith("/") ? url + context : url + "/" + context;
        }
        return url;
    }

    public static String encode(String url) {
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static String encodeProxy(String uri, String proxyurl) {
        if (proxyurl == null) {
            return uri;
        }
        try {
            String url = URLEncoder.encode(uri, "UTF-8");
            url = proxyurl + "?url=" + url;
            return url;
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static String encodeProxy0(String uri, String proxyurl) {
        if (proxyurl == null) {
            return uri;
        }
        proxyurl = proxyurl + "0";
        try {
            String url = URLEncoder.encode(uri, "UTF-8");
            url = proxyurl + "?url=" + url;
            return url;
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }
}

