/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import kd.bos.exception.KDException;
import kd.bos.framework.lifecycle.Service;
import kd.bos.instance.Instance;
import kd.bos.instance.ServiceStatus;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.MServiceErrorCode;
import kd.bos.mservice.catalog.ServiceCatalogCenter;
import kd.bos.mservice.catalog.ServiceCatalogFactory;
import kd.bos.mservice.config.MserviceAssemblyConfig;
import kd.bos.mservice.discovery.KRegistryInstanceCatalog;
import kd.bos.mservice.spi.define.MServiceDefineMeta;
import kd.bos.mservice.spi.define.MServiceDefineSPI;
import kd.bos.service.register.ServiceRegister;

public class MServiceDefineService
implements Service {
    private boolean fIsStarted;
    private static Log log = LogFactory.getLog(MServiceDefineService.class);
    private Set<String> hasRegister = new HashSet<String>();

    public String getName() {
        return "MServiceDefineManager";
    }

    public boolean isStarted() {
        return this.fIsStarted;
    }

    public void start() {
        this.hasRegister.add(null);
        this.loadAndRegistry();
        if ("dubbo".equals(MserviceAssemblyConfig.getMserviceRpcType())) {
            ServiceStatus.finishRpcServiceStarting();
        }
        this.fIsStarted = true;
    }

    private void loadAndRegistry() {
        ServiceLoader<MServiceDefineSPI> loaders = ServiceLoader.load(MServiceDefineSPI.class);
        ServiceCatalogCenter catalog = ServiceCatalogFactory.getCatalogCenter();
        HashMap<String, MServiceDefineMeta> allDefines = new HashMap<String, MServiceDefineMeta>(2);
        for (MServiceDefineSPI mserviceloader : loaders) {
            try {
                Map defines = mserviceloader.loadMetaDefine();
                catalog.regist(mserviceloader.type(), defines);
                allDefines.putAll(defines);
            }
            catch (Exception e) {
                log.error("MServiceDeclare error," + mserviceloader.getClass().getName(), (Throwable)e);
            }
        }
        this.cacheDefinedService(allDefines);
        this.registerInvokeServiceDefault();
        this.registerDefinedService(allDefines);
    }

    private void cacheDefinedService(Map<String, MServiceDefineMeta> allDefines) {
        for (Map.Entry<String, MServiceDefineMeta> tempEntry : allDefines.entrySet()) {
            KRegistryInstanceCatalog.registerDefineMeta((MServiceDefineMeta)tempEntry.getValue());
        }
    }

    private void registerDefinedService(Map<String, MServiceDefineMeta> allDefines) {
        allDefines.forEach((tpye, define) -> {
            if (!define.isRegisterOrginalInteface()) {
                return;
            }
            String serviceName = define.getServiceName();
            String serviceInterface = define.getServiceInterface();
            if (serviceInterface == null) {
                return;
            }
            String serviceImpl = define.getServiceImplClass();
            Set transTypes = define.getTransProtocolTypes();
            String appids = this.getAppIds(serviceName, define.getAppIds());
            String appIdvalue = Instance.isAppSplit() ? "\nappIds=" + appids : "";
            for (String transTpye : transTypes) {
                String consumerKey = serviceName + ".consumer";
                String consumerValue = "interface=" + serviceInterface;
                String serviceKey = serviceName + ".service";
                String serviceValue = String.format("interface=%s\nclass=%s", serviceInterface, serviceImpl);
                consumerValue = consumerValue + "\ntransProtocolType=" + transTpye + appIdvalue;
                serviceValue = serviceValue + "\ntransProtocolType=" + transTpye + appIdvalue;
                this.registerServiceAndConsumer(consumerKey, consumerValue, serviceKey, serviceValue, transTpye, false);
            }
        });
    }

    private String getAppIds(String serviceName, String[] appIds) {
        String[] sysAppIds;
        if (appIds == null || appIds.length == 0) {
            throw new KDException(MServiceErrorCode.serviceNotDefineAppID, new Object[]{serviceName});
        }
        String[] thisAppIds = appIds;
        if (appIds.length == 1 && "*".equals(appIds[0]) && (sysAppIds = Instance.getAppIds()) != null && sysAppIds.length > 0) {
            thisAppIds = sysAppIds;
        }
        StringBuilder sb = new StringBuilder();
        for (String appId : thisAppIds) {
            sb.append(appId).append(",");
        }
        return sb.substring(0, sb.length() - 1);
    }

    private void registerServiceAndConsumer(String cusomeKey, String cusomeValue, String serviceKey, String serviceValue, String transTpye, boolean isInvokeService) {
        String[] configNames = Instance.getConfigAppName();
        String configDubboAppService = System.getProperty("dubbo.service.configAppName", "");
        if (configDubboAppService.length() > 0) {
            configNames = configDubboAppService.split(",");
        }
        if (!isInvokeService && configNames.length == 1 && "web".equals(configNames[0]) && this.hasRegister.add(cusomeKey + transTpye)) {
            try {
                ServiceRegister.registerConsumer((String)cusomeKey, (String)cusomeValue);
                log.info(String.format("regisger consumer: %s %s ", cusomeKey, cusomeValue));
            }
            catch (Exception e) {
                log.error(String.format("regisger consumer error: %s %s ", cusomeKey, cusomeValue), (Throwable)e);
            }
        } else {
            if (this.hasRegister.add(serviceKey + transTpye)) {
                try {
                    ServiceRegister.registerService((String)serviceKey, (String)serviceValue);
                    log.info(String.format("regisger service: %s %s ", serviceKey, serviceValue));
                }
                catch (Exception e) {
                    log.error(String.format("regisger service error: %s %s ", cusomeKey, cusomeValue), (Throwable)e);
                }
            }
            if (this.hasRegister.add(cusomeKey + transTpye)) {
                try {
                    ServiceRegister.registerConsumer((String)cusomeKey, (String)cusomeValue);
                    log.info(String.format("regisger consumer: %s %s ", cusomeKey, cusomeValue));
                }
                catch (Exception e) {
                    log.error(String.format("regisger consumer error: %s %s ", cusomeKey, cusomeValue), (Throwable)e);
                }
            }
        }
    }

    private void registerInvokeServiceDefault() {
        String[] transTpyes;
        for (String transTpye : transTpyes = new String[]{"rpc", "http"}) {
            String consumerKey = "InvokeService.consumer";
            String consumerValue = "interface=kd.bos.service.InvokeService";
            String serviceKey = "invoke.service";
            String serviceValue = "interface=kd.bos.service.InvokeService\nclass=kd.bos.service.invoke.InvokeServiceImpl";
            consumerValue = consumerValue + "\ntransProtocolType=" + transTpye;
            serviceValue = serviceValue + "\ntransProtocolType=" + transTpye;
            this.registerServiceAndConsumer(consumerKey, consumerValue, serviceKey, serviceValue, transTpye, true);
        }
    }

    public void stop() {
        this.fIsStarted = false;
    }
}

