/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.catalog;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.mservice.catalog.ServiceCatalog;
import kd.bos.mservice.catalog.view.MServiceInfo;
import kd.bos.mservice.spi.define.MServiceDefineMeta;

public class LocalServiceCatalog
implements ServiceCatalog {
    private Map<String, MServiceDefineMeta> serviceDefineMap = new ConcurrentHashMap<String, MServiceDefineMeta>(2);
    private Map<String, List<MServiceDefineMeta>> type2serviceDefinesMap = new ConcurrentHashMap<String, List<MServiceDefineMeta>>(2);
    private Map<String, MServiceInfo> serviceInfoMap = new ConcurrentHashMap<String, MServiceInfo>(2);
    private Map<String, List<MServiceInfo>> type2serviceInfosMap = new ConcurrentHashMap<String, List<MServiceInfo>>(2);
    private Map<String, String> serviceTypeMap = new ConcurrentHashMap<String, String>(2);

    @Override
    public void regist(String type, Map<String, MServiceDefineMeta> serviceDefineMap, Map<String, MServiceInfo> serviceInfoMap) {
        this.registMServiceDefine(type, serviceDefineMap);
        this.registMServiceInfo(type, serviceInfoMap);
    }

    private void registMServiceDefine(String type, Map<String, MServiceDefineMeta> serviceDefineMetaMap) {
        List serviceDefineList = this.type2serviceDefinesMap.computeIfAbsent(type, k -> new ArrayList(2));
        serviceDefineMetaMap.forEach((serviceName, serviceDefine) -> {
            String pretype = this.serviceTypeMap.get(serviceName);
            if (pretype != null) {
                throw new KDException(new ErrorCode("###", "%s has declared by %s"), new Object[]{serviceName, pretype});
            }
            this.serviceTypeMap.put((String)serviceName, type);
            serviceDefineList.add(serviceDefine);
        });
        this.serviceDefineMap.putAll(serviceDefineMetaMap);
    }

    private void registMServiceInfo(String type, Map<String, MServiceInfo> mServiceInfoMap) {
        List serviceInfoList = this.type2serviceInfosMap.computeIfAbsent(type, k -> new ArrayList(2));
        mServiceInfoMap.forEach((serviceName, serviceInfo) -> serviceInfoList.add(serviceInfo));
        this.serviceInfoMap.putAll(mServiceInfoMap);
    }

    @Override
    public MServiceDefineMeta findServiceDefine(String serviceName) {
        return this.serviceDefineMap.get(serviceName);
    }

    @Override
    public Map<String, MServiceDefineMeta> getAllServiceDefine() {
        return Collections.unmodifiableMap(this.serviceDefineMap);
    }

    @Override
    public Map<String, List<MServiceDefineMeta>> getServiceDefineOfType() {
        return Collections.unmodifiableMap(this.type2serviceDefinesMap);
    }

    @Override
    public MServiceInfo findServiceInfo(String serviceName) {
        return this.serviceInfoMap.get(serviceName);
    }

    @Override
    public Map<String, MServiceInfo> getAllServiceInfo() {
        return Collections.unmodifiableMap(this.serviceInfoMap);
    }

    @Override
    public Map<String, List<MServiceInfo>> getServiceInfoOfType() {
        return Collections.unmodifiableMap(this.type2serviceInfosMap);
    }
}

