/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.catalog.view;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CatalogNode {
    private String name;
    private Map<String, CatalogNode> childrensMap = new LinkedHashMap<String, CatalogNode>(2);
    private String pkg;

    public CatalogNode(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CatalogNode getChild(String name) {
        return this.childrensMap.get(name);
    }

    public List<CatalogNode> getChildren() {
        return new ArrayList<CatalogNode>(this.childrensMap.values());
    }

    public String getPkg() {
        return this.pkg;
    }

    public void setPkg(String pkg) {
        this.pkg = pkg;
    }

    public void addPackage(String packages) {
        if (packages == null || packages.length() == 0) {
            return;
        }
        String[] pkgs = packages.split("\\.");
        this.addChild(0, packages, pkgs, this);
    }

    private void addChild(int i, String packages, String[] pkgs, CatalogNode catalogNode) {
        if (i >= pkgs.length) {
            catalogNode.setPkg(packages);
            return;
        }
        String childName = pkgs[i];
        CatalogNode child = catalogNode.getChild(childName);
        if (child == null) {
            child = new CatalogNode(childName);
            catalogNode.addChild(child);
        }
        this.addChild(i + 1, packages, pkgs, child);
    }

    private void addChild(CatalogNode child) {
        this.childrensMap.put(child.name, child);
    }
}

