/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.define.jersey;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Path;
import kd.bos.mservice.manage.KServiceProviderLoader;
import kd.bos.mservice.spi.define.MServiceDefineMeta;
import kd.bos.mservice.spi.define.MServiceDefineSPI;
import kd.bos.mservice.spi.define.MServiceParameterParser;

public class JerseyMServiceDefine
implements MServiceDefineSPI {
    public String type() {
        return "jaxrs";
    }

    public Map<String, MServiceDefineMeta> loadMetaDefine() {
        Set<String> serviceNames = KServiceProviderLoader.loadKservice(this.type(), this.getClass().getClassLoader());
        HashMap<String, MServiceDefineMeta> serviceDefineMap = new HashMap<String, MServiceDefineMeta>();
        serviceNames.forEach(mserviceDefineClassStr -> {
            Class<?> mserviceDefineClass;
            try {
                mserviceDefineClass = Class.forName(mserviceDefineClassStr, false, this.getClass().getClassLoader());
            }
            catch (Exception e) {
                return;
            }
            Path path = mserviceDefineClass.getAnnotation(Path.class);
            MServiceDefineMeta mdm = new MServiceDefineMeta();
            String url = path.value();
            Class<?>[] interfaces = mserviceDefineClass.getInterfaces();
            mdm.setGroup("jaxrs");
            mdm.setServiceName(interfaces.length > 0 ? interfaces[0].getName() : mserviceDefineClass.getName());
            mdm.setServiceImplClass(mserviceDefineClass.getName());
            mdm.setAppIds(new String[]{"*"});
            mdm.setServiceDesc(url);
            mdm.setServiceInterface(interfaces.length > 0 ? interfaces[0].getName() : mserviceDefineClass.getName());
            mdm.addTransProtocolTypes("http");
            mdm.addDataCodecs("json");
            serviceDefineMap.put(mdm.getServiceName(), mdm);
            Method[] methods = mserviceDefineClass.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].isAnnotationPresent(Path.class)) continue;
                Path methodPath = methods[i].getAnnotation(Path.class);
                MServiceDefineMeta.MethodDefine mDefine = new MServiceDefineMeta.MethodDefine();
                mdm.addMethod(mDefine);
                mDefine.setServiceMethodName(methods[i].getName());
                mDefine.setServiceMethodPath(url + methodPath.value());
                mDefine.setServiceMethodDesc(methods[i].getName());
                mDefine.setServiceMethodReturnObjectType(methods[i].getGenericReturnType().getTypeName());
                mDefine.setServiceMethodReturnParamDefine(MServiceParameterParser.parseParam((Type)methods[i].getGenericReturnType()));
                Parameter[] parameters = methods[i].getParameters();
                String[] parameterNames = MServiceParameterParser.getParameterNames((Method)methods[i]);
                for (int j = 0; j < parameters.length; ++j) {
                    MServiceDefineMeta.ParamDefine pd = MServiceParameterParser.parseParam((String)parameterNames[j], (Parameter)parameters[j]);
                    mDefine.addServiceMethodParam(pd);
                }
            }
        });
        return serviceDefineMap;
    }
}

